[misk](../../index.md) / [misk.web](../index.md) / [NetworkInterceptor](./index.md)

# NetworkInterceptor

`interface NetworkInterceptor`

### Types

| Name | Summary |
|---|---|
| [Factory](-factory/index.md) | `interface Factory` |

### Functions

| Name | Summary |
|---|---|
| [intercept](intercept.md) | `abstract fun intercept(chain: `[`NetworkChain`](../-network-chain/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Inheritors

| Name | Summary |
|---|---|
| [ExceptionHandlingInterceptor](../../misk.web.exceptions/-exception-handling-interceptor/index.md) | `class ExceptionHandlingInterceptor : `[`NetworkInterceptor`](./index.md)<br>Converts and logs application and component level dispatch exceptions into the appropriate response format. Allows application and component code to control how exceptions are represented to clients; for example by setting the status code appropriately, or by returning a specialized response format specific to the error. Components can control how exceptions are mapped by installing [ExceptionMapper](../../misk.web.exceptions/-exception-mapper/index.md) via the [ExceptionMapperModule](../../misk.web.exceptions/-exception-mapper-module/index.md) |
| [RebalancingInterceptor](../../misk.web.interceptors/-rebalancing-interceptor/index.md) | `class RebalancingInterceptor : `[`NetworkInterceptor`](./index.md)<br>When we're deploying and redeploying our pods, we want to make sure that clients rebalance onto the new pods. This randomly closes connections so they will be recreated, naturally balancing connections across pods. |
| [RequestLoggingInterceptor](../../misk.web.interceptors/-request-logging-interceptor/index.md) | `class RequestLoggingInterceptor : `[`NetworkInterceptor`](./index.md)<br>Logs request and response information for an action. Timing information doesn't count time writing the response to the remote client. |
