[misk](../../index.md) / [misk.web](../index.md) / [PathPattern](./index.md)

# PathPattern

`class PathPattern : `[`Comparable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)`<`[`PathPattern`](./index.md)`>`

A path with placeholders for variables. Paths may be constant like `/app/home/` or dynamic like
`/user/{username}`. Variables are delimited by curly braces and may specify an optional regex
like this: `{username:[a-z]+}`. If no regex is specified the variable is a sequence of non-'/'
characters.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `PathPattern(pattern: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, regex: `[`Pattern`](https://docs.oracle.com/javase/8/docs/api/java/util/regex/Pattern.html)`, variableNames: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`>, numRegexVariables: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, numSegments: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, matchesWildcardPath: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`)`<br>A path with placeholders for variables. Paths may be constant like `/app/home/` or dynamic like `/user/{username}`. Variables are delimited by curly braces and may specify an optional regex like this: `{username:[a-z]+}`. If no regex is specified the variable is a sequence of non-'/' characters. |

### Properties

| Name | Summary |
|---|---|
| [matchesWildcardPath](matches-wildcard-path.md) | `val matchesWildcardPath: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [numRegexVariables](num-regex-variables.md) | `val numRegexVariables: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [numSegments](num-segments.md) | `val numSegments: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [pattern](pattern.md) | `val pattern: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [regex](regex.md) | `val regex: `[`Pattern`](https://docs.oracle.com/javase/8/docs/api/java/util/regex/Pattern.html) |
| [variableNames](variable-names.md) | `val variableNames: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`>` |

### Functions

| Name | Summary |
|---|---|
| [compareTo](compare-to.md) | `fun compareTo(other: `[`PathPattern`](./index.md)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Compares path patterns by specificity with the more specific pattern ordered first. |
| [equals](equals.md) | `fun equals(other: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [hashCode](hash-code.md) | `fun hashCode(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [matcher](matcher.md) | `fun matcher(requestUrl: HttpUrl): `[`Matcher`](https://docs.oracle.com/javase/8/docs/api/java/util/regex/Matcher.html)`?`<br>Returns a Matcher if requestUrl can be matched, else null |
| [toString](to-string.md) | `fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [parse](parse.md) | `fun parse(pattern: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`PathPattern`](./index.md) |
