[misk](../../index.md) / [misk.web](../index.md) / [WebConfig](./index.md)

# WebConfig

`data class WebConfig : `[`Config`](../../misk.config/-config.md)

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `WebConfig(port: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, idle_timeout: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, host: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`? = null, ssl: `[`WebSslConfig`](../-web-ssl-config/index.md)`? = null, unix_domain_socket: `[`WebUnixDomainSocketConfig`](../-web-unix-domain-socket-config/index.md)`? = null, http2: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = false, selectors: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`? = null, acceptors: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`? = null, queue_size: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`? = null, jetty_max_thread_pool_size: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 200, jetty_max_thread_pool_queue_size: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 300, enable_thread_pool_queue_metrics: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = false, action_exception_log_level: `[`ActionExceptionLogLevelConfig`](../../misk.web.exceptions/-action-exception-log-level-config/index.md)` = ActionExceptionLogLevelConfig(), jetty_max_concurrent_streams: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`? = null, close_connection_percent: `[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)` = 0.01, gzip: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = true, minGzipSize: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 1024)` |

### Properties

| Name | Summary |
|---|---|
| [acceptors](acceptors.md) | `val acceptors: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`?`<br>Number of acceptor threads. |
| [action_exception_log_level](action_exception_log_level.md) | `val action_exception_log_level: `[`ActionExceptionLogLevelConfig`](../../misk.web.exceptions/-action-exception-log-level-config/index.md) |
| [close_connection_percent](close_connection_percent.md) | `val close_connection_percent: `[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)<br>A value in [0.0..100.0](#). Include 'Connection: close' in this percentage of responses. |
| [enable_thread_pool_queue_metrics](enable_thread_pool_queue_metrics.md) | `val enable_thread_pool_queue_metrics: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Flag to enable thread pool queue metrics |
| [gzip](gzip.md) | `val gzip: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>If true responses which are larger than the minGzipSize will be compressed. Gzip compression always enabled for requests and cannot be turned off. |
| [host](host.md) | `val host: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?`<br>The network interface to bind to. Null or 0.0.0.0 to bind to all interfaces. |
| [http2](http2.md) | `val http2: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>HTTP/2 support is currently opt-in because we can't load balance it dynamically. |
| [idle_timeout](idle_timeout.md) | `val idle_timeout: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>If a connection is unused for this many milliseconds, it is closed. |
| [jetty_max_concurrent_streams](jetty_max_concurrent_streams.md) | `val jetty_max_concurrent_streams: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`?`<br>The maximum number of streams per HTTP/2 connection. |
| [jetty_max_thread_pool_queue_size](jetty_max_thread_pool_queue_size.md) | `val jetty_max_thread_pool_queue_size: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Maximum number of items in the queue for Jetty's thread pool. |
| [jetty_max_thread_pool_size](jetty_max_thread_pool_size.md) | `val jetty_max_thread_pool_size: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Maximum number of threads in Jetty's thread pool. |
| [minGzipSize](min-gzip-size.md) | `val minGzipSize: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The minimum size in bytes before the response body will be compressed. |
| [port](port.md) | `val port: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>HTTP port to listen on, or 0 for any available port. |
| [queue_size](queue_size.md) | `val queue_size: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`?`<br>The accept backlog. |
| [selectors](selectors.md) | `val selectors: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`?`<br>Number of NIO selector threads. |
| [ssl](ssl.md) | `val ssl: `[`WebSslConfig`](../-web-ssl-config/index.md)`?` |
| [unix_domain_socket](unix_domain_socket.md) | `val unix_domain_socket: `[`WebUnixDomainSocketConfig`](../-web-unix-domain-socket-config/index.md)`?`<br>Configuration to enable Jetty to listen for traffic on a unix domain socket being proxied through a sidecar (like Envoy). |
