[misk](../index.md) / [misk.web](./index.md)

## Package misk.web

### Types

| Name | Summary |
|---|---|
| [DispatchMechanism](-dispatch-mechanism/index.md) | `enum class DispatchMechanism`<br>Describes how an action is processed. This is like the HTTP method but has special cases for web sockets and gRPC. These protocols layer on top of HTTP methods and have different semantics. |
| [HttpCall](-http-call/index.md) | `interface HttpCall`<br>A live HTTP call from a client for use by a chain of network interceptors. |
| [MiskWebModule](-misk-web-module/index.md) | `class MiskWebModule : KAbstractModule` |
| [NetworkChain](-network-chain/index.md) | `interface NetworkChain` |
| [NetworkInterceptor](-network-interceptor/index.md) | `interface NetworkInterceptor` |
| [PathPattern](-path-pattern/index.md) | `class PathPattern : `[`Comparable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)`<`[`PathPattern`](-path-pattern/index.md)`>`<br>A path with placeholders for variables. Paths may be constant like `/app/home/` or dynamic like `/user/{username}`. Variables are delimited by curly braces and may specify an optional regex like this: `{username:[a-z]+}`. If no regex is specified the variable is a sequence of non-'/' characters. |
| [RequestTypes](-request-types/index.md) | `class RequestTypes`<br>Provides a mapping from field name to Type definition given a KType. Useful for processes that want to have a schema definition of a type. For example: used by the WebActions admin dashboard tab to show a statically typed form containing request fields for developers to fill out. Currently only supports Wire request type messages; non-Wire messages return an empty mapping. |
| [SocketAddress](-socket-address/index.md) | `sealed class SocketAddress`<br>Information about the socket on which a HTTP call arrived. |
| [WebActionModule](-web-action-module/index.md) | `class WebActionModule<A : WebAction> : KAbstractModule` |
| [WebConfig](-web-config/index.md) | `data class WebConfig : `[`Config`](../misk.config/-config.md) |
| [WebSslConfig](-web-ssl-config/index.md) | `data class WebSslConfig` |
| [WebUnixDomainSocketConfig](-web-unix-domain-socket-config/index.md) | `data class WebUnixDomainSocketConfig` |

### Extensions for External Classes

| Name | Summary |
|---|---|
| [kotlin.String](kotlin.-string/index.md) |  |
| [okhttp3.Response](okhttp3.-response/index.md) |  |

### Functions

| Name | Summary |
|---|---|
| [readUtf8](read-utf8.md) | `fun Response<*>.readUtf8(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
