/*
 * Decompiled with CFR 0.152.
 */
package misk.tracing.backends.zipkin;

import brave.Tracing;
import brave.opentracing.BraveTracer;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.opentracing.Tracer;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import misk.ServiceModule;
import misk.config.AppName;
import misk.inject.GuiceKt;
import misk.inject.KAbstractModule;
import misk.tracing.backends.zipkin.ZipkinBackendConfig;
import misk.tracing.backends.zipkin.ZipkinReporterConfig;
import misk.tracing.backends.zipkin.ZipkinTracingService;
import org.jetbrains.annotations.NotNull;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.Sender;
import zipkin2.reporter.okhttp3.OkHttpSender;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0014J\u0012\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lmisk/tracing/backends/zipkin/ZipkinTracingModule;", "Lmisk/inject/KAbstractModule;", "config", "Lmisk/tracing/backends/zipkin/ZipkinBackendConfig;", "(Lmisk/tracing/backends/zipkin/ZipkinBackendConfig;)V", "getConfig", "()Lmisk/tracing/backends/zipkin/ZipkinBackendConfig;", "configure", "", "zipkinTracer", "Lio/opentracing/Tracer;", "appName", "", "misk-zipkin"})
public final class ZipkinTracingModule
extends KAbstractModule {
    @NotNull
    private final ZipkinBackendConfig config;

    protected void configure() {
        ZipkinTracingModule zipkinTracingModule = this;
        KClass qualifier$iv = null;
        boolean $i$f$ServiceModule = false;
        ServiceModule serviceModule = new ServiceModule(GuiceKt.toKey((KClass)Reflection.getOrCreateKotlinClass(ZipkinTracingService.class), (KClass)qualifier$iv), null, null, 6, null);
        zipkinTracingModule.install((Module)serviceModule);
    }

    @Provides
    @Singleton
    @NotNull
    public final Tracer zipkinTracer(@AppName @NotNull String appName) {
        Intrinsics.checkParameterIsNotNull((Object)appName, (String)"appName");
        AsyncReporter.Builder reporter = AsyncReporter.builder((Sender)((Sender)OkHttpSender.create((String)this.config.getCollector_url())));
        ZipkinReporterConfig zipkinReporterConfig = this.config.getReporter();
        if ((zipkinReporterConfig != null ? zipkinReporterConfig.getMessage_max_bytes() : null) != null) {
            reporter.messageMaxBytes(this.config.getReporter().getMessage_max_bytes().intValue());
        }
        ZipkinReporterConfig zipkinReporterConfig2 = this.config.getReporter();
        if ((zipkinReporterConfig2 != null ? zipkinReporterConfig2.getMessage_timeout_sec() : null) != null) {
            reporter.messageTimeout(this.config.getReporter().getMessage_timeout_sec().longValue(), TimeUnit.SECONDS);
        }
        ZipkinReporterConfig zipkinReporterConfig3 = this.config.getReporter();
        if ((zipkinReporterConfig3 != null ? zipkinReporterConfig3.getQueued_max_bytes() : null) != null) {
            reporter.queuedMaxBytes(this.config.getReporter().getQueued_max_bytes().intValue());
        }
        BraveTracer braveTracer = BraveTracer.create((Tracing)Tracing.newBuilder().spanReporter((Reporter)reporter.build()).localServiceName(appName).build());
        Intrinsics.checkExpressionValueIsNotNull((Object)braveTracer, (String)"BraveTracer.create(Traci\u2026ppName)\n        .build())");
        return (Tracer)braveTracer;
    }

    @NotNull
    public final ZipkinBackendConfig getConfig() {
        return this.config;
    }

    public ZipkinTracingModule(@NotNull ZipkinBackendConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.config = config;
    }
}

