/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi.recipes;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import okio.ByteString;

public final class ByteStrings {
    public void run() throws Exception {
        String json = "\"TW9zaGksIE9saXZlLCBXaGl0ZSBDaGluPw\"";
        Moshi moshi = new Moshi.Builder().add(ByteString.class, (JsonAdapter)new Base64ByteStringAdapter()).build();
        JsonAdapter jsonAdapter = moshi.adapter(ByteString.class);
        ByteString byteString = (ByteString)jsonAdapter.fromJson(json);
        System.out.println(byteString);
    }

    public static void main(String[] args) throws Exception {
        new ByteStrings().run();
    }

    public final class Base64ByteStringAdapter
    extends JsonAdapter<ByteString> {
        public ByteString fromJson(JsonReader reader) throws IOException {
            String base64 = reader.nextString();
            return ByteString.decodeBase64((String)base64);
        }

        public void toJson(JsonWriter writer, ByteString value) throws IOException {
            String string = value.base64();
            writer.value(string);
        }
    }
}

