/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi.recipes;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;

public final class CustomAdapterFactory {
    public void run() throws Exception {
        Moshi moshi = new Moshi.Builder().add((JsonAdapter.Factory)new SortedSetAdapterFactory()).build();
        JsonAdapter jsonAdapter = moshi.adapter((Type)Types.newParameterizedType(SortedSet.class, (Type[])new Type[]{String.class}));
        TreeSet<String> model = new TreeSet<String>();
        model.add("a");
        model.add("b");
        model.add("c");
        String json = jsonAdapter.toJson(model);
        System.out.println(json);
    }

    public static void main(String[] args) throws Exception {
        new CustomAdapterFactory().run();
    }

    static class SortedSetAdapterFactory
    implements JsonAdapter.Factory {
        SortedSetAdapterFactory() {
        }

        @Nullable
        public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
            if (!annotations.isEmpty()) {
                return null;
            }
            if (!(type instanceof ParameterizedType)) {
                return null;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (parameterizedType.getRawType() != SortedSet.class) {
                return null;
            }
            Type elementType = parameterizedType.getActualTypeArguments()[0];
            JsonAdapter elementAdapter = moshi.adapter(elementType);
            return new SortedSetAdapter(elementAdapter).nullSafe();
        }
    }

    static final class SortedSetAdapter<T>
    extends JsonAdapter<SortedSet<T>> {
        private final JsonAdapter<T> elementAdapter;

        SortedSetAdapter(JsonAdapter<T> elementAdapter) {
            this.elementAdapter = elementAdapter;
        }

        public SortedSet<T> fromJson(JsonReader reader) throws IOException {
            TreeSet<Object> result = new TreeSet<Object>();
            reader.beginArray();
            while (reader.hasNext()) {
                result.add(this.elementAdapter.fromJson(reader));
            }
            reader.endArray();
            return result;
        }

        public void toJson(JsonWriter writer, SortedSet<T> set) throws IOException {
            writer.beginArray();
            for (Object element : set) {
                this.elementAdapter.toJson(writer, element);
            }
            writer.endArray();
        }
    }
}

