/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi.recipes;

import com.squareup.moshi.FromJson;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import javax.annotation.Nullable;

public final class CustomAdapterWithDelegate {
    public void run() throws Exception {
        Moshi moshi = new Moshi.Builder().add((Object)new StageAdapter()).build();
        JsonAdapter jsonAdapter = moshi.adapter(Stage.class);
        System.out.println(jsonAdapter.fromJson("\"not-started\""));
        System.out.println(jsonAdapter.fromJson("\"in-progress\""));
        System.out.println(jsonAdapter.fromJson("\"in-progress-step1\""));
    }

    public static void main(String[] args) throws Exception {
        new CustomAdapterWithDelegate().run();
    }

    private static final class StageAdapter {
        private StageAdapter() {
        }

        @FromJson
        @Nullable
        Stage fromJson(JsonReader jsonReader, JsonAdapter<Stage> delegate) throws IOException {
            String value = jsonReader.nextString();
            Stage stage = value.startsWith("in-progress") ? Stage.IN_PROGRESS : (Stage)((Object)delegate.fromJsonValue((Object)value));
            return stage;
        }
    }

    private static enum Stage {
        NOT_STARTED,
        IN_PROGRESS,
        REJECTED,
        COMPLETED;

    }
}

