/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi.recipes;

import com.squareup.moshi.FromJson;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonQualifier;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.ToJson;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class CustomQualifier {
    public void run() throws Exception {
        String json = "{\n  \"color\": \"#ff0000\",\n  \"height\": 768,\n  \"width\": 1024\n}\n";
        Moshi moshi = new Moshi.Builder().add((Object)new ColorAdapter()).build();
        JsonAdapter jsonAdapter = moshi.adapter(Rectangle.class);
        Rectangle rectangle = (Rectangle)jsonAdapter.fromJson(json);
        System.out.println(rectangle);
    }

    public static void main(String[] args) throws Exception {
        new CustomQualifier().run();
    }

    static class ColorAdapter {
        ColorAdapter() {
        }

        @ToJson
        String toJson(@HexColor int rgb) {
            return String.format("#%06x", rgb);
        }

        @FromJson
        @HexColor
        int fromJson(String rgb) {
            return Integer.parseInt(rgb.substring(1), 16);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @JsonQualifier
    public static @interface HexColor {
    }

    static class Rectangle {
        int width;
        int height;
        @HexColor
        int color;

        Rectangle() {
        }

        public String toString() {
            return String.format("%dx%d #%06x", this.width, this.height, this.color);
        }
    }
}

