/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi.recipes;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.annotation.Nullable;

public final class DefaultOnDataMismatchAdapter<T>
extends JsonAdapter<T> {
    private final JsonAdapter<T> delegate;
    private final T defaultValue;

    private DefaultOnDataMismatchAdapter(JsonAdapter<T> delegate, T defaultValue) {
        this.delegate = delegate;
        this.defaultValue = defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T fromJson(JsonReader reader) throws IOException {
        Object result;
        try (JsonReader peeked = reader.peekJson();){
            result = this.delegate.fromJson(peeked);
        }
        reader.skipValue();
        return (T)result;
    }

    public void toJson(JsonWriter writer, T value) throws IOException {
        this.delegate.toJson(writer, value);
    }

    public static <T> JsonAdapter.Factory newFactory(final Class<T> type, final T defaultValue) {
        return new JsonAdapter.Factory(){

            @Nullable
            public JsonAdapter<?> create(Type requestedType, Set<? extends Annotation> annotations, Moshi moshi) {
                if (type != requestedType) {
                    return null;
                }
                JsonAdapter delegate = moshi.nextAdapter((JsonAdapter.Factory)this, (Type)type, annotations);
                return new DefaultOnDataMismatchAdapter(delegate, defaultValue);
            }
        };
    }
}

