/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi.recipes;

import com.squareup.moshi.Json;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonQualifier;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Type;
import java.util.Set;
import javax.annotation.Nullable;

final class FallbackEnum {
    public static void main(String[] args) throws Exception {
        Moshi moshi = new Moshi.Builder().add(FallbackEnumJsonAdapter.FACTORY).build();
        JsonAdapter adapter = moshi.adapter(Example.class);
        System.out.println(adapter.fromJson("{\"transportation\":\"CARS\"}"));
    }

    private FallbackEnum() {
    }

    static final class Example {
        @Fallback(value="WALKING")
        final Transportation transportation;

        Example(Transportation transportation) {
            this.transportation = transportation;
        }

        public String toString() {
            return this.transportation.toString();
        }

        static enum Transportation {
            WALKING,
            BIKING,
            TRAINS,
            PLANES;

        }
    }

    public static final class FallbackEnumJsonAdapter<T extends Enum<T>>
    extends JsonAdapter<T> {
        public static final JsonAdapter.Factory FACTORY = new JsonAdapter.Factory(){

            @Nullable
            public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
                Class rawType = Types.getRawType((Type)type);
                if (!rawType.isEnum()) {
                    return null;
                }
                if (annotations.size() != 1) {
                    return null;
                }
                Annotation annotation = annotations.iterator().next();
                if (!(annotation instanceof Fallback)) {
                    return null;
                }
                Class enumType = rawType;
                Object fallback = Enum.valueOf(enumType, ((Fallback)annotation).value());
                return new FallbackEnumJsonAdapter(enumType, fallback);
            }
        };
        final Class<T> enumType;
        final String[] nameStrings;
        final T[] constants;
        final JsonReader.Options options;
        final T defaultValue;

        FallbackEnumJsonAdapter(Class<T> enumType, T defaultValue) {
            this.enumType = enumType;
            this.defaultValue = defaultValue;
            try {
                this.constants = (Enum[])enumType.getEnumConstants();
                this.nameStrings = new String[this.constants.length];
                for (int i = 0; i < this.constants.length; ++i) {
                    String name;
                    T constant = this.constants[i];
                    Json annotation = enumType.getField(((Enum)constant).name()).getAnnotation(Json.class);
                    this.nameStrings[i] = name = annotation != null ? annotation.name() : ((Enum)constant).name();
                }
                this.options = JsonReader.Options.of((String[])this.nameStrings);
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError((Object)e);
            }
        }

        public T fromJson(JsonReader reader) throws IOException {
            int index = reader.selectString(this.options);
            if (index != -1) {
                return this.constants[index];
            }
            reader.nextString();
            return this.defaultValue;
        }

        public void toJson(JsonWriter writer, T value) throws IOException {
            writer.value(this.nameStrings[((Enum)value).ordinal()]);
        }

        public String toString() {
            return "JsonAdapter(" + this.enumType.getName() + ").defaultValue( " + this.defaultValue + ")";
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @JsonQualifier
    public static @interface Fallback {
        public String value();
    }
}

