/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi.recipes;

import com.squareup.moshi.FromJson;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.ToJson;

public final class FromJsonWithoutStrings {
    public void run() throws Exception {
        String json = "{\n  \"title\": \"Blackjack tournament\",\n  \"begin_date\": \"20151010\",\n  \"begin_time\": \"17:04\"\n}\n";
        Moshi moshi = new Moshi.Builder().add((Object)new EventJsonAdapter()).build();
        JsonAdapter jsonAdapter = moshi.adapter(Event.class);
        Event event = (Event)jsonAdapter.fromJson(json);
        System.out.println(event);
        System.out.println(jsonAdapter.toJson((Object)event));
    }

    public static void main(String[] args) throws Exception {
        new FromJsonWithoutStrings().run();
    }

    private static final class EventJsonAdapter {
        private EventJsonAdapter() {
        }

        @FromJson
        Event eventFromJson(EventJson eventJson) {
            Event event = new Event();
            event.title = eventJson.title;
            event.beginDateAndTime = eventJson.begin_date + " " + eventJson.begin_time;
            return event;
        }

        @ToJson
        EventJson eventToJson(Event event) {
            EventJson json = new EventJson();
            json.title = event.title;
            json.begin_date = event.beginDateAndTime.substring(0, 8);
            json.begin_time = event.beginDateAndTime.substring(9, 14);
            return json;
        }
    }

    public static final class Event {
        String title;
        String beginDateAndTime;

        public String toString() {
            return "Event{title='" + this.title + '\'' + ", beginDateAndTime='" + this.beginDateAndTime + '\'' + '}';
        }
    }

    private static final class EventJson {
        String title;
        String begin_date;
        String begin_time;

        private EventJson() {
        }
    }
}

