/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi.recipes;

import com.squareup.moshi.FromJson;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonQualifier;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.ToJson;
import com.squareup.moshi.recipes.models.Card;
import com.squareup.moshi.recipes.models.Suit;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class MultipleFormats {
    public void run() throws Exception {
        Moshi moshi = new Moshi.Builder().add((Object)new MultipleFormatsCardAdapter()).add((Object)new CardStringAdapter()).build();
        JsonAdapter cardAdapter = moshi.adapter(Card.class);
        System.out.println(cardAdapter.fromJson("\"5D\""));
        System.out.println(cardAdapter.fromJson("{\"suit\": \"SPADES\", \"rank\": 5}"));
        System.out.println(cardAdapter.toJson((Object)new Card('5', Suit.CLUBS)));
    }

    public static void main(String[] args) throws Exception {
        new MultipleFormats().run();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @JsonQualifier
    static @interface CardString {
    }

    public final class CardStringAdapter {
        @ToJson
        String toJson(@CardString Card card) {
            return card.rank + card.suit.name().substring(0, 1);
        }

        @FromJson
        @CardString
        Card fromJson(String card) {
            if (card.length() != 2) {
                throw new JsonDataException("Unknown card: " + card);
            }
            char rank = card.charAt(0);
            switch (card.charAt(1)) {
                case 'C': {
                    return new Card(rank, Suit.CLUBS);
                }
                case 'D': {
                    return new Card(rank, Suit.DIAMONDS);
                }
                case 'H': {
                    return new Card(rank, Suit.HEARTS);
                }
                case 'S': {
                    return new Card(rank, Suit.SPADES);
                }
            }
            throw new JsonDataException("unknown suit: " + card);
        }
    }

    public final class MultipleFormatsCardAdapter {
        @ToJson
        void toJson(JsonWriter writer, Card value, @CardString JsonAdapter<Card> stringAdapter) throws IOException {
            stringAdapter.toJson(writer, (Object)value);
        }

        @FromJson
        Card fromJson(JsonReader reader, @CardString JsonAdapter<Card> stringAdapter, JsonAdapter<Card> defaultAdapter) throws IOException {
            if (reader.peek() == JsonReader.Token.STRING) {
                return (Card)stringAdapter.fromJson(reader);
            }
            return (Card)defaultAdapter.fromJson(reader);
        }
    }
}

