/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi.recipes;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.adapters.Rfc3339DateJsonAdapter;
import com.squareup.moshi.recipes.models.Tournament;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public final class ReadAndWriteRfc3339Dates {
    public void run() throws Exception {
        Moshi moshi = new Moshi.Builder().add(Date.class, (JsonAdapter)new Rfc3339DateJsonAdapter()).build();
        JsonAdapter jsonAdapter = moshi.adapter(Tournament.class);
        String lastTournament = "{  \"location\":\"Chainsaw\",  \"name\":\"21 for 21\",  \"start\":\"2015-09-01T20:00:00-05:00\"}";
        System.out.println("Last tournament: " + jsonAdapter.fromJson(lastTournament));
        Tournament nextTournament = new Tournament("Waterloo Classic", "Bauer Kitchen", this.newDate(2015, 10, 1, 20, -5));
        System.out.println("Next tournament JSON: " + jsonAdapter.toJson((Object)nextTournament));
    }

    public static void main(String[] args) throws Exception {
        new ReadAndWriteRfc3339Dates().run();
    }

    private Date newDate(int year, int month, int day, int hour, int offset) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        calendar.set(year, month - 1, day, hour, 0, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTimeInMillis() - TimeUnit.HOURS.toMillis(offset));
    }
}

