/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi.recipes;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonQualifier;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import com.squareup.moshi.recipes.models.Card;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import javax.annotation.Nullable;

final class Unwrap {
    private Unwrap() {
    }

    public static void main(String[] args) throws Exception {
        String json = "{\"data\":  {\n    \"rank\": \"4\",\n    \"suit\": \"CLUBS\"\n  }}";
        Moshi moshi = new Moshi.Builder().add(EnvelopeJsonAdapter.FACTORY).build();
        JsonAdapter adapter = moshi.adapter(Card.class, EnvelopeJsonAdapter.Enveloped.class);
        Card out = (Card)adapter.fromJson(json);
        System.out.println(out);
    }

    public static final class EnvelopeJsonAdapter
    extends JsonAdapter<Object> {
        public static final JsonAdapter.Factory FACTORY = new JsonAdapter.Factory(){

            @Nullable
            public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
                Set delegateAnnotations = Types.nextAnnotations(annotations, Enveloped.class);
                if (delegateAnnotations == null) {
                    return null;
                }
                ParameterizedType envelope = Types.newParameterizedTypeWithOwner(EnvelopeJsonAdapter.class, Envelope.class, (Type[])new Type[]{type});
                JsonAdapter delegate = moshi.nextAdapter((JsonAdapter.Factory)this, (Type)envelope, delegateAnnotations);
                return new EnvelopeJsonAdapter(delegate);
            }
        };
        private final JsonAdapter<Envelope<?>> delegate;

        EnvelopeJsonAdapter(JsonAdapter<Envelope<?>> delegate) {
            this.delegate = delegate;
        }

        public Object fromJson(JsonReader reader) throws IOException {
            return ((Envelope)this.delegate.fromJson((JsonReader)reader)).data;
        }

        public void toJson(JsonWriter writer, Object value) throws IOException {
            this.delegate.toJson(writer, new Envelope<Object>(value));
        }

        private static final class Envelope<T> {
            final T data;

            Envelope(T data) {
                this.data = data;
            }
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        @JsonQualifier
        public static @interface Enveloped {
        }
    }
}

