/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.mockwebserver;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Internal;
import okhttp3.internal.NamedRunnable;
import okhttp3.internal.Util;
import okhttp3.internal.framed.ErrorCode;
import okhttp3.internal.framed.FramedConnection;
import okhttp3.internal.framed.FramedStream;
import okhttp3.internal.framed.Header;
import okhttp3.internal.framed.Settings;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.ws.RealWebSocket;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.PushPromise;
import okhttp3.mockwebserver.QueueDispatcher;
import okhttp3.mockwebserver.RecordedRequest;
import okhttp3.mockwebserver.SocketPolicy;
import okhttp3.ws.WebSocketListener;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import okio.Timeout;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class MockWebServer
implements TestRule {
    private static final X509TrustManager UNTRUSTED_TRUST_MANAGER;
    private static final Logger logger;
    private final BlockingQueue<RecordedRequest> requestQueue = new LinkedBlockingQueue<RecordedRequest>();
    private final Set<Socket> openClientSockets = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<FramedConnection> openFramedConnections = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicInteger requestCount = new AtomicInteger();
    private long bodyLimit = Long.MAX_VALUE;
    private ServerSocketFactory serverSocketFactory = ServerSocketFactory.getDefault();
    private ServerSocket serverSocket;
    private SSLSocketFactory sslSocketFactory;
    private ExecutorService executor;
    private boolean tunnelProxy;
    private Dispatcher dispatcher = new QueueDispatcher();
    private int port = -1;
    private InetSocketAddress inetSocketAddress;
    private boolean protocolNegotiationEnabled = true;
    private List<Protocol> protocols = Util.immutableList(Protocol.HTTP_2, Protocol.SPDY_3, Protocol.HTTP_1_1);
    private boolean started;

    private synchronized void maybeStart() {
        if (this.started) {
            return;
        }
        try {
            this.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            @Override
            public void evaluate() throws Throwable {
                MockWebServer.this.maybeStart();
                try {
                    base.evaluate();
                }
                finally {
                    try {
                        MockWebServer.this.shutdown();
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "MockWebServer shutdown failed", e);
                    }
                }
            }
        };
    }

    public int getPort() {
        this.maybeStart();
        return this.port;
    }

    public String getHostName() {
        this.maybeStart();
        return this.inetSocketAddress.getHostName();
    }

    public Proxy toProxyAddress() {
        this.maybeStart();
        InetSocketAddress address = new InetSocketAddress(this.inetSocketAddress.getAddress(), this.getPort());
        return new Proxy(Proxy.Type.HTTP, address);
    }

    public void setServerSocketFactory(ServerSocketFactory serverSocketFactory) {
        if (this.executor != null) {
            throw new IllegalStateException("setServerSocketFactory() must be called before start()");
        }
        this.serverSocketFactory = serverSocketFactory;
    }

    public HttpUrl url(String path) {
        return new HttpUrl.Builder().scheme(this.sslSocketFactory != null ? "https" : "http").host(this.getHostName()).port(this.getPort()).build().resolve(path);
    }

    public void setBodyLimit(long maxBodyLength) {
        this.bodyLimit = maxBodyLength;
    }

    public void setProtocolNegotiationEnabled(boolean protocolNegotiationEnabled) {
        this.protocolNegotiationEnabled = protocolNegotiationEnabled;
    }

    public void setProtocols(List<Protocol> protocols) {
        if (!(protocols = Util.immutableList(protocols)).contains((Object)Protocol.HTTP_1_1)) {
            throw new IllegalArgumentException("protocols doesn't contain http/1.1: " + protocols);
        }
        if (protocols.contains(null)) {
            throw new IllegalArgumentException("protocols must not contain null");
        }
        this.protocols = protocols;
    }

    public void useHttps(SSLSocketFactory sslSocketFactory, boolean tunnelProxy) {
        this.sslSocketFactory = sslSocketFactory;
        this.tunnelProxy = tunnelProxy;
    }

    public RecordedRequest takeRequest() throws InterruptedException {
        return this.requestQueue.take();
    }

    public RecordedRequest takeRequest(long timeout, TimeUnit unit) throws InterruptedException {
        return this.requestQueue.poll(timeout, unit);
    }

    public int getRequestCount() {
        return this.requestCount.get();
    }

    public void enqueue(MockResponse response) {
        ((QueueDispatcher)this.dispatcher).enqueueResponse(response.clone());
    }

    public void start() throws IOException {
        this.start(0);
    }

    public void start(int port) throws IOException {
        this.start(InetAddress.getByName("localhost"), port);
    }

    public void start(InetAddress inetAddress, int port) throws IOException {
        this.start(new InetSocketAddress(inetAddress, port));
    }

    private synchronized void start(InetSocketAddress inetSocketAddress) throws IOException {
        if (this.started) {
            throw new IllegalStateException("start() already called");
        }
        this.started = true;
        this.executor = Executors.newCachedThreadPool(Util.threadFactory("MockWebServer", false));
        this.inetSocketAddress = inetSocketAddress;
        this.serverSocket = this.serverSocketFactory.createServerSocket();
        this.serverSocket.setReuseAddress(inetSocketAddress.getPort() != 0);
        this.serverSocket.bind(inetSocketAddress, 50);
        this.port = this.serverSocket.getLocalPort();
        this.executor.execute(new NamedRunnable("MockWebServer %s", new Object[]{this.port}){

            @Override
            protected void execute() {
                try {
                    logger.info(MockWebServer.this + " starting to accept connections");
                    this.acceptConnections();
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, MockWebServer.this + " failed unexpectedly", e);
                }
                Util.closeQuietly(MockWebServer.this.serverSocket);
                Iterator s = MockWebServer.this.openClientSockets.iterator();
                while (s.hasNext()) {
                    Util.closeQuietly((Socket)s.next());
                    s.remove();
                }
                s = MockWebServer.this.openFramedConnections.iterator();
                while (s.hasNext()) {
                    Util.closeQuietly((Closeable)s.next());
                    s.remove();
                }
                MockWebServer.this.dispatcher.shutdown();
                MockWebServer.this.executor.shutdown();
            }

            private void acceptConnections() throws Exception {
                while (true) {
                    Socket socket;
                    try {
                        socket = MockWebServer.this.serverSocket.accept();
                    }
                    catch (SocketException e) {
                        logger.info(MockWebServer.this + " done accepting connections: " + e.getMessage());
                        return;
                    }
                    SocketPolicy socketPolicy = MockWebServer.this.dispatcher.peek().getSocketPolicy();
                    if (socketPolicy == SocketPolicy.DISCONNECT_AT_START) {
                        MockWebServer.this.dispatchBookkeepingRequest(0, socket);
                        socket.close();
                        continue;
                    }
                    MockWebServer.this.openClientSockets.add(socket);
                    MockWebServer.this.serveConnection(socket);
                }
            }
        });
    }

    public synchronized void shutdown() throws IOException {
        if (!this.started) {
            return;
        }
        if (this.serverSocket == null) {
            throw new IllegalStateException("shutdown() before start()");
        }
        this.serverSocket.close();
        try {
            if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                throw new IOException("Gave up waiting for executor to shut down");
            }
        }
        catch (InterruptedException e) {
            throw new AssertionError();
        }
    }

    private void serveConnection(final Socket raw) {
        this.executor.execute(new NamedRunnable("MockWebServer %s", new Object[]{raw.getRemoteSocketAddress()}){
            int sequenceNumber;
            {
                super(x0, x1);
                this.sequenceNumber = 0;
            }

            @Override
            protected void execute() {
                try {
                    this.processConnection();
                }
                catch (IOException e) {
                    logger.info(MockWebServer.this + " connection from " + raw.getInetAddress() + " failed: " + e);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, MockWebServer.this + " connection from " + raw.getInetAddress() + " crashed", e);
                }
            }

            public void processConnection() throws Exception {
                Socket socket;
                Protocol protocol = Protocol.HTTP_1_1;
                if (MockWebServer.this.sslSocketFactory != null) {
                    SocketPolicy socketPolicy;
                    if (MockWebServer.this.tunnelProxy) {
                        this.createTunnel();
                    }
                    if ((socketPolicy = MockWebServer.this.dispatcher.peek().getSocketPolicy()) == SocketPolicy.FAIL_HANDSHAKE) {
                        MockWebServer.this.dispatchBookkeepingRequest(this.sequenceNumber, raw);
                        MockWebServer.this.processHandshakeFailure(raw);
                        return;
                    }
                    socket = MockWebServer.this.sslSocketFactory.createSocket(raw, raw.getInetAddress().getHostAddress(), raw.getPort(), true);
                    SSLSocket sslSocket = (SSLSocket)socket;
                    sslSocket.setUseClientMode(false);
                    MockWebServer.this.openClientSockets.add(socket);
                    if (MockWebServer.this.protocolNegotiationEnabled) {
                        Platform.get().configureTlsExtensions(sslSocket, null, MockWebServer.this.protocols);
                    }
                    sslSocket.startHandshake();
                    if (MockWebServer.this.protocolNegotiationEnabled) {
                        String protocolString = Platform.get().getSelectedProtocol(sslSocket);
                        protocol = protocolString != null ? Protocol.get(protocolString) : Protocol.HTTP_1_1;
                    }
                    MockWebServer.this.openClientSockets.remove(raw);
                } else {
                    socket = raw;
                }
                if (protocol != Protocol.HTTP_1_1) {
                    FramedSocketHandler framedSocketListener = new FramedSocketHandler(socket, protocol);
                    FramedConnection framedConnection = new FramedConnection.Builder(false).socket(socket).protocol(protocol).listener(framedSocketListener).build();
                    framedConnection.start();
                    MockWebServer.this.openFramedConnections.add(framedConnection);
                    MockWebServer.this.openClientSockets.remove(socket);
                    return;
                }
                BufferedSource source = Okio.buffer(Okio.source(socket));
                BufferedSink sink = Okio.buffer(Okio.sink(socket));
                while (this.processOneRequest(socket, source, sink)) {
                }
                if (this.sequenceNumber == 0) {
                    logger.warning(MockWebServer.this + " connection from " + raw.getInetAddress() + " didn't make a request");
                }
                source.close();
                sink.close();
                socket.close();
                MockWebServer.this.openClientSockets.remove(socket);
            }

            private void createTunnel() throws IOException, InterruptedException {
                SocketPolicy socketPolicy;
                BufferedSource source = Okio.buffer(Okio.source(raw));
                BufferedSink sink = Okio.buffer(Okio.sink(raw));
                do {
                    socketPolicy = MockWebServer.this.dispatcher.peek().getSocketPolicy();
                    if (this.processOneRequest(raw, source, sink)) continue;
                    throw new IllegalStateException("Tunnel without any CONNECT!");
                } while (socketPolicy != SocketPolicy.UPGRADE_TO_SSL_AT_END);
            }

            private boolean processOneRequest(Socket socket, BufferedSource source, BufferedSink sink) throws IOException, InterruptedException {
                boolean responseWantsWebSockets;
                RecordedRequest request = MockWebServer.this.readRequest(socket, source, sink, this.sequenceNumber);
                if (request == null) {
                    return false;
                }
                MockWebServer.this.requestCount.incrementAndGet();
                MockWebServer.this.requestQueue.add(request);
                MockResponse response = MockWebServer.this.dispatcher.dispatch(request);
                if (response.getSocketPolicy() == SocketPolicy.DISCONNECT_AFTER_REQUEST) {
                    socket.close();
                    return false;
                }
                if (response.getSocketPolicy() == SocketPolicy.NO_RESPONSE) {
                    if (source.exhausted()) {
                        return false;
                    }
                    throw new ProtocolException("unexpected data");
                }
                boolean reuseSocket = true;
                boolean requestWantsWebSockets = "Upgrade".equalsIgnoreCase(request.getHeader("Connection")) && "websocket".equalsIgnoreCase(request.getHeader("Upgrade"));
                boolean bl = responseWantsWebSockets = response.getWebSocketListener() != null;
                if (requestWantsWebSockets && responseWantsWebSockets) {
                    MockWebServer.this.handleWebSocketUpgrade(socket, source, sink, request, response);
                    reuseSocket = false;
                } else {
                    MockWebServer.this.writeHttpResponse(socket, sink, response);
                }
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(MockWebServer.this + " received request: " + request + " and responded: " + response);
                }
                if (response.getSocketPolicy() == SocketPolicy.DISCONNECT_AT_END) {
                    socket.close();
                    return false;
                }
                if (response.getSocketPolicy() == SocketPolicy.SHUTDOWN_INPUT_AT_END) {
                    socket.shutdownInput();
                } else if (response.getSocketPolicy() == SocketPolicy.SHUTDOWN_OUTPUT_AT_END) {
                    socket.shutdownOutput();
                }
                ++this.sequenceNumber;
                return reuseSocket;
            }
        });
    }

    private void processHandshakeFailure(Socket raw) throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, new TrustManager[]{UNTRUSTED_TRUST_MANAGER}, new SecureRandom());
        SSLSocketFactory sslSocketFactory = context.getSocketFactory();
        SSLSocket socket = (SSLSocket)sslSocketFactory.createSocket(raw, raw.getInetAddress().getHostAddress(), raw.getPort(), true);
        try {
            socket.startHandshake();
            throw new AssertionError();
        }
        catch (IOException iOException) {
            socket.close();
            return;
        }
    }

    private void dispatchBookkeepingRequest(int sequenceNumber, Socket socket) throws InterruptedException {
        RecordedRequest request = new RecordedRequest(null, null, null, -1L, null, sequenceNumber, socket);
        this.requestCount.incrementAndGet();
        this.requestQueue.add(request);
        this.dispatcher.dispatch(request);
    }

    private RecordedRequest readRequest(Socket socket, BufferedSource source, BufferedSink sink, int sequenceNumber) throws IOException {
        String header;
        String request;
        try {
            request = source.readUtf8LineStrict();
        }
        catch (IOException streamIsClosed) {
            return null;
        }
        if (request.length() == 0) {
            return null;
        }
        Headers.Builder headers = new Headers.Builder();
        long contentLength = -1L;
        boolean chunked = false;
        boolean expectContinue = false;
        while ((header = source.readUtf8LineStrict()).length() != 0) {
            Internal.instance.addLenient(headers, header);
            String lowercaseHeader = header.toLowerCase(Locale.US);
            if (contentLength == -1L && lowercaseHeader.startsWith("content-length:")) {
                contentLength = Long.parseLong(header.substring(15).trim());
            }
            if (lowercaseHeader.startsWith("transfer-encoding:") && lowercaseHeader.substring(18).trim().equals("chunked")) {
                chunked = true;
            }
            if (!lowercaseHeader.startsWith("expect:") || !lowercaseHeader.substring(7).trim().equals("100-continue")) continue;
            expectContinue = true;
        }
        if (expectContinue) {
            sink.writeUtf8("HTTP/1.1 100 Continue\r\n");
            sink.writeUtf8("Content-Length: 0\r\n");
            sink.writeUtf8("\r\n");
            sink.flush();
        }
        boolean hasBody = false;
        TruncatingBuffer requestBody = new TruncatingBuffer(this.bodyLimit);
        ArrayList<Integer> chunkSizes = new ArrayList<Integer>();
        MockResponse policy = this.dispatcher.peek();
        if (contentLength != -1L) {
            hasBody = contentLength > 0L;
            this.throttledTransfer(policy, socket, source, Okio.buffer(requestBody), contentLength, true);
        } else if (chunked) {
            hasBody = true;
            while (true) {
                int chunkSize;
                if ((chunkSize = Integer.parseInt(source.readUtf8LineStrict().trim(), 16)) == 0) {
                    this.readEmptyLine(source);
                    break;
                }
                chunkSizes.add(chunkSize);
                this.throttledTransfer(policy, socket, source, Okio.buffer(requestBody), chunkSize, true);
                this.readEmptyLine(source);
            }
        }
        String method = request.substring(0, request.indexOf(32));
        if (hasBody && !HttpMethod.permitsRequestBody(method)) {
            throw new IllegalArgumentException("Request must not have a body: " + request);
        }
        return new RecordedRequest(request, headers.build(), chunkSizes, requestBody.receivedByteCount, requestBody.buffer, sequenceNumber, socket);
    }

    private void handleWebSocketUpgrade(Socket socket, BufferedSource source, BufferedSink sink, RecordedRequest request, MockResponse response) throws IOException {
        String key = request.getHeader("Sec-WebSocket-Key");
        String acceptKey = Util.shaBase64(key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11");
        response.setHeader("Sec-WebSocket-Accept", acceptKey);
        this.writeHttpResponse(socket, sink, response);
        WebSocketListener listener = response.getWebSocketListener();
        final CountDownLatch connectionClose = new CountDownLatch(1);
        ThreadPoolExecutor replyExecutor = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), Util.threadFactory(Util.format("MockWebServer %s WebSocket", request.getPath()), true));
        replyExecutor.allowCoreThreadTimeOut(true);
        RealWebSocket webSocket = new RealWebSocket(false, source, sink, new SecureRandom(), replyExecutor, listener, request.getPath()){

            @Override
            protected void close() throws IOException {
                connectionClose.countDown();
            }
        };
        String scheme = request.getTlsVersion() != null ? "https" : "http";
        String authority = request.getHeader("Host");
        Request fancyRequest = new Request.Builder().url(scheme + "://" + authority + "/").headers(request.getHeaders()).build();
        Response fancyResponse = new Response.Builder().code(Integer.parseInt(response.getStatus().split(" ")[1])).message(response.getStatus().split(" ", 3)[2]).headers(response.getHeaders()).request(fancyRequest).protocol(Protocol.HTTP_1_1).build();
        listener.onOpen(webSocket, fancyResponse);
        while (webSocket.readMessage()) {
        }
        try {
            connectionClose.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        replyExecutor.shutdown();
        Util.closeQuietly(sink);
        Util.closeQuietly(source);
    }

    private void writeHttpResponse(Socket socket, BufferedSink sink, MockResponse response) throws IOException {
        sink.writeUtf8(response.getStatus());
        sink.writeUtf8("\r\n");
        Headers headers = response.getHeaders();
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            sink.writeUtf8(headers.name(i));
            sink.writeUtf8(": ");
            sink.writeUtf8(headers.value(i));
            sink.writeUtf8("\r\n");
        }
        sink.writeUtf8("\r\n");
        sink.flush();
        Buffer body = response.getBody();
        if (body == null) {
            return;
        }
        this.sleepIfDelayed(response);
        this.throttledTransfer(response, socket, body, sink, body.size(), false);
    }

    private void sleepIfDelayed(MockResponse response) {
        long delayMs = response.getBodyDelay(TimeUnit.MILLISECONDS);
        if (delayMs != 0L) {
            try {
                Thread.sleep(delayMs);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private void throttledTransfer(MockResponse policy, Socket socket, BufferedSource source, BufferedSink sink, long byteCount, boolean isRequest) throws IOException {
        boolean disconnectHalfway;
        if (byteCount == 0L) {
            return;
        }
        Buffer buffer = new Buffer();
        long bytesPerPeriod = policy.getThrottleBytesPerPeriod();
        long periodDelayMs = policy.getThrottlePeriod(TimeUnit.MILLISECONDS);
        long halfByteCount = byteCount / 2L;
        boolean bl = isRequest ? policy.getSocketPolicy() == SocketPolicy.DISCONNECT_DURING_REQUEST_BODY : (disconnectHalfway = policy.getSocketPolicy() == SocketPolicy.DISCONNECT_DURING_RESPONSE_BODY);
        while (!socket.isClosed()) {
            int b = 0;
            while ((long)b < bytesPerPeriod) {
                long read;
                long toRead = Math.min(byteCount, bytesPerPeriod - (long)b);
                if (disconnectHalfway) {
                    toRead = Math.min(toRead, byteCount - halfByteCount);
                }
                if ((read = source.read(buffer, toRead)) == -1L) {
                    return;
                }
                sink.write(buffer, read);
                sink.flush();
                b = (int)((long)b + read);
                if (disconnectHalfway && (byteCount -= read) == halfByteCount) {
                    socket.close();
                    return;
                }
                if (byteCount != 0L) continue;
                return;
            }
            if (periodDelayMs == 0L) continue;
            try {
                Thread.sleep(periodDelayMs);
            }
            catch (InterruptedException e) {
                throw new AssertionError();
            }
        }
    }

    private void readEmptyLine(BufferedSource source) throws IOException {
        String line = source.readUtf8LineStrict();
        if (line.length() != 0) {
            throw new IllegalStateException("Expected empty but was: " + line);
        }
    }

    public void setDispatcher(Dispatcher dispatcher) {
        if (dispatcher == null) {
            throw new NullPointerException();
        }
        this.dispatcher = dispatcher;
    }

    public String toString() {
        return "MockWebServer[" + this.port + "]";
    }

    static {
        Internal.initializeInstanceForTests();
        UNTRUSTED_TRUST_MANAGER = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                throw new CertificateException();
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
                throw new AssertionError();
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                throw new AssertionError();
            }
        };
        logger = Logger.getLogger(MockWebServer.class.getName());
    }

    private class FramedSocketHandler
    extends FramedConnection.Listener {
        private final Socket socket;
        private final Protocol protocol;
        private final AtomicInteger sequenceNumber = new AtomicInteger();

        private FramedSocketHandler(Socket socket, Protocol protocol) {
            this.socket = socket;
            this.protocol = protocol;
        }

        @Override
        public void onStream(FramedStream stream) throws IOException {
            MockResponse response;
            MockResponse peekedResponse = MockWebServer.this.dispatcher.peek();
            if (peekedResponse.getSocketPolicy() == SocketPolicy.RESET_STREAM_AT_START) {
                try {
                    MockWebServer.this.dispatchBookkeepingRequest(this.sequenceNumber.getAndIncrement(), this.socket);
                    stream.close(ErrorCode.fromHttp2(peekedResponse.getHttp2ErrorCode()));
                    return;
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }
            RecordedRequest request = this.readRequest(stream);
            MockWebServer.this.requestCount.incrementAndGet();
            MockWebServer.this.requestQueue.add(request);
            try {
                response = MockWebServer.this.dispatcher.dispatch(request);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            this.writeResponse(stream, response);
            if (logger.isLoggable(Level.INFO)) {
                logger.info(MockWebServer.this + " received request: " + request + " and responded: " + response + " protocol is " + this.protocol.toString());
            }
            if (response.getSocketPolicy() == SocketPolicy.DISCONNECT_AT_END) {
                FramedConnection connection = stream.getConnection();
                connection.shutdown(ErrorCode.NO_ERROR);
            }
        }

        private RecordedRequest readRequest(FramedStream stream) throws IOException {
            List<Header> streamHeaders = stream.getRequestHeaders();
            Headers.Builder httpHeaders = new Headers.Builder();
            String method = "<:method omitted>";
            String path = "<:path omitted>";
            String version = this.protocol == Protocol.SPDY_3 ? "<:version omitted>" : "HTTP/1.1";
            int size = streamHeaders.size();
            for (int i = 0; i < size; ++i) {
                ByteString name = streamHeaders.get((int)i).name;
                String value = streamHeaders.get((int)i).value.utf8();
                if (name.equals(Header.TARGET_METHOD)) {
                    method = value;
                    continue;
                }
                if (name.equals(Header.TARGET_PATH)) {
                    path = value;
                    continue;
                }
                if (name.equals(Header.VERSION)) {
                    version = value;
                    continue;
                }
                if (this.protocol == Protocol.SPDY_3) {
                    for (String s : value.split("\u0000", -1)) {
                        httpHeaders.add(name.utf8(), s);
                    }
                    continue;
                }
                if (this.protocol == Protocol.HTTP_2) {
                    httpHeaders.add(name.utf8(), value);
                    continue;
                }
                throw new IllegalStateException();
            }
            Buffer body = new Buffer();
            body.writeAll(stream.getSource());
            body.close();
            String requestLine = method + ' ' + path + ' ' + version;
            List<Integer> chunkSizes = Collections.emptyList();
            return new RecordedRequest(requestLine, httpHeaders.build(), chunkSizes, body.size(), body, this.sequenceNumber.getAndIncrement(), this.socket);
        }

        private void writeResponse(FramedStream stream, MockResponse response) throws IOException {
            Settings settings = response.getSettings();
            if (settings != null) {
                stream.getConnection().setSettings(settings);
            }
            if (response.getSocketPolicy() == SocketPolicy.NO_RESPONSE) {
                return;
            }
            ArrayList<Header> spdyHeaders = new ArrayList<Header>();
            String[] statusParts = response.getStatus().split(" ", 2);
            if (statusParts.length != 2) {
                throw new AssertionError((Object)("Unexpected status: " + response.getStatus()));
            }
            spdyHeaders.add(new Header(Header.RESPONSE_STATUS, statusParts[1]));
            if (this.protocol == Protocol.SPDY_3) {
                spdyHeaders.add(new Header(Header.VERSION, statusParts[0]));
            }
            Headers headers = response.getHeaders();
            int size = headers.size();
            for (int i = 0; i < size; ++i) {
                spdyHeaders.add(new Header(headers.name(i), headers.value(i)));
            }
            Buffer body = response.getBody();
            boolean closeStreamAfterHeaders = body != null || !response.getPushPromises().isEmpty();
            stream.reply(spdyHeaders, closeStreamAfterHeaders);
            this.pushPromises(stream, response.getPushPromises());
            if (body != null) {
                BufferedSink sink = Okio.buffer(stream.getSink());
                MockWebServer.this.sleepIfDelayed(response);
                MockWebServer.this.throttledTransfer(response, this.socket, body, sink, MockWebServer.this.bodyLimit, false);
                sink.close();
            } else if (closeStreamAfterHeaders) {
                stream.close(ErrorCode.NO_ERROR);
            }
        }

        private void pushPromises(FramedStream stream, List<PushPromise> promises) throws IOException {
            for (PushPromise pushPromise : promises) {
                ArrayList<Header> pushedHeaders = new ArrayList<Header>();
                pushedHeaders.add(new Header(stream.getConnection().getProtocol() == Protocol.SPDY_3 ? Header.TARGET_HOST : Header.TARGET_AUTHORITY, MockWebServer.this.url(pushPromise.path()).host()));
                pushedHeaders.add(new Header(Header.TARGET_METHOD, pushPromise.method()));
                pushedHeaders.add(new Header(Header.TARGET_PATH, pushPromise.path()));
                Headers pushPromiseHeaders = pushPromise.headers();
                int size = pushPromiseHeaders.size();
                for (int i = 0; i < size; ++i) {
                    pushedHeaders.add(new Header(pushPromiseHeaders.name(i), pushPromiseHeaders.value(i)));
                }
                String requestLine = pushPromise.method() + ' ' + pushPromise.path() + " HTTP/1.1";
                List<Integer> chunkSizes = Collections.emptyList();
                MockWebServer.this.requestQueue.add(new RecordedRequest(requestLine, pushPromise.headers(), chunkSizes, 0L, new Buffer(), this.sequenceNumber.getAndIncrement(), this.socket));
                boolean hasBody = pushPromise.response().getBody() != null;
                FramedStream pushedStream = stream.getConnection().pushStream(stream.getId(), pushedHeaders, hasBody);
                this.writeResponse(pushedStream, pushPromise.response());
            }
        }
    }

    private static class TruncatingBuffer
    implements Sink {
        private final Buffer buffer = new Buffer();
        private long remainingByteCount;
        private long receivedByteCount;

        TruncatingBuffer(long bodyLimit) {
            this.remainingByteCount = bodyLimit;
        }

        @Override
        public void write(Buffer source, long byteCount) throws IOException {
            long toSkip;
            long toRead = Math.min(this.remainingByteCount, byteCount);
            if (toRead > 0L) {
                source.read(this.buffer, toRead);
            }
            if ((toSkip = byteCount - toRead) > 0L) {
                source.skip(toSkip);
            }
            this.remainingByteCount -= toRead;
            this.receivedByteCount += byteCount;
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public Timeout timeout() {
            return Timeout.NONE;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

