/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.mockwebserver;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.Socket;
import java.util.List;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.TlsVersion;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\b\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u00101\u001a\u0004\u0018\u00010\u00032\u0006\u00102\u001a\u00020\u0003J\b\u00103\u001a\u00020\u0003H\u0007J\b\u00104\u001a\u00020\u0003H\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010 \u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001fR\u0013\u0010#\u001a\u0004\u0018\u00010$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0013\u0010)\u001a\u0004\u0018\u00010*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\u00038GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b.\u0010/\u001a\u0004\b0\u0010\u001f\u00a8\u00065"}, d2={"Lokhttp3/mockwebserver/RecordedRequest;", "", "requestLine", "", "headers", "Lokhttp3/Headers;", "chunkSizes", "", "", "bodySize", "", "body", "Lokio/Buffer;", "sequenceNumber", "socket", "Ljava/net/Socket;", "(Ljava/lang/String;Lokhttp3/Headers;Ljava/util/List;JLokio/Buffer;ILjava/net/Socket;)V", "getBody", "()Lokio/Buffer;", "getBodySize", "()J", "getChunkSizes", "()Ljava/util/List;", "handshake", "Lokhttp3/Handshake;", "getHandshake", "()Lokhttp3/Handshake;", "getHeaders", "()Lokhttp3/Headers;", "method", "getMethod", "()Ljava/lang/String;", "path", "getPath", "getRequestLine", "requestUrl", "Lokhttp3/HttpUrl;", "getRequestUrl", "()Lokhttp3/HttpUrl;", "getSequenceNumber", "()I", "tlsVersion", "Lokhttp3/TlsVersion;", "getTlsVersion", "()Lokhttp3/TlsVersion;", "utf8Body", "utf8Body$annotations", "()V", "-deprecated_utf8Body", "getHeader", "name", "getUtf8Body", "toString", "mockwebserver"})
public final class RecordedRequest {
    @Nullable
    private final String method;
    @Nullable
    private final String path;
    @Nullable
    private final Handshake handshake;
    @Nullable
    private final HttpUrl requestUrl;
    @NotNull
    private final String requestLine;
    @NotNull
    private final Headers headers;
    @NotNull
    private final List<Integer> chunkSizes;
    private final long bodySize;
    @NotNull
    private final Buffer body;
    private final int sequenceNumber;

    @Nullable
    public final String getMethod() {
        return this.method;
    }

    @Nullable
    public final String getPath() {
        return this.path;
    }

    @Nullable
    public final Handshake getHandshake() {
        return this.handshake;
    }

    @Nullable
    public final HttpUrl getRequestUrl() {
        return this.requestUrl;
    }

    @Deprecated(message="Use body.readUtf8()", replaceWith=@ReplaceWith(imports={}, expression="body.readUtf8()"), level=DeprecationLevel.ERROR)
    public static /* synthetic */ void utf8Body$annotations() {
    }

    @JvmName(name="-deprecated_utf8Body")
    @NotNull
    public final String -deprecated_utf8Body() {
        return this.body.readUtf8();
    }

    @Nullable
    public final TlsVersion getTlsVersion() {
        Handshake handshake = this.handshake;
        return handshake != null ? handshake.tlsVersion() : null;
    }

    @Deprecated(message="Use body.readUtf8()", replaceWith=@ReplaceWith(imports={}, expression="body.readUtf8()"), level=DeprecationLevel.WARNING)
    @NotNull
    public final String getUtf8Body() {
        return this.body.readUtf8();
    }

    @Nullable
    public final String getHeader(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return (String)CollectionsKt.firstOrNull((List)this.headers.values(name));
    }

    @NotNull
    public String toString() {
        return this.requestLine;
    }

    @NotNull
    public final String getRequestLine() {
        return this.requestLine;
    }

    @NotNull
    public final Headers getHeaders() {
        return this.headers;
    }

    @NotNull
    public final List<Integer> getChunkSizes() {
        return this.chunkSizes;
    }

    public final long getBodySize() {
        return this.bodySize;
    }

    @NotNull
    public final Buffer getBody() {
        return this.body;
    }

    public final int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public RecordedRequest(@NotNull String requestLine, @NotNull Headers headers, @NotNull List<Integer> chunkSizes, long bodySize, @NotNull Buffer body, int sequenceNumber, @NotNull Socket socket) {
        Intrinsics.checkParameterIsNotNull((Object)requestLine, (String)"requestLine");
        Intrinsics.checkParameterIsNotNull((Object)headers, (String)"headers");
        Intrinsics.checkParameterIsNotNull(chunkSizes, (String)"chunkSizes");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Intrinsics.checkParameterIsNotNull((Object)socket, (String)"socket");
        this.requestLine = requestLine;
        this.headers = headers;
        this.chunkSizes = chunkSizes;
        this.bodySize = bodySize;
        this.body = body;
        this.sequenceNumber = sequenceNumber;
        if (socket instanceof SSLSocket) {
            try {
                SSLSession sSLSession = ((SSLSocket)socket).getSession();
                Intrinsics.checkExpressionValueIsNotNull((Object)sSLSession, (String)"socket.session");
                this.handshake = Handshake.Companion.get(sSLSession);
            }
            catch (IOException e) {
                throw (Throwable)new IllegalArgumentException(e);
            }
        } else {
            this.handshake = null;
        }
        CharSequence e = this.requestLine;
        boolean bl = false;
        if (e.length() > 0) {
            InetAddress inetAddress;
            String string;
            int methodEnd = StringsKt.indexOf$default((CharSequence)this.requestLine, (char)' ', (int)0, (boolean)false, (int)6, null);
            int pathEnd = StringsKt.indexOf$default((CharSequence)this.requestLine, (char)' ', (int)(methodEnd + 1), (boolean)false, (int)4, null);
            String string2 = this.requestLine;
            int n = 0;
            RecordedRequest recordedRequest = this;
            int n2 = 0;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, methodEnd);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            recordedRequest.method = string = string4;
            String string5 = this.requestLine;
            n2 = methodEnd + 1;
            boolean bl2 = false;
            String string6 = string5;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n2, pathEnd);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String path = string7;
            if (!StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
                path = "/";
            }
            this.path = path;
            String scheme = socket instanceof SSLSocket ? "https" : "http";
            InetAddress inetAddress2 = inetAddress = socket.getLocalAddress();
            Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress2, (String)"inetAddress");
            String hostname = inetAddress2.getHostName();
            if (inetAddress instanceof Inet6Address) {
                String string8 = hostname;
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"hostname");
                if (StringsKt.contains$default((CharSequence)string8, (char)':', (boolean)false, (int)2, null)) {
                    hostname = '[' + hostname + ']';
                }
            }
            int localPort = socket.getLocalPort();
            this.requestUrl = HttpUrl.Companion.parse(scheme + "://" + hostname + ':' + localPort + path);
        } else {
            this.requestUrl = null;
            this.method = null;
            this.path = null;
        }
    }
}

