/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.command;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.CommandSuggester;
import io.airlift.command.Context;
import io.airlift.command.GlobalSuggester;
import io.airlift.command.GroupSuggester;
import io.airlift.command.ParseState;
import io.airlift.command.Parser;
import io.airlift.command.ParserUtil;
import io.airlift.command.Suggester;
import io.airlift.command.model.CommandGroupMetadata;
import io.airlift.command.model.CommandMetadata;
import io.airlift.command.model.GlobalMetadata;
import io.airlift.command.model.MetadataLoader;
import io.airlift.command.model.OptionMetadata;
import io.airlift.command.model.SuggesterMetadata;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;

@Command(name="suggest")
public class SuggestCommand
implements Runnable,
Callable<Void> {
    private static final Map<Context, Class<? extends Suggester>> BUILTIN_SUGGESTERS = ImmutableMap.builder().put(Context.GLOBAL, GlobalSuggester.class).put(Context.GROUP, GroupSuggester.class).put(Context.COMMAND, CommandSuggester.class).build();
    @Inject
    public GlobalMetadata metadata;
    @Arguments
    public List<String> arguments = Lists.newArrayList();

    @VisibleForTesting
    public Iterable<String> generateSuggestions() {
        SuggesterMetadata suggesterMetadata;
        Parser parser = new Parser();
        ParseState state = parser.parse(this.metadata, this.arguments);
        Class<? extends Suggester> suggesterClass = BUILTIN_SUGGESTERS.get((Object)state.getLocation());
        if (suggesterClass != null && (suggesterMetadata = MetadataLoader.loadSuggester(suggesterClass)) != null) {
            ImmutableMap.Builder<Class<GlobalMetadata>, GlobalMetadata> bindings = ImmutableMap.builder().put(GlobalMetadata.class, this.metadata);
            if (state.getGroup() != null) {
                bindings.put(CommandGroupMetadata.class, (GlobalMetadata)((Object)state.getGroup()));
            }
            if (state.getCommand() != null) {
                bindings.put(CommandMetadata.class, (GlobalMetadata)((Object)state.getCommand()));
            }
            Suggester suggester = (Suggester)ParserUtil.createInstance(suggesterMetadata.getSuggesterClass(), ImmutableList.<OptionMetadata>of(), null, null, null, suggesterMetadata.getMetadataInjections(), bindings.build());
            return suggester.suggest();
        }
        return ImmutableList.of();
    }

    @Override
    public void run() {
        System.out.println(Joiner.on("\n").join(this.generateSuggestions()));
    }

    @Override
    public Void call() {
        this.run();
        return null;
    }
}

