/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.command;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class UsagePrinter {
    private final StringBuilder out;
    private final int maxSize;
    private final int indent;
    private final int hangingIndent;
    private final AtomicInteger currentPosition;

    public UsagePrinter(StringBuilder out) {
        this(out, 79);
    }

    public UsagePrinter(StringBuilder out, int maxSize) {
        this(out, maxSize, 0, 0, new AtomicInteger());
    }

    public UsagePrinter(StringBuilder out, int maxSize, int indent, int hangingIndent, AtomicInteger currentPosition) {
        this.out = out;
        this.maxSize = maxSize;
        this.indent = indent;
        this.hangingIndent = hangingIndent;
        this.currentPosition = currentPosition;
    }

    public UsagePrinter newIndentedPrinter(int size) {
        return new UsagePrinter(this.out, this.maxSize, this.indent + size, this.hangingIndent, this.currentPosition);
    }

    public UsagePrinter newPrinterWithHangingIndent(int size) {
        return new UsagePrinter(this.out, this.maxSize, this.indent, this.hangingIndent + size, this.currentPosition);
    }

    public UsagePrinter newline() {
        this.out.append("\n");
        this.currentPosition.set(0);
        return this;
    }

    public UsagePrinter appendTable(Iterable<? extends Iterable<String>> table) {
        int column;
        ArrayList<Integer> columnSizes = Lists.newArrayList();
        for (Iterable<String> iterable : table) {
            column = 0;
            for (String value : iterable) {
                while (column >= columnSizes.size()) {
                    columnSizes.add(0);
                }
                columnSizes.set(column, Math.max(value.length(), (Integer)columnSizes.get(column)));
                ++column;
            }
        }
        if (this.currentPosition.get() != 0) {
            this.currentPosition.set(0);
            this.out.append("\n");
        }
        for (Iterable<String> iterable : table) {
            column = 0;
            StringBuilder line = new StringBuilder();
            for (String value : iterable) {
                int columnSize = (Integer)columnSizes.get(column);
                line.append(value);
                line.append(UsagePrinter.spaces(columnSize - value.length()));
                line.append("   ");
                ++column;
            }
            this.out.append(UsagePrinter.spaces(this.indent)).append(line.toString().trim()).append("\n");
        }
        return this;
    }

    public UsagePrinter append(String value) {
        if (value == null) {
            return this;
        }
        return this.appendWords(Splitter.onPattern("\\s+").omitEmptyStrings().trimResults().split(String.valueOf(value)));
    }

    public UsagePrinter appendWords(Iterable<String> words) {
        for (String word : words) {
            if (this.currentPosition.get() == 0) {
                this.out.append(UsagePrinter.spaces(this.indent));
                this.currentPosition.getAndAdd(this.indent);
            } else if (word.length() > this.maxSize || this.currentPosition.get() + word.length() <= this.maxSize) {
                this.out.append(" ");
                this.currentPosition.getAndIncrement();
            } else {
                this.out.append("\n").append(UsagePrinter.spaces(this.indent)).append(UsagePrinter.spaces(this.hangingIndent));
                this.currentPosition.set(this.indent);
            }
            this.out.append(word);
            this.currentPosition.getAndAdd(word.length());
        }
        return this;
    }

    private static String spaces(int count) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            result.append(" ");
        }
        return result.toString();
    }
}

