/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.ec;

import java.math.BigInteger;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.ec.ECPair;
import org.bouncycastle.crypto.ec.ECPairFactorTransform;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;

public class ECFixedTransform
implements ECPairFactorTransform {
    private ECPublicKeyParameters key;
    private BigInteger k;

    public ECFixedTransform(BigInteger bigInteger) {
        this.k = bigInteger;
    }

    public void init(CipherParameters cipherParameters) {
        if (!(cipherParameters instanceof ECPublicKeyParameters)) {
            throw new IllegalArgumentException("ECPublicKeyParameters are required for fixed transform.");
        }
        this.key = (ECPublicKeyParameters)cipherParameters;
    }

    public ECPair transform(ECPair eCPair) {
        if (this.key == null) {
            throw new IllegalStateException("ECFixedTransform not initialised");
        }
        ECPoint eCPoint = this.key.getParameters().getG();
        ECPoint eCPoint2 = eCPoint.multiply(this.k);
        ECPoint eCPoint3 = this.key.getQ().multiply(this.k).add(eCPair.getY());
        return new ECPair(eCPair.getX().add(eCPoint2).normalize(), eCPoint3.normalize());
    }

    public BigInteger getTransformValue() {
        return this.k;
    }
}

