/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.curl;

import com.google.common.base.Joiner;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.HelpOption;
import io.airlift.airline.Option;
import io.airlift.airline.SingleCommand;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.framed.Http2;
import okhttp3.internal.http.StatusLine;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;

@Command(name="okcurl", description="A curl for the next-generation web.")
public class Main
extends HelpOption
implements Runnable {
    static final String NAME = "okcurl";
    static final int DEFAULT_TIMEOUT = -1;
    @Option(name={"-X", "--request"}, description="Specify request command to use")
    public String method;
    @Option(name={"-d", "--data"}, description="HTTP POST data")
    public String data;
    @Option(name={"-H", "--header"}, description="Custom header to pass to server")
    public List<String> headers;
    @Option(name={"-A", "--user-agent"}, description="User-Agent to send to server")
    public String userAgent = "okcurl/" + Main.versionString();
    @Option(name={"--connect-timeout"}, description="Maximum time allowed for connection (seconds)")
    public int connectTimeout = -1;
    @Option(name={"--read-timeout"}, description="Maximum time allowed for reading data (seconds)")
    public int readTimeout = -1;
    @Option(name={"-L", "--location"}, description="Follow redirects")
    public boolean followRedirects;
    @Option(name={"-k", "--insecure"}, description="Allow connections to SSL sites without certs")
    public boolean allowInsecure;
    @Option(name={"-i", "--include"}, description="Include protocol headers in the output")
    public boolean showHeaders;
    @Option(name={"--frames"}, description="Log HTTP/2 frames to STDERR")
    public boolean showHttp2Frames;
    @Option(name={"-e", "--referer"}, description="Referer URL")
    public String referer;
    @Option(name={"-V", "--version"}, description="Show version number and quit")
    public boolean version;
    @Arguments(title="url", description="Remote resource URL")
    public String url;
    private OkHttpClient client;

    static Main fromArgs(String ... args) {
        return (Main)SingleCommand.singleCommand(Main.class).parse(args);
    }

    public static void main(String ... args) {
        Main.fromArgs(args).run();
    }

    private static String versionString() {
        try {
            Properties prop = new Properties();
            InputStream in = Main.class.getResourceAsStream("/okcurl-version.properties");
            prop.load(in);
            in.close();
            return prop.getProperty("version");
        }
        catch (IOException e) {
            throw new AssertionError((Object)"Could not load okcurl-version.properties.");
        }
    }

    private static String protocols() {
        return Joiner.on((String)", ").join((Object[])Protocol.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.showHelpIfRequested()) {
            return;
        }
        if (this.version) {
            System.out.println("okcurl " + Main.versionString());
            System.out.println("Protocols: " + Main.protocols());
            return;
        }
        if (this.showHttp2Frames) {
            Main.enableHttp2FrameLogging();
        }
        this.client = this.createClient();
        Request request = this.createRequest();
        try {
            Response response = this.client.newCall(request).execute();
            if (this.showHeaders) {
                System.out.println(StatusLine.get((Response)response));
                Headers headers = response.headers();
                int size = headers.size();
                for (int i = 0; i < size; ++i) {
                    System.out.println(headers.name(i) + ": " + headers.value(i));
                }
                System.out.println();
            }
            Sink out = Okio.sink((OutputStream)System.out);
            BufferedSource source = response.body().source();
            while (!source.exhausted()) {
                out.write(source.buffer(), source.buffer().size());
                out.flush();
            }
            response.body().close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.close();
        }
    }

    private OkHttpClient createClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.followSslRedirects(this.followRedirects);
        if (this.connectTimeout != -1) {
            builder.connectTimeout((long)this.connectTimeout, TimeUnit.SECONDS);
        }
        if (this.readTimeout != -1) {
            builder.readTimeout((long)this.readTimeout, TimeUnit.SECONDS);
        }
        if (this.allowInsecure) {
            builder.sslSocketFactory(Main.createInsecureSslSocketFactory());
            builder.hostnameVerifier(Main.createInsecureHostnameVerifier());
        }
        return builder.build();
    }

    private String getRequestMethod() {
        if (this.method != null) {
            return this.method;
        }
        if (this.data != null) {
            return "POST";
        }
        return "GET";
    }

    private RequestBody getRequestBody() {
        if (this.data == null) {
            return null;
        }
        String bodyData = this.data;
        String mimeType = "application/x-www-form-urlencoded";
        if (this.headers != null) {
            for (String header : this.headers) {
                String[] parts = header.split(":", -1);
                if (!"Content-Type".equalsIgnoreCase(parts[0])) continue;
                mimeType = parts[1].trim();
                this.headers.remove(header);
                break;
            }
        }
        return RequestBody.create((MediaType)MediaType.parse((String)mimeType), (String)bodyData);
    }

    Request createRequest() {
        Request.Builder request = new Request.Builder();
        request.url(this.url);
        request.method(this.getRequestMethod(), this.getRequestBody());
        if (this.headers != null) {
            for (String header : this.headers) {
                String[] parts = header.split(":", 2);
                request.header(parts[0], parts[1]);
            }
        }
        if (this.referer != null) {
            request.header("Referer", this.referer);
        }
        request.header("User-Agent", this.userAgent);
        return request.build();
    }

    private void close() {
        this.client.connectionPool().evictAll();
    }

    private static SSLSocketFactory createInsecureSslSocketFactory() {
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            X509TrustManager permissive = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            context.init(null, new TrustManager[]{permissive}, null);
            return context.getSocketFactory();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private static HostnameVerifier createInsecureHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        };
    }

    private static void enableHttp2FrameLogging() {
        Logger logger = Logger.getLogger(Http2.class.getName() + "$FrameLogger");
        logger.setLevel(Level.FINE);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.FINE);
        handler.setFormatter(new SimpleFormatter(){

            @Override
            public String format(LogRecord record) {
                return String.format("%s%n", record.getMessage());
            }
        });
        logger.addHandler(handler);
    }
}

