/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.internal;

import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u0002\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u0004\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u0005\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u0002\u001a\u00020\u0007*\u00020\u0007H\u0000\u001a\f\u0010\u0000\u001a\u00020\u0007*\u00020\u0007H\u0000\u001a\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0000\u001a\f\u0010\u000b\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u000b\u001a\u00020\u0007*\u00020\u0007H\u0000\u001a\f\u0010\f\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a_\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u000126\u0010\u0011\u001a2\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u0002H\u000e0\u0012H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017\u001a_\u0010\u0018\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u000126\u0010\u0011\u001a2\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u0002H\u000e0\u0012H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017\u001a\u0014\u0010\u0019\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\u0019\u001a\u00020\u0007*\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0007H\u0000\u001a \u0010\u001b\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0000\u001a \u0010\u001b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0000\u001a0\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u0001H\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\""}, d2={"degToRad", "", "radToDeg", "gradToDeg", "turnToDeg", "degToGrad", "degToTurns", "", "cosDeg", "deg", "sinDeg", "normalizeDeg", "nanToOne", "toPolarModel", "T", "a", "b", "block", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "c", "h", "(FFLkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "fromPolarModel", "spow", "p", "sqrtSumSq", "scaleRange", "l1", "r1", "l2", "r2", "t", "colormath"})
public final class InternalMathKt {
    public static final float degToRad(float $this$degToRad) {
        return (float)InternalMathKt.degToRad((double)$this$degToRad);
    }

    public static final float radToDeg(float $this$radToDeg) {
        return (float)InternalMathKt.radToDeg((double)$this$radToDeg);
    }

    public static final float gradToDeg(float $this$gradToDeg) {
        return $this$gradToDeg * 0.9f;
    }

    public static final float turnToDeg(float $this$turnToDeg) {
        return $this$turnToDeg * 360.0f;
    }

    public static final float degToGrad(float $this$degToGrad) {
        return $this$degToGrad * 200.0f / 180.0f;
    }

    public static final float degToTurns(float $this$degToTurns) {
        return $this$degToTurns / 360.0f;
    }

    public static final double radToDeg(double $this$radToDeg) {
        return $this$radToDeg * 180.0 / Math.PI;
    }

    public static final double degToRad(double $this$degToRad) {
        return $this$degToRad * Math.PI / 180.0;
    }

    public static final double cosDeg(double deg) {
        return Math.cos(InternalMathKt.degToRad(deg));
    }

    public static final double sinDeg(double deg) {
        return Math.sin(InternalMathKt.degToRad(deg));
    }

    public static final float normalizeDeg(float $this$normalizeDeg) {
        return ($this$normalizeDeg % 360.0f + 360.0f) % 360.0f;
    }

    public static final double normalizeDeg(double $this$normalizeDeg) {
        return ($this$normalizeDeg % 360.0 + 360.0) % 360.0;
    }

    public static final float nanToOne(float $this$nanToOne) {
        return Float.isNaN($this$nanToOne) ? 1.0f : $this$nanToOne;
    }

    public static final <T> T toPolarModel(float a, float b, @NotNull Function2<? super Float, ? super Float, ? extends T> block) {
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$toPolarModel = false;
        float c = (float)Math.sqrt(a * a + b * b);
        float h = (double)c > -1.0E-7 && (double)c < 1.0E-7 ? Float.NaN : InternalMathKt.radToDeg((float)Math.atan2(b, a));
        return block.invoke(Float.valueOf(c), Float.valueOf(InternalMathKt.normalizeDeg(h)));
    }

    public static final <T> T fromPolarModel(float c, float h, @NotNull Function2<? super Float, ? super Float, ? extends T> block) {
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$fromPolarModel = false;
        float hDegrees = Float.isNaN(h) ? 0.0f : InternalMathKt.degToRad(h);
        float a = c * (float)Math.cos(hDegrees);
        float b = c * (float)Math.sin(hDegrees);
        return block.invoke(Float.valueOf(a), Float.valueOf(b));
    }

    public static final double spow(double $this$spow, double p) {
        return Math.copySign(Math.pow(Math.abs($this$spow), p), $this$spow);
    }

    public static final double spow(float $this$spow, double p) {
        return InternalMathKt.spow((double)$this$spow, p);
    }

    public static final float sqrtSumSq(float a, float b, float c) {
        return (float)Math.sqrt((float)Math.pow(a, 2) + (float)Math.pow(b, 2) + (float)Math.pow(c, 2));
    }

    public static final double sqrtSumSq(double a, double b) {
        return Math.sqrt(Math.pow(a, 2) + Math.pow(b, 2));
    }

    public static final double sqrtSumSq(double a, double b, double c) {
        return Math.sqrt(Math.pow(a, 2) + Math.pow(b, 2) + Math.pow(c, 2));
    }

    public static final float scaleRange(float l1, float r1, float l2, float r2, float t) {
        return r1 == l1 ? t : (r2 - l2) * (t - l1) / (r1 - l1) + l2;
    }
}

