/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal.terminalinterface.jna;

import com.github.ajalt.mordant.terminal.StandardTerminalInterface;
import com.github.ajalt.mordant.terminal.TerminalInterface;
import com.github.ajalt.mordant.terminal.TerminalInterfaceProvider;
import com.github.ajalt.mordant.terminal.terminalinterface.jna.TerminalInterfaceJnaLinux;
import com.github.ajalt.mordant.terminal.terminalinterface.jna.TerminalInterfaceJnaMacos;
import com.github.ajalt.mordant.terminal.terminalinterface.jna.TerminalInterfaceJnaWindows;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/github/ajalt/mordant/terminal/terminalinterface/jna/TerminalInterfaceProviderJna;", "Lcom/github/ajalt/mordant/terminal/TerminalInterfaceProvider;", "<init>", "()V", "load", "Lcom/github/ajalt/mordant/terminal/TerminalInterface;", "mordant-jvm-jna"})
public final class TerminalInterfaceProviderJna
implements TerminalInterfaceProvider {
    @Override
    @Nullable
    public TerminalInterface load() {
        TerminalInterface terminalInterface;
        boolean isNativeImage;
        String imageCode = System.getProperty("org.graalvm.nativeimage.imagecode");
        boolean bl = isNativeImage = Intrinsics.areEqual(imageCode, "buildtime") || Intrinsics.areEqual(imageCode, "runtime");
        if (isNativeImage) {
            return null;
        }
        String os = System.getProperty("os.name");
        try {
            Intrinsics.checkNotNull(os);
            terminalInterface = StringsKt.startsWith$default(os, "Windows", false, 2, null) ? (StandardTerminalInterface)new TerminalInterfaceJnaWindows() : (Intrinsics.areEqual(os, "Linux") ? (StandardTerminalInterface)new TerminalInterfaceJnaLinux() : (Intrinsics.areEqual(os, "Mac OS X") ? (StandardTerminalInterface)new TerminalInterfaceJnaMacos() : null));
        }
        catch (UnsatisfiedLinkError e) {
            terminalInterface = null;
        }
        return terminalInterface;
    }
}

