/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.widgets.progress;

import com.github.ajalt.mordant.rendering.TextAlign;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.table.Borders;
import com.github.ajalt.mordant.table.CellBuilder;
import com.github.ajalt.mordant.table.ColumnBuilder;
import com.github.ajalt.mordant.table.ColumnWidth;
import com.github.ajalt.mordant.table.GridBuilder;
import com.github.ajalt.mordant.table.HorizontalLayoutBuilder;
import com.github.ajalt.mordant.table.LinearLayoutBuilder;
import com.github.ajalt.mordant.table.RowBuilder;
import com.github.ajalt.mordant.table.TableDslKt;
import com.github.ajalt.mordant.table.VerticalLayoutBuilder;
import com.github.ajalt.mordant.widgets.EmptyWidget;
import com.github.ajalt.mordant.widgets.Padding;
import com.github.ajalt.mordant.widgets.progress.ProgressBarCell;
import com.github.ajalt.mordant.widgets.progress.ProgressBarDefinition;
import com.github.ajalt.mordant.widgets.progress.ProgressBarMakerRow;
import com.github.ajalt.mordant.widgets.progress.ProgressBarWidgetMaker;
import com.github.ajalt.mordant.widgets.progress.ProgressBarWidgetMakerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007H\u0016J$\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u00072\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007J\u001a\u0010\n\u001a\u00020\u00052\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007H\u0002J\u001c\u0010\u000b\u001a\u00020\u0005\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\bH\u0002J\u001a\u0010\u000e\u001a\u00020\u00052\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007H\u0002J4\u0010\u000f\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u0011\u0012\u0004\u0012\u00020\u00050\u00100\u0007\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\bH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/github/ajalt/mordant/widgets/progress/MultiProgressBarWidgetMaker;", "Lcom/github/ajalt/mordant/widgets/progress/ProgressBarWidgetMaker;", "<init>", "()V", "build", "Lcom/github/ajalt/mordant/rendering/Widget;", "rows", "", "Lcom/github/ajalt/mordant/widgets/progress/ProgressBarMakerRow;", "buildCells", "makeVerticalLayout", "makeHorizontalLayout", "T", "row", "makeTable", "renderRow", "Lkotlin/Pair;", "Lcom/github/ajalt/mordant/widgets/progress/ProgressBarCell;", "mordant"})
@SourceDebugExtension(value={"SMAP\nProgressBarWidgetMaker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProgressBarWidgetMaker.kt\ncom/github/ajalt/mordant/widgets/progress/MultiProgressBarWidgetMaker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Padding.kt\ncom/github/ajalt/mordant/widgets/Padding$Companion\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1734#2,3:164\n1557#2:167\n1628#2,3:168\n1557#2:171\n1628#2,3:172\n12#3,2:175\n1#4:177\n*S KotlinDebug\n*F\n+ 1 ProgressBarWidgetMaker.kt\ncom/github/ajalt/mordant/widgets/progress/MultiProgressBarWidgetMaker\n*L\n38#1:164,3\n52#1:167\n52#1:168,3\n138#1:171\n138#1:172,3\n124#1:175,2\n*E\n"})
public final class MultiProgressBarWidgetMaker
implements ProgressBarWidgetMaker {
    @NotNull
    public static final MultiProgressBarWidgetMaker INSTANCE = new MultiProgressBarWidgetMaker();

    private MultiProgressBarWidgetMaker() {
    }

    @Override
    @NotNull
    public Widget build(@NotNull List<? extends ProgressBarMakerRow<?>> rows) {
        Widget widget;
        Intrinsics.checkNotNullParameter(rows, "rows");
        if (rows.isEmpty()) {
            widget = EmptyWidget.INSTANCE;
        } else if (rows.size() == 1) {
            widget = this.makeHorizontalLayout(rows.get(0));
        } else {
            boolean bl;
            block7: {
                Iterable $this$all$iv = rows;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        ProgressBarMakerRow it = (ProgressBarMakerRow)element$iv;
                        boolean bl2 = false;
                        if (it.getDefinition().getAlignColumns()) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            }
            widget = bl ? this.makeTable(rows) : this.makeVerticalLayout(rows);
        }
        return widget;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<List<Widget>> buildCells(@NotNull List<? extends ProgressBarMakerRow<?>> rows) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(rows, "rows");
        Iterable $this$map$iv = rows;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void row;
            ProgressBarMakerRow progressBarMakerRow = (ProgressBarMakerRow)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = INSTANCE.renderRow((ProgressBarMakerRow)row);
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                Pair pair = (Pair)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add((Widget)it.getSecond());
            }
            collection.add((List)destination$iv$iv2);
        }
        return (List)destination$iv$iv;
    }

    private final Widget makeVerticalLayout(List<? extends ProgressBarMakerRow<?>> rows) {
        return TableDslKt.verticalLayout(arg_0 -> MultiProgressBarWidgetMaker.makeVerticalLayout$lambda$3(rows, arg_0));
    }

    private final <T> Widget makeHorizontalLayout(ProgressBarMakerRow<T> row) {
        return TableDslKt.horizontalLayout(arg_0 -> MultiProgressBarWidgetMaker.makeHorizontalLayout$lambda$5(row, arg_0));
    }

    private final Widget makeTable(List<? extends ProgressBarMakerRow<?>> rows) {
        return TableDslKt.grid(arg_0 -> MultiProgressBarWidgetMaker.makeTable$lambda$12(rows, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final <T> List<Pair<ProgressBarCell<T>, Widget>> renderRow(ProgressBarMakerRow<T> row) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = row.getDefinition().getCells();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void cell;
            ProgressBarCell progressBarCell = (ProgressBarCell)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(cell, cell.getContent().invoke(row.getState())));
        }
        return (List)destination$iv$iv;
    }

    private static final Unit makeVerticalLayout$lambda$3(List $rows, VerticalLayoutBuilder $this$verticalLayout) {
        Intrinsics.checkNotNullParameter($rows, "$rows");
        Intrinsics.checkNotNullParameter($this$verticalLayout, "$this$verticalLayout");
        $this$verticalLayout.setAlign(TextAlign.LEFT);
        int alignStart = -1;
        Iterator iterator2 = ((Iterable)$rows).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            ProgressBarMakerRow row = (ProgressBarMakerRow)iterator2.next();
            if (!row.getDefinition().getAlignColumns()) {
                if (alignStart >= 0) {
                    LinearLayoutBuilder.DefaultImpls.cell$default($this$verticalLayout, INSTANCE.makeTable($rows.subList(alignStart, i)), null, 2, null);
                    alignStart = -1;
                }
                LinearLayoutBuilder.DefaultImpls.cell$default($this$verticalLayout, INSTANCE.makeHorizontalLayout(row), null, 2, null);
                continue;
            }
            if (alignStart >= 0) continue;
            alignStart = i;
        }
        if (alignStart >= 0) {
            LinearLayoutBuilder.DefaultImpls.cell$default($this$verticalLayout, INSTANCE.makeTable($rows.subList(alignStart, $rows.size())), null, 2, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit makeHorizontalLayout$lambda$5$lambda$4(ProgressBarCell $barCell, ColumnBuilder $this$column) {
        Intrinsics.checkNotNullParameter($barCell, "$barCell");
        Intrinsics.checkNotNullParameter($this$column, "$this$column");
        $this$column.setWidth($barCell.getColumnWidth());
        $this$column.setAlign($barCell.getAlign());
        $this$column.setVerticalAlign($barCell.getVerticalAlign());
        return Unit.INSTANCE;
    }

    private static final Unit makeHorizontalLayout$lambda$5(ProgressBarMakerRow $row, HorizontalLayoutBuilder $this$horizontalLayout) {
        Intrinsics.checkNotNullParameter($row, "$row");
        Intrinsics.checkNotNullParameter($this$horizontalLayout, "$this$horizontalLayout");
        $this$horizontalLayout.setSpacing($row.getDefinition().getSpacing());
        Iterator iterator2 = ((Iterable)$row.getDefinition().getCells()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            ProgressBarCell barCell = (ProgressBarCell)iterator2.next();
            LinearLayoutBuilder.DefaultImpls.cell$default($this$horizontalLayout, barCell.getContent().invoke($row.getState()), null, 2, null);
            $this$horizontalLayout.column(i, arg_0 -> MultiProgressBarWidgetMaker.makeHorizontalLayout$lambda$5$lambda$4(barCell, arg_0));
        }
        return Unit.INSTANCE;
    }

    private static final Unit makeTable$lambda$12$lambda$7(List $rows, int $i, ColumnBuilder $this$column) {
        Intrinsics.checkNotNullParameter($rows, "$rows");
        Intrinsics.checkNotNullParameter($this$column, "$this$column");
        Iterator iterator2 = ((Iterable)$rows).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            ColumnWidth columnWidth;
            int j = n++;
            ProgressBarMakerRow row = (ProgressBarMakerRow)iterator2.next();
            ProgressBarDefinition d = row.component1();
            if (!d.getAlignColumns()) continue;
            ColumnWidth w1 = $this$column.getWidth();
            ProgressBarCell progressBarCell = CollectionsKt.getOrNull(d.getCells(), $i);
            if (progressBarCell == null || (progressBarCell = progressBarCell.getColumnWidth()) == null) continue;
            ProgressBarCell w2 = progressBarCell;
            if (TableDslKt.isExpand(w1) || TableDslKt.isExpand((ColumnWidth)((Object)w2))) {
                Float f = ProgressBarWidgetMakerKt.access$nullMax(w1.getExpandWeight(), ((ColumnWidth)((Object)w2)).getExpandWeight());
                columnWidth = ColumnWidth.Companion.Expand(Float.valueOf(f != null ? f.floatValue() : 1.0f));
            } else if (j > 0 && TableDslKt.isAuto(w1) || TableDslKt.isAuto((ColumnWidth)((Object)w2))) {
                columnWidth = ColumnWidth.Companion.getAuto();
            } else {
                Integer n2 = ProgressBarWidgetMakerKt.access$nullMax(w1.getWidth(), ((ColumnWidth)((Object)w2)).getWidth());
                Intrinsics.checkNotNull(n2);
                columnWidth = ColumnWidth.Companion.Fixed(n2);
            }
            $this$column.setWidth(columnWidth);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit makeTable$lambda$12$lambda$11$lambda$9(Pair $c, int $i, ProgressBarMakerRow $r, CellBuilder $this$cell) {
        void $this$makeTable_u24lambda_u2412_u24lambda_u2411_u24lambda_u249_u24lambda_u248;
        Padding.Builder builder2;
        Intrinsics.checkNotNullParameter($c, "$c");
        Intrinsics.checkNotNullParameter($r, "$r");
        Intrinsics.checkNotNullParameter($this$cell, "$this$cell");
        $this$cell.setAlign(((ProgressBarCell)$c.getFirst()).getAlign());
        $this$cell.setVerticalAlign(((ProgressBarCell)$c.getFirst()).getVerticalAlign());
        Padding.Companion this_$iv = Padding.Companion;
        boolean $i$f$invoke = false;
        Padding.Builder builder3 = builder2 = new Padding.Builder(0, 0, 0, 0);
        CellBuilder cellBuilder = $this$cell;
        boolean bl = false;
        $this$makeTable_u24lambda_u2412_u24lambda_u2411_u24lambda_u249_u24lambda_u248.setLeft($i == 0 ? 0 : $r.getDefinition().getSpacing());
        Padding.Builder b$iv = builder2;
        cellBuilder.setPadding(new Padding(b$iv.getTop(), b$iv.getRight(), b$iv.getBottom(), b$iv.getLeft()));
        return Unit.INSTANCE;
    }

    private static final Unit makeTable$lambda$12$lambda$11$lambda$10(CellBuilder $this$cell) {
        Intrinsics.checkNotNullParameter($this$cell, "$this$cell");
        $this$cell.setColumnSpan(Integer.MAX_VALUE);
        return Unit.INSTANCE;
    }

    private static final Unit makeTable$lambda$12$lambda$11(ProgressBarMakerRow $r, RowBuilder $this$row) {
        Intrinsics.checkNotNullParameter($r, "$r");
        Intrinsics.checkNotNullParameter($this$row, "$this$row");
        if ($r.getDefinition().getAlignColumns()) {
            Iterator iterator2 = ((Iterable)INSTANCE.renderRow($r)).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int i = n++;
                Pair c = (Pair)iterator2.next();
                $this$row.cell(c.getSecond(), arg_0 -> MultiProgressBarWidgetMaker.makeTable$lambda$12$lambda$11$lambda$9(c, i, $r, arg_0));
            }
        } else {
            $this$row.cell(INSTANCE.makeHorizontalLayout($r), MultiProgressBarWidgetMaker::makeTable$lambda$12$lambda$11$lambda$10);
        }
        return Unit.INSTANCE;
    }

    private static final Unit makeTable$lambda$12(List $rows, GridBuilder $this$grid) {
        int n;
        Intrinsics.checkNotNullParameter($rows, "$rows");
        Intrinsics.checkNotNullParameter($this$grid, "$this$grid");
        $this$grid.setAddPaddingWidthToFixedWidth(true);
        $this$grid.setCellBorders(Borders.NONE);
        Iterator iterator2 = ((Iterable)$rows).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        ProgressBarMakerRow progressBarMakerRow = (ProgressBarMakerRow)iterator2.next();
        boolean bl = false;
        ProgressBarDefinition d = progressBarMakerRow.component1();
        int n2 = n = d.getAlignColumns() ? d.getCells().size() : 0;
        while (iterator2.hasNext()) {
            ProgressBarMakerRow progressBarMakerRow2 = (ProgressBarMakerRow)iterator2.next();
            $i$a$-maxOf-MultiProgressBarWidgetMaker$makeTable$1$columnCount$1 = false;
            ProgressBarDefinition d2 = progressBarMakerRow2.component1();
            int n3 = d2.getAlignColumns() ? d2.getCells().size() : 0;
            if (n >= n3) continue;
            n = n3;
        }
        int columnCount = n;
        for (int i = 0; i < columnCount; ++i) {
            $this$grid.column(i, arg_0 -> MultiProgressBarWidgetMaker.makeTable$lambda$12$lambda$7($rows, i, arg_0));
        }
        for (ProgressBarMakerRow r : $rows) {
            $this$grid.row(arg_0 -> MultiProgressBarWidgetMaker.makeTable$lambda$12$lambda$11(r, arg_0));
        }
        return Unit.INSTANCE;
    }
}

