/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.io.IOException;
import java.net.ProtocolException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.UnreadableResponseBodyKt;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http2.ConnectionShutdownException;
import okio.BufferedSink;
import okio.Okio;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lokhttp3/internal/http/CallServerInterceptor;", "Lokhttp3/Interceptor;", "forWebSocket", "", "<init>", "(Z)V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "shouldIgnoreAndWaitForRealResponse", "code", "", "exchange", "Lokhttp3/internal/connection/Exchange;", "okhttp"})
public final class CallServerInterceptor
implements Interceptor {
    private final boolean forWebSocket;

    public CallServerInterceptor(boolean forWebSocket) {
        this.forWebSocket = forWebSocket;
    }

    @Override
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkNotNullParameter(chain, "chain");
        RealInterceptorChain realChain = (RealInterceptorChain)chain;
        Exchange exchange = realChain.getExchange$okhttp();
        Intrinsics.checkNotNull(exchange);
        Exchange exchange2 = exchange;
        Request request = realChain.getRequest$okhttp();
        RequestBody requestBody = request.body();
        long sentRequestMillis = System.currentTimeMillis();
        boolean invokeStartEvent = true;
        Response.Builder responseBuilder = null;
        IOException sendRequestException = null;
        try {
            exchange2.writeRequestHeaders(request);
            if (HttpMethod.permitsRequestBody(request.method()) && requestBody != null) {
                if (StringsKt.equals("100-continue", request.header("Expect"), true)) {
                    exchange2.flushRequest();
                    responseBuilder = exchange2.readResponseHeaders(true);
                    exchange2.responseHeadersStart();
                    invokeStartEvent = false;
                }
                if (responseBuilder == null) {
                    BufferedSink bufferedRequestBody;
                    if (requestBody.isDuplex()) {
                        exchange2.flushRequest();
                        bufferedRequestBody = Okio.buffer(exchange2.createRequestBody(request, true));
                        requestBody.writeTo(bufferedRequestBody);
                    } else {
                        bufferedRequestBody = Okio.buffer(exchange2.createRequestBody(request, false));
                        requestBody.writeTo(bufferedRequestBody);
                        bufferedRequestBody.close();
                    }
                } else {
                    exchange2.noRequestBody();
                    if (!exchange2.getConnection$okhttp().isMultiplexed$okhttp()) {
                        exchange2.noNewExchangesOnConnection();
                    }
                }
            } else {
                exchange2.noRequestBody();
            }
            if (requestBody == null || !requestBody.isDuplex()) {
                exchange2.finishRequest();
            }
        }
        catch (IOException e) {
            if (e instanceof ConnectionShutdownException) {
                throw e;
            }
            if (!exchange2.getHasFailure$okhttp()) {
                throw e;
            }
            sendRequestException = e;
        }
        try {
            if (responseBuilder == null) {
                Response.Builder builder2 = exchange2.readResponseHeaders(false);
                Intrinsics.checkNotNull(builder2);
                responseBuilder = builder2;
                if (invokeStartEvent) {
                    exchange2.responseHeadersStart();
                    invokeStartEvent = false;
                }
            }
            Response response = responseBuilder.request(request).handshake(exchange2.getConnection$okhttp().handshake()).sentRequestAtMillis(sentRequestMillis).receivedResponseAtMillis(System.currentTimeMillis()).build();
            int code = response.code();
            while (this.shouldIgnoreAndWaitForRealResponse(code, exchange2)) {
                Intrinsics.checkNotNull(exchange2.readResponseHeaders(false));
                if (invokeStartEvent) {
                    exchange2.responseHeadersStart();
                }
                response = responseBuilder.request(request).handshake(exchange2.getConnection$okhttp().handshake()).sentRequestAtMillis(sentRequestMillis).receivedResponseAtMillis(System.currentTimeMillis()).build();
                code = response.code();
            }
            exchange2.responseHeadersEnd(response);
            Response response2 = response = this.forWebSocket && code == 101 ? UnreadableResponseBodyKt.stripBody(response) : response.newBuilder().body(exchange2.openResponseBody(response)).build();
            if (StringsKt.equals("close", response.request().header("Connection"), true) || StringsKt.equals("close", Response.header$default(response, "Connection", null, 2, null), true)) {
                exchange2.noNewExchangesOnConnection();
            }
            if ((code == 204 || code == 205) && response.body().contentLength() > 0L) {
                throw new ProtocolException("HTTP " + code + " had non-zero Content-Length: " + response.body().contentLength());
            }
            return response;
        }
        catch (IOException e) {
            if (sendRequestException != null) {
                ExceptionsKt.addSuppressed(sendRequestException, e);
                throw sendRequestException;
            }
            throw e;
        }
    }

    private final boolean shouldIgnoreAndWaitForRealResponse(int code, Exchange exchange) {
        return code == 100 ? true : (102 <= code ? code < 200 : false);
    }
}

