/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.curl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.EventListener;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.curl.Main;
import okhttp3.internal.Util;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.http2.Http2;
import okhttp3.internal.platform.Platform;
import okhttp3.logging.HttpLoggingInterceptor;
import okhttp3.logging.LoggingEventListener;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.AutoComplete;
import picocli.CommandLine;

@CommandLine.Command(name="okcurl", versionProvider=VersionProvider.class, mixinStandardHelpOptions=true, description={"A curl for the next-generation web."})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010!\n\u0002\b \n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 I2\u00020\u0001:\u0002IJB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010A\u001a\u00020BH\u0002J\b\u0010C\u001a\u00020\u0010H\u0002J\u0006\u0010D\u001a\u00020EJ\n\u0010F\u001a\u0004\u0018\u00010GH\u0002J\b\u0010H\u001a\u00020BH\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0006\"\u0004\b\u0013\u0010\bR\u001e\u0010\u0014\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\f\"\u0004\b\u0016\u0010\u000eR \u0010\u0017\u001a\u0004\u0018\u00010\u00188\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001d\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0006\"\u0004\b\u001f\u0010\bR&\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010!8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R \u0010&\u001a\u0004\u0018\u00010\u00188\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001a\"\u0004\b(\u0010\u001cR\u001e\u0010)\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\f\"\u0004\b+\u0010\u000eR \u0010,\u001a\u0004\u0018\u00010\u00188\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u001a\"\u0004\b.\u0010\u001cR\u001e\u0010/\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0006\"\u0004\b1\u0010\bR\u001e\u00102\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0006\"\u0004\b4\u0010\bR\u001e\u00105\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0006\"\u0004\b7\u0010\bR \u00108\u001a\u0004\u0018\u00010\u00188\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u001a\"\u0004\b:\u0010\u001cR\u001e\u0010;\u001a\u00020\u00188\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u001a\"\u0004\b=\u0010\u001cR\u001e\u0010>\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\u0006\"\u0004\b@\u0010\b\u00a8\u0006K"}, d2={"Lokhttp3/curl/Main;", "Ljava/lang/Runnable;", "()V", "allowInsecure", "", "getAllowInsecure", "()Z", "setAllowInsecure", "(Z)V", "callTimeout", "", "getCallTimeout", "()I", "setCallTimeout", "(I)V", "client", "Lokhttp3/OkHttpClient;", "completionScript", "getCompletionScript", "setCompletionScript", "connectTimeout", "getConnectTimeout", "setConnectTimeout", "data", "", "getData", "()Ljava/lang/String;", "setData", "(Ljava/lang/String;)V", "followRedirects", "getFollowRedirects", "setFollowRedirects", "headers", "", "getHeaders", "()Ljava/util/List;", "setHeaders", "(Ljava/util/List;)V", "method", "getMethod", "setMethod", "readTimeout", "getReadTimeout", "setReadTimeout", "referer", "getReferer", "setReferer", "showHeaders", "getShowHeaders", "setShowHeaders", "showHttp2Frames", "getShowHttp2Frames", "setShowHttp2Frames", "sslDebug", "getSslDebug", "setSslDebug", "url", "getUrl", "setUrl", "userAgent", "getUserAgent", "setUserAgent", "verbose", "getVerbose", "setVerbose", "close", "", "createClient", "createRequest", "Lokhttp3/Request;", "mediaType", "Lokhttp3/MediaType;", "run", "Companion", "VersionProvider", "okcurl"})
public final class Main
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @CommandLine.Option(names={"-X", "--request"}, description={"Specify request command to use"})
    @Nullable
    private String method;
    @CommandLine.Option(names={"-d", "--data"}, description={"HTTP POST data"})
    @Nullable
    private String data;
    @CommandLine.Option(names={"-H", "--header"}, description={"Custom header to pass to server"})
    @Nullable
    private List<String> headers;
    @CommandLine.Option(names={"-A", "--user-agent"}, description={"User-Agent to send to server"})
    @NotNull
    private String userAgent = Intrinsics.stringPlus((String)"okcurl/", (Object)okhttp3.curl.Main$Companion.access$versionString(Companion));
    @CommandLine.Option(names={"--connect-timeout"}, description={"Maximum time allowed for connection (seconds)"})
    private int connectTimeout = -1;
    @CommandLine.Option(names={"--read-timeout"}, description={"Maximum time allowed for reading data (seconds)"})
    private int readTimeout = -1;
    @CommandLine.Option(names={"--call-timeout"}, description={"Maximum time allowed for the entire call (seconds)"})
    private int callTimeout = -1;
    @CommandLine.Option(names={"-L", "--location"}, description={"Follow redirects"})
    private boolean followRedirects;
    @CommandLine.Option(names={"-k", "--insecure"}, description={"Allow connections to SSL sites without certs"})
    private boolean allowInsecure;
    @CommandLine.Option(names={"-i", "--include"}, description={"Include protocol headers in the output"})
    private boolean showHeaders;
    @CommandLine.Option(names={"--frames"}, description={"Log HTTP/2 frames to STDERR"})
    private boolean showHttp2Frames;
    @CommandLine.Option(names={"-e", "--referer"}, description={"Referer URL"})
    @Nullable
    private String referer;
    @CommandLine.Option(names={"-v", "--verbose"}, description={"Makes okcurl verbose during the operation"})
    private boolean verbose;
    @CommandLine.Option(names={"--ssldebug"}, description={"Output SSL Debug"})
    private boolean sslDebug;
    @CommandLine.Option(names={"--completionScript"}, hidden=true)
    private boolean completionScript;
    @CommandLine.Parameters(description={"Remote resource URL"}, paramLabel="url")
    @Nullable
    private String url;
    private OkHttpClient client;
    @NotNull
    public static final String NAME = "okcurl";
    public static final int DEFAULT_TIMEOUT = -1;
    @Nullable
    private static Logger frameLogger;
    @Nullable
    private static Logger sslLogger;

    @Nullable
    public final String getMethod() {
        return this.method;
    }

    public final void setMethod(@Nullable String string) {
        this.method = string;
    }

    @Nullable
    public final String getData() {
        return this.data;
    }

    public final void setData(@Nullable String string) {
        this.data = string;
    }

    @Nullable
    public final List<String> getHeaders() {
        return this.headers;
    }

    public final void setHeaders(@Nullable List<String> list) {
        this.headers = list;
    }

    @NotNull
    public final String getUserAgent() {
        return this.userAgent;
    }

    public final void setUserAgent(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.userAgent = string;
    }

    public final int getConnectTimeout() {
        return this.connectTimeout;
    }

    public final void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }

    public final int getReadTimeout() {
        return this.readTimeout;
    }

    public final void setReadTimeout(int n) {
        this.readTimeout = n;
    }

    public final int getCallTimeout() {
        return this.callTimeout;
    }

    public final void setCallTimeout(int n) {
        this.callTimeout = n;
    }

    public final boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public final void setFollowRedirects(boolean bl) {
        this.followRedirects = bl;
    }

    public final boolean getAllowInsecure() {
        return this.allowInsecure;
    }

    public final void setAllowInsecure(boolean bl) {
        this.allowInsecure = bl;
    }

    public final boolean getShowHeaders() {
        return this.showHeaders;
    }

    public final void setShowHeaders(boolean bl) {
        this.showHeaders = bl;
    }

    public final boolean getShowHttp2Frames() {
        return this.showHttp2Frames;
    }

    public final void setShowHttp2Frames(boolean bl) {
        this.showHttp2Frames = bl;
    }

    @Nullable
    public final String getReferer() {
        return this.referer;
    }

    public final void setReferer(@Nullable String string) {
        this.referer = string;
    }

    public final boolean getVerbose() {
        return this.verbose;
    }

    public final void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public final boolean getSslDebug() {
        return this.sslDebug;
    }

    public final void setSslDebug(boolean bl) {
        this.sslDebug = bl;
    }

    public final boolean getCompletionScript() {
        return this.completionScript;
    }

    public final void setCompletionScript(boolean bl) {
        this.completionScript = bl;
    }

    @Nullable
    public final String getUrl() {
        return this.url;
    }

    public final void setUrl(@Nullable String string) {
        this.url = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.completionScript) {
            String string = AutoComplete.bash((String)NAME, (CommandLine)new CommandLine((Object)new Main()));
            boolean bl = false;
            System.out.println((Object)string);
            return;
        }
        if (this.showHttp2Frames) {
            Main.Companion.enableHttp2FrameLogging();
        }
        if (this.sslDebug) {
            Main.Companion.enableSslDebugging();
        }
        this.client = this.createClient();
        Request request = this.createRequest();
        try {
            OkHttpClient okHttpClient;
            OkHttpClient okHttpClient2 = this.client;
            if (okHttpClient2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                okHttpClient = null;
            } else {
                okHttpClient = okHttpClient2;
            }
            Response response = okHttpClient.newCall(request).execute();
            if (this.showHeaders) {
                okHttpClient2 = StatusLine.Companion.get(response);
                boolean bl = false;
                System.out.println(okHttpClient2);
                Headers headers = response.headers();
                for (Pair pair : headers) {
                    String name = (String)pair.component1();
                    String value = (String)pair.component2();
                    String string = name + ": " + value;
                    boolean bl2 = false;
                    System.out.println((Object)string);
                }
                boolean bl3 = false;
                System.out.println();
            }
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"out");
            Sink out = Okio.sink((OutputStream)printStream);
            ResponseBody responseBody = response.body();
            Intrinsics.checkNotNull((Object)responseBody);
            BufferedSource source = responseBody.source();
            while (!source.exhausted()) {
                out.write(source.getBuffer(), source.getBuffer().size());
                out.flush();
            }
            ResponseBody responseBody2 = response.body();
            Intrinsics.checkNotNull((Object)responseBody2);
            responseBody2.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.close();
        }
    }

    private final OkHttpClient createClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.followSslRedirects(this.followRedirects);
        if (this.connectTimeout != -1) {
            builder.connectTimeout((long)this.connectTimeout, TimeUnit.SECONDS);
        }
        if (this.readTimeout != -1) {
            builder.readTimeout((long)this.readTimeout, TimeUnit.SECONDS);
        }
        if (this.callTimeout != -1) {
            builder.callTimeout((long)this.callTimeout, TimeUnit.SECONDS);
        }
        if (this.allowInsecure) {
            X509TrustManager trustManager = Main.Companion.createInsecureTrustManager();
            SSLSocketFactory sslSocketFactory = Main.Companion.createInsecureSslSocketFactory(trustManager);
            builder.sslSocketFactory(sslSocketFactory, trustManager);
            builder.hostnameVerifier(Main.Companion.createInsecureHostnameVerifier());
        }
        if (this.verbose) {
            HttpLoggingInterceptor.Logger logger2 = createClient.logger.1.INSTANCE;
            builder.eventListenerFactory((EventListener.Factory)new LoggingEventListener.Factory(logger2));
        }
        return builder.build();
    }

    @NotNull
    public final Request createRequest() {
        Object it;
        boolean bl;
        boolean bl2;
        Object object;
        Request.Builder request = new Request.Builder();
        String string = this.method;
        String requestMethod = string == null ? (this.data != null ? "POST" : "GET") : string;
        Object object2 = this.url;
        if (object2 == null) {
            throw new IllegalArgumentException("No url provided");
        }
        String url = object2;
        request.url(url);
        object2 = this.data;
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl3 = false;
            request.method(requestMethod, RequestBody.Companion.create((String)it, this.mediaType()));
        }
        object = this.headers;
        bl2 = false;
        Object object3 = object;
        if (object3 == null) {
            object3 = CollectionsKt.emptyList();
        }
        object2 = object3.iterator();
        while (object2.hasNext()) {
            String header = (String)object2.next();
            char[] cArray = new char[]{':'};
            List parts = StringsKt.split$default((CharSequence)header, (char[])cArray, (boolean)false, (int)2, (int)2, null);
            request.header((String)parts.get(0), (String)parts.get(1));
        }
        object2 = this.referer;
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl4 = false;
            request.header("Referer", (String)it);
        }
        request.header("User-Agent", this.userAgent);
        return request.build();
    }

    private final MediaType mediaType() {
        String string;
        List<String> list = this.headers;
        if (list == null) {
            string = "application/x-www-form-urlencoded";
        } else {
            String string2;
            String string3;
            block4: {
                List<String> list2 = list;
                boolean bl = false;
                boolean bl2 = false;
                List<String> it = list2;
                boolean bl3 = false;
                for (String header : it) {
                    Object object;
                    List parts = StringsKt.split$default((CharSequence)header, (char[])(object = new char[]{':'}), (boolean)false, (int)2, (int)2, null);
                    if (!StringsKt.equals((String)"Content-Type", (String)((String)parts.get(0)), (boolean)true)) continue;
                    it.remove(header);
                    object = (String)parts.get(1);
                    boolean bl4 = false;
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    string3 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
                    break block4;
                }
                string3 = null;
            }
            string = (string2 = string3) == null ? "application/x-www-form-urlencoded" : string2;
        }
        String mimeType = string;
        return MediaType.Companion.parse(mimeType);
    }

    private final void close() {
        OkHttpClient okHttpClient;
        OkHttpClient okHttpClient2;
        OkHttpClient okHttpClient3 = this.client;
        if (okHttpClient3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            okHttpClient2 = null;
        } else {
            okHttpClient2 = okHttpClient3;
        }
        okHttpClient2.connectionPool().evictAll();
        okHttpClient3 = this.client;
        if (okHttpClient3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            okHttpClient = null;
        } else {
            okHttpClient = okHttpClient3;
        }
        okHttpClient.dispatcher().executorService().shutdownNow();
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lokhttp3/curl/Main$VersionProvider;", "Lpicocli/CommandLine$IVersionProvider;", "()V", "getVersion", "", "", "()[Ljava/lang/String;", "okcurl"})
    public static final class VersionProvider
    implements CommandLine.IVersionProvider {
        @NotNull
        public String[] getVersion() {
            String[] stringArray = new String[]{Intrinsics.stringPlus((String)"okcurl ", (Object)Companion.versionString()), Intrinsics.stringPlus((String)"Protocols: ", (Object)ArraysKt.joinToString$default((Object[])Protocol.values(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)), Intrinsics.stringPlus((String)"Platform: ", (Object)Platform.Companion.get().getClass().getSimpleName())};
            return stringArray;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\u001b\u0010\u0015\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017H\u0007\u00a2\u0006\u0002\u0010\u0018J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lokhttp3/curl/Main$Companion;", "", "()V", "DEFAULT_TIMEOUT", "", "NAME", "", "frameLogger", "Ljava/util/logging/Logger;", "sslLogger", "createInsecureHostnameVerifier", "Ljavax/net/ssl/HostnameVerifier;", "createInsecureSslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "trustManager", "Ljavax/net/ssl/TrustManager;", "createInsecureTrustManager", "Ljavax/net/ssl/X509TrustManager;", "enableHttp2FrameLogging", "", "enableSslDebugging", "main", "args", "", "([Ljava/lang/String;)V", "versionString", "okcurl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (System.getProperty("javax.net.debug") == null) {
                System.setProperty("javax.net.debug", "");
            }
            int n = new CommandLine((Object)new Main()).execute(Arrays.copyOf(args, args.length));
            boolean bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String versionString() {
            Properties prop = new Properties();
            Closeable closeable = Main.class.getResourceAsStream("/okcurl-version.properties");
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl3 = false;
                prop.load(it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return prop.getProperty("version", "dev");
        }

        private final X509TrustManager createInsecureTrustManager() {
            return new X509TrustManager(){

                public void checkClientTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) {
                    Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                    Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
                }

                public void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) {
                    Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                    Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
                }

                @NotNull
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
        }

        private final SSLSocketFactory createInsecureSslSocketFactory(TrustManager trustManager) {
            SSLContext sSLContext = Platform.Companion.get().newSSLContext();
            boolean bl = false;
            boolean bl2 = false;
            SSLContext $this$createInsecureSslSocketFactory_u24lambda_u2d1 = sSLContext;
            boolean bl3 = false;
            TrustManager[] trustManagerArray = new TrustManager[]{trustManager};
            $this$createInsecureSslSocketFactory_u24lambda_u2d1.init(null, trustManagerArray, null);
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"Platform.get().newSSLCon\u2026)\n        }.socketFactory");
            return sSLSocketFactory;
        }

        private final HostnameVerifier createInsecureHostnameVerifier() {
            return Companion::createInsecureHostnameVerifier$lambda-2;
        }

        /*
         * WARNING - void declaration
         */
        private final void enableHttp2FrameLogging() {
            void $this$enableHttp2FrameLogging_u24lambda_u2d4_u24lambda_u2d3;
            Logger logger2 = Logger.getLogger(Http2.class.getName());
            boolean bl = false;
            boolean bl2 = false;
            Logger $this$enableHttp2FrameLogging_u24lambda_u2d4 = logger2;
            boolean bl3 = false;
            $this$enableHttp2FrameLogging_u24lambda_u2d4.setLevel(Level.FINE);
            ConsoleHandler consoleHandler = new ConsoleHandler();
            boolean bl4 = false;
            boolean bl5 = false;
            ConsoleHandler consoleHandler2 = consoleHandler;
            Logger logger3 = $this$enableHttp2FrameLogging_u24lambda_u2d4;
            boolean bl6 = false;
            $this$enableHttp2FrameLogging_u24lambda_u2d4_u24lambda_u2d3.setLevel(Level.FINE);
            $this$enableHttp2FrameLogging_u24lambda_u2d4_u24lambda_u2d3.setFormatter(new SimpleFormatter(){

                @NotNull
                public String format(@NotNull LogRecord record) {
                    Intrinsics.checkNotNullParameter((Object)record, (String)"record");
                    Object[] objectArray = new Object[1];
                    String string = record.getMessage();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"record.message");
                    objectArray[0] = string;
                    return Util.format((String)"%s%n", (Object[])objectArray);
                }
            });
            Unit unit = Unit.INSTANCE;
            logger3.addHandler(consoleHandler);
            frameLogger = logger2;
        }

        /*
         * WARNING - void declaration
         */
        private final void enableSslDebugging() {
            void $this$enableSslDebugging_u24lambda_u2d6_u24lambda_u2d5;
            Logger logger2 = Logger.getLogger("javax.net.ssl");
            boolean bl = false;
            boolean bl2 = false;
            Logger $this$enableSslDebugging_u24lambda_u2d6 = logger2;
            boolean bl3 = false;
            $this$enableSslDebugging_u24lambda_u2d6.setLevel(Level.FINE);
            ConsoleHandler consoleHandler = new ConsoleHandler();
            boolean bl4 = false;
            boolean bl5 = false;
            ConsoleHandler consoleHandler2 = consoleHandler;
            Logger logger3 = $this$enableSslDebugging_u24lambda_u2d6;
            boolean bl6 = false;
            $this$enableSslDebugging_u24lambda_u2d6_u24lambda_u2d5.setLevel(Level.FINE);
            $this$enableSslDebugging_u24lambda_u2d6_u24lambda_u2d5.setFormatter(new SimpleFormatter(){

                @NotNull
                public String format(@NotNull LogRecord record) {
                    String string;
                    Intrinsics.checkNotNullParameter((Object)record, (String)"record");
                    Object[] parameters = record.getParameters();
                    if (parameters != null) {
                        Object[] objectArray = new Object[2];
                        Object object = record.getMessage();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"record.message");
                        objectArray[0] = object;
                        object = ArraysKt.first((Object[])parameters);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.first()");
                        objectArray[1] = object;
                        string = Util.format((String)"%s%n%s%n", (Object[])objectArray);
                    } else {
                        Object[] objectArray = new Object[1];
                        String string2 = record.getMessage();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"record.message");
                        objectArray[0] = string2;
                        string = Util.format((String)"%s%n", (Object[])objectArray);
                    }
                    return string;
                }
            });
            Unit unit = Unit.INSTANCE;
            logger3.addHandler(consoleHandler);
            sslLogger = logger2;
        }

        private static final boolean createInsecureHostnameVerifier$lambda-2(String $noName_0, SSLSession $noName_1) {
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

