/*
 * Decompiled with CFR 0.152.
 */
package assertk.assertions;

import assertk.Assert;
import assertk.FailureKt;
import assertk.ValueAssert;
import assertk.assertions.AnyKt;
import assertk.assertions.FileKt;
import assertk.assertions.StringKt;
import assertk.assertions.support.SupportKt;
import java.io.File;
import java.nio.charset.Charset;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a\u0010\u0010\u0004\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a\u0018\u0010\b\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\t\u001a\u00020\u0003\u001a\u0018\u0010\n\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\t\u001a\u00020\u0007\u001a\u0018\u0010\u000b\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\t\u001a\u00020\u0007\u001a\u0018\u0010\f\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\t\u001a\u00020\u0007\u001a\u0018\u0010\r\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\t\u001a\u00020\u0007\u001a\"\u0010\u000e\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a\u0010\u0010\u0011\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a\u0010\u0010\u0012\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a\u0010\u0010\u0013\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a\u0010\u0010\u0014\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a\u001e\u0010\u0015\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00070\u00070\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a\u001e\u0010\u0017\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00070\u00070\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a\u001e\u0010\u0018\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00070\u00070\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u001a"}, d2={"bytes", "Lassertk/Assert;", "", "Ljava/io/File;", "exists", "", "extension", "", "hasDirectChild", "expected", "hasExtension", "hasName", "hasParent", "hasPath", "hasText", "charset", "Ljava/nio/charset/Charset;", "isDirectory", "isFile", "isHidden", "isNotHidden", "name", "kotlin.jvm.PlatformType", "parent", "path", "text", "assertk"})
public final class FileKt {
    @NotNull
    public static final Assert<String> name(@NotNull Assert<? extends File> $this$name) {
        Intrinsics.checkNotNullParameter($this$name, "<this>");
        return AnyKt.prop($this$name, "name", name.1.INSTANCE);
    }

    @NotNull
    public static final Assert<String> path(@NotNull Assert<? extends File> $this$path) {
        Intrinsics.checkNotNullParameter($this$path, "<this>");
        return AnyKt.prop($this$path, "path", path.1.INSTANCE);
    }

    @NotNull
    public static final Assert<String> parent(@NotNull Assert<? extends File> $this$parent) {
        Intrinsics.checkNotNullParameter($this$parent, "<this>");
        return AnyKt.prop($this$parent, "parent", parent.1.INSTANCE);
    }

    @NotNull
    public static final Assert<String> extension(@NotNull Assert<? extends File> $this$extension) {
        Intrinsics.checkNotNullParameter($this$extension, "<this>");
        return AnyKt.prop($this$extension, "extension", extension.1.INSTANCE);
    }

    @NotNull
    public static final Assert<String> text(@NotNull Assert<? extends File> $this$text, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter($this$text, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        return AnyKt.prop($this$text, "text", (Function1)new Function1<File, String>(charset){
            final /* synthetic */ Charset $charset;
            {
                this.$charset = $charset;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return FilesKt.readText(it, this.$charset);
            }
        });
    }

    public static /* synthetic */ Assert text$default(Assert assert_, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return FileKt.text(assert_, charset);
    }

    @NotNull
    public static final Assert<byte[]> bytes(@NotNull Assert<? extends File> $this$bytes) {
        Intrinsics.checkNotNullParameter($this$bytes, "<this>");
        return AnyKt.prop($this$bytes, "bytes", bytes.1.INSTANCE);
    }

    public static final void exists(@NotNull Assert<? extends File> $this$exists) {
        Intrinsics.checkNotNullParameter($this$exists, "<this>");
        Assert<? extends File> this_$iv = $this$exists;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                File actual = (File)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (actual.exists()) {
                    return;
                }
                SupportKt.expected$default($this$exists, "to exist", null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isDirectory(@NotNull Assert<? extends File> $this$isDirectory) {
        Intrinsics.checkNotNullParameter($this$isDirectory, "<this>");
        Assert<? extends File> this_$iv = $this$isDirectory;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                File actual = (File)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (actual.isDirectory()) {
                    return;
                }
                SupportKt.expected$default($this$isDirectory, "to be a directory", null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isFile(@NotNull Assert<? extends File> $this$isFile) {
        Intrinsics.checkNotNullParameter($this$isFile, "<this>");
        Assert<? extends File> this_$iv = $this$isFile;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                File actual = (File)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (actual.isFile()) {
                    return;
                }
                SupportKt.expected$default($this$isFile, "to be a file", null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isHidden(@NotNull Assert<? extends File> $this$isHidden) {
        Intrinsics.checkNotNullParameter($this$isHidden, "<this>");
        Assert<? extends File> this_$iv = $this$isHidden;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                File actual = (File)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (actual.isHidden()) {
                    return;
                }
                SupportKt.expected$default($this$isHidden, "to be hidden", null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isNotHidden(@NotNull Assert<? extends File> $this$isNotHidden) {
        Intrinsics.checkNotNullParameter($this$isNotHidden, "<this>");
        Assert<? extends File> this_$iv = $this$isNotHidden;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                File actual = (File)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (!actual.isHidden()) {
                    return;
                }
                SupportKt.expected$default($this$isNotHidden, "to not be hidden", null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void hasName(@NotNull Assert<? extends File> $this$hasName, @NotNull String expected) {
        Intrinsics.checkNotNullParameter($this$hasName, "<this>");
        Intrinsics.checkNotNullParameter(expected, "expected");
        StringKt.isEqualTo$default(FileKt.name($this$hasName), expected, false, 2, null);
    }

    public static final void hasPath(@NotNull Assert<? extends File> $this$hasPath, @NotNull String expected) {
        Intrinsics.checkNotNullParameter($this$hasPath, "<this>");
        Intrinsics.checkNotNullParameter(expected, "expected");
        StringKt.isEqualTo$default(FileKt.path($this$hasPath), new File(expected).getPath(), false, 2, null);
    }

    public static final void hasParent(@NotNull Assert<? extends File> $this$hasParent, @NotNull String expected) {
        Intrinsics.checkNotNullParameter($this$hasParent, "<this>");
        Intrinsics.checkNotNullParameter(expected, "expected");
        StringKt.isEqualTo$default(FileKt.parent($this$hasParent), new File(expected).getPath(), false, 2, null);
    }

    public static final void hasExtension(@NotNull Assert<? extends File> $this$hasExtension, @NotNull String expected) {
        Intrinsics.checkNotNullParameter($this$hasExtension, "<this>");
        Intrinsics.checkNotNullParameter(expected, "expected");
        StringKt.isEqualTo$default(FileKt.extension($this$hasExtension), expected, false, 2, null);
    }

    public static final void hasText(@NotNull Assert<? extends File> $this$hasText, @NotNull String expected, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter($this$hasText, "<this>");
        Intrinsics.checkNotNullParameter(expected, "expected");
        Intrinsics.checkNotNullParameter(charset, "charset");
        StringKt.isEqualTo$default(FileKt.text($this$hasText, charset), expected, false, 2, null);
    }

    public static /* synthetic */ void hasText$default(Assert assert_, String string, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        FileKt.hasText(assert_, string, charset);
    }

    public static final void hasDirectChild(@NotNull Assert<? extends File> $this$hasDirectChild, @NotNull File expected) {
        Intrinsics.checkNotNullParameter($this$hasDirectChild, "<this>");
        Intrinsics.checkNotNullParameter(expected, "expected");
        Assert<? extends File> this_$iv = $this$hasDirectChild;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                File actual = (File)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                File[] fileArray = actual.listFiles();
                if (fileArray == null ? false : ArraysKt.contains(fileArray, expected)) {
                    return;
                }
                SupportKt.expected$default($this$hasDirectChild, Intrinsics.stringPlus("to have direct child ", SupportKt.show$default(expected, null, 2, null)), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }
}

