/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.internal._UtilCommonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u001a%\u0010\u0000\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u00a2\u0006\u0002\u0010\u0005\u001a!\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\"\u00020\u0001H\u0000\u00a2\u0006\u0002\u0010\t\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a\f\u0010\u000e\u001a\u00020\u0001*\u00020\u000fH\u0002\u001a\u001c\u0010\u0010\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0012\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0007H\u0000\u001a\u001c\u0010\u0014\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0000\u001a\f\u0010\u0015\u001a\u00020\u0007*\u00020\u0011H\u0000\u001a\u0016\u0010\u0016\u001a\u00020\u0017*\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0000\u001a\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u0001*\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a\f\u0010\u001b\u001a\u00020\u001c*\u00020\u0007H\u0000\u001a\u001e\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u001f0\u001e*\u00020\u0007H\u0000\u001a\u0014\u0010 \u001a\u00020\u0001*\u00020\u00072\u0006\u0010!\u001a\u00020\u001cH\u0000\u001a\f\u0010\"\u001a\u00020\u0011*\u00020\u0007H\u0000\u001a\u0014\u0010#\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a\u001c\u0010$\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0000\u001a\u0018\u0010%\u001a\u00020\u0007*\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010&H\u0000\u001a\f\u0010'\u001a\u00020\u0001*\u00020\u0007H\u0000\u001a\u0014\u0010(\u001a\u00020\u0001*\u00020\u00072\u0006\u0010!\u001a\u00020\u001cH\u0000\u001a\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00010**\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u00a8\u0006+"}, d2={"commonHeadersGet", "", "namesAndValues", "", "name", "([Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "commonHeadersOf", "Lokhttp3/Headers;", "inputNamesAndValues", "([Ljava/lang/String;)Lokhttp3/Headers;", "headersCheckName", "", "headersCheckValue", "value", "charCode", "", "commonAdd", "Lokhttp3/Headers$Builder;", "commonAddAll", "headers", "commonAddLenient", "commonBuild", "commonEquals", "", "other", "", "commonGet", "commonHashCode", "", "commonIterator", "", "Lkotlin/Pair;", "commonName", "index", "commonNewBuilder", "commonRemoveAll", "commonSet", "commonToHeaders", "", "commonToString", "commonValue", "commonValues", "", "okhttp"})
public final class _HeadersCommonKt {
    @NotNull
    public static final String commonName(@NotNull Headers $this$commonName, int index) {
        Intrinsics.checkNotNullParameter($this$commonName, "<this>");
        String string = ArraysKt.getOrNull($this$commonName.getNamesAndValues$okhttp(), index * 2);
        if (string == null) {
            throw new IndexOutOfBoundsException("name[" + index + ']');
        }
        return string;
    }

    @NotNull
    public static final String commonValue(@NotNull Headers $this$commonValue, int index) {
        Intrinsics.checkNotNullParameter($this$commonValue, "<this>");
        String string = ArraysKt.getOrNull($this$commonValue.getNamesAndValues$okhttp(), index * 2 + 1);
        if (string == null) {
            throw new IndexOutOfBoundsException("value[" + index + ']');
        }
        return string;
    }

    @NotNull
    public static final List<String> commonValues(@NotNull Headers $this$commonValues, @NotNull String name2) {
        Intrinsics.checkNotNullParameter($this$commonValues, "<this>");
        Intrinsics.checkNotNullParameter(name2, "name");
        List result = null;
        int n = 0;
        int n2 = $this$commonValues.size();
        while (n < n2) {
            int i;
            if (!StringsKt.equals(name2, $this$commonValues.name(i = n++), true)) continue;
            if (result == null) {
                result = new ArrayList(2);
            }
            result.add($this$commonValues.value(i));
        }
        List list = result;
        List<String> list2 = list == null ? null : CollectionsKt.toList(list);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    public static final Iterator<Pair<String, String>> commonIterator(@NotNull Headers $this$commonIterator) {
        Intrinsics.checkNotNullParameter($this$commonIterator, "<this>");
        int n = 0;
        int n2 = $this$commonIterator.size();
        Pair[] pairArray = new Pair[n2];
        while (n < n2) {
            int n3 = n++;
            pairArray[n3] = TuplesKt.to($this$commonIterator.name(n3), $this$commonIterator.value(n3));
        }
        return ArrayIteratorKt.iterator(pairArray);
    }

    @NotNull
    public static final Headers.Builder commonNewBuilder(@NotNull Headers $this$commonNewBuilder) {
        Intrinsics.checkNotNullParameter($this$commonNewBuilder, "<this>");
        Headers.Builder result = new Headers.Builder();
        CollectionsKt.addAll((Collection)result.getNamesAndValues$okhttp(), $this$commonNewBuilder.getNamesAndValues$okhttp());
        return result;
    }

    public static final boolean commonEquals(@NotNull Headers $this$commonEquals, @Nullable Object other) {
        Intrinsics.checkNotNullParameter($this$commonEquals, "<this>");
        return other instanceof Headers && Arrays.equals($this$commonEquals.getNamesAndValues$okhttp(), ((Headers)other).getNamesAndValues$okhttp());
    }

    public static final int commonHashCode(@NotNull Headers $this$commonHashCode) {
        Intrinsics.checkNotNullParameter($this$commonHashCode, "<this>");
        return Arrays.hashCode($this$commonHashCode.getNamesAndValues$okhttp());
    }

    @NotNull
    public static final String commonToString(@NotNull Headers $this$commonToString) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$commonToString, "<this>");
        StringBuilder $this$commonToString_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = 0;
        int n2 = $this$commonToString.size();
        while (n < n2) {
            int i = n++;
            String name2 = $this$commonToString.name(i);
            String value = $this$commonToString.value(i);
            $this$commonToString_u24lambda_u2d0.append(name2);
            $this$commonToString_u24lambda_u2d0.append(": ");
            $this$commonToString_u24lambda_u2d0.append(_UtilCommonKt.isSensitiveHeader(name2) ? "\u2588\u2588" : value);
            $this$commonToString_u24lambda_u2d0.append("\n");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Nullable
    public static final String commonHeadersGet(@NotNull String[] namesAndValues, @NotNull String name2) {
        int n;
        Intrinsics.checkNotNullParameter(namesAndValues, "namesAndValues");
        Intrinsics.checkNotNullParameter(name2, "name");
        int n2 = n = namesAndValues.length - 2;
        int n3 = ProgressionUtilKt.getProgressionLastElement(n, 0, -2);
        if (n3 <= n2) {
            int i;
            do {
                i = n2;
                n2 -= 2;
                if (!StringsKt.equals(name2, namesAndValues[i], true)) continue;
                return namesAndValues[i + 1];
            } while (i != n3);
        }
        return null;
    }

    @NotNull
    public static final Headers.Builder commonAdd(@NotNull Headers.Builder $this$commonAdd, @NotNull String name2, @NotNull String value) {
        Headers.Builder builder;
        Intrinsics.checkNotNullParameter($this$commonAdd, "<this>");
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(value, "value");
        Headers.Builder $this$commonAdd_u24lambda_u2d1 = builder = $this$commonAdd;
        boolean bl = false;
        _HeadersCommonKt.headersCheckName(name2);
        _HeadersCommonKt.headersCheckValue(value, name2);
        _HeadersCommonKt.commonAddLenient($this$commonAdd_u24lambda_u2d1, name2, value);
        return builder;
    }

    @NotNull
    public static final Headers.Builder commonAddAll(@NotNull Headers.Builder $this$commonAddAll, @NotNull Headers headers2) {
        Headers.Builder builder;
        Intrinsics.checkNotNullParameter($this$commonAddAll, "<this>");
        Intrinsics.checkNotNullParameter(headers2, "headers");
        Headers.Builder $this$commonAddAll_u24lambda_u2d2 = builder = $this$commonAddAll;
        boolean bl = false;
        int n = 0;
        int n2 = headers2.size();
        while (n < n2) {
            int i = n++;
            _HeadersCommonKt.commonAddLenient($this$commonAddAll_u24lambda_u2d2, headers2.name(i), headers2.value(i));
        }
        return builder;
    }

    @NotNull
    public static final Headers.Builder commonAddLenient(@NotNull Headers.Builder $this$commonAddLenient, @NotNull String name2, @NotNull String value) {
        Headers.Builder builder;
        Intrinsics.checkNotNullParameter($this$commonAddLenient, "<this>");
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(value, "value");
        Headers.Builder $this$commonAddLenient_u24lambda_u2d3 = builder = $this$commonAddLenient;
        boolean bl = false;
        $this$commonAddLenient_u24lambda_u2d3.getNamesAndValues$okhttp().add(name2);
        $this$commonAddLenient_u24lambda_u2d3.getNamesAndValues$okhttp().add(((Object)StringsKt.trim((CharSequence)value)).toString());
        return builder;
    }

    @NotNull
    public static final Headers.Builder commonRemoveAll(@NotNull Headers.Builder $this$commonRemoveAll, @NotNull String name2) {
        Headers.Builder builder;
        Intrinsics.checkNotNullParameter($this$commonRemoveAll, "<this>");
        Intrinsics.checkNotNullParameter(name2, "name");
        Headers.Builder $this$commonRemoveAll_u24lambda_u2d4 = builder = $this$commonRemoveAll;
        boolean bl = false;
        for (int i = 0; i < $this$commonRemoveAll_u24lambda_u2d4.getNamesAndValues$okhttp().size(); i += 2) {
            if (!StringsKt.equals(name2, $this$commonRemoveAll_u24lambda_u2d4.getNamesAndValues$okhttp().get(i), true)) continue;
            $this$commonRemoveAll_u24lambda_u2d4.getNamesAndValues$okhttp().remove(i);
            $this$commonRemoveAll_u24lambda_u2d4.getNamesAndValues$okhttp().remove(i);
            i -= 2;
        }
        return builder;
    }

    @NotNull
    public static final Headers.Builder commonSet(@NotNull Headers.Builder $this$commonSet, @NotNull String name2, @NotNull String value) {
        Headers.Builder builder;
        Intrinsics.checkNotNullParameter($this$commonSet, "<this>");
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(value, "value");
        Headers.Builder $this$commonSet_u24lambda_u2d5 = builder = $this$commonSet;
        boolean bl = false;
        _HeadersCommonKt.headersCheckName(name2);
        _HeadersCommonKt.headersCheckValue(value, name2);
        $this$commonSet_u24lambda_u2d5.removeAll(name2);
        _HeadersCommonKt.commonAddLenient($this$commonSet_u24lambda_u2d5, name2, value);
        return builder;
    }

    @Nullable
    public static final String commonGet(@NotNull Headers.Builder $this$commonGet, @NotNull String name2) {
        int n;
        Intrinsics.checkNotNullParameter($this$commonGet, "<this>");
        Intrinsics.checkNotNullParameter(name2, "name");
        int n2 = n = $this$commonGet.getNamesAndValues$okhttp().size() - 2;
        int n3 = ProgressionUtilKt.getProgressionLastElement(n, 0, -2);
        if (n3 <= n2) {
            int i;
            do {
                i = n2;
                n2 -= 2;
                if (!StringsKt.equals(name2, $this$commonGet.getNamesAndValues$okhttp().get(i), true)) continue;
                return $this$commonGet.getNamesAndValues$okhttp().get(i + 1);
            } while (i != n3);
        }
        return null;
    }

    @NotNull
    public static final Headers commonBuild(@NotNull Headers.Builder $this$commonBuild) {
        Intrinsics.checkNotNullParameter($this$commonBuild, "<this>");
        Collection $this$toTypedArray$iv = $this$commonBuild.getNamesAndValues$okhttp();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return new Headers(stringArray);
    }

    public static final void headersCheckName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        if (!(((CharSequence)name2).length() > 0)) {
            boolean bl = false;
            String string = "name is empty";
            throw new IllegalArgumentException(string.toString());
        }
        int n = 0;
        int n2 = name2.length();
        while (n < n2) {
            int i;
            char c;
            if ('!' <= (c = name2.charAt(i = n++)) ? c < '\u007f' : false) continue;
            boolean bl = false;
            String string = "Unexpected char 0x" + _HeadersCommonKt.charCode(c) + " at " + i + " in header name: " + name2;
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void headersCheckValue(@NotNull String value, @NotNull String name2) {
        int i;
        char c;
        boolean bl;
        Intrinsics.checkNotNullParameter(value, "value");
        Intrinsics.checkNotNullParameter(name2, "name");
        int n = 0;
        int n2 = value.length();
        do {
            block6: {
                block5: {
                    if (n >= n2) {
                        return;
                    }
                    if ((c = value.charAt(i = n++)) == '\t') break block5;
                    boolean bl2 = ' ' <= c ? c < '\u007f' : false;
                    if (!bl2) break block6;
                }
                bl = true;
                continue;
            }
            bl = false;
        } while (bl);
        boolean bl3 = false;
        String string = "Unexpected char 0x" + _HeadersCommonKt.charCode(c) + " at " + i + " in " + name2 + " value" + (_UtilCommonKt.isSensitiveHeader(name2) ? "" : Intrinsics.stringPlus(": ", value));
        throw new IllegalArgumentException(string.toString());
    }

    private static final String charCode(char $this$charCode) {
        String string = Integer.toString($this$charCode, CharsKt.checkRadix(16));
        Intrinsics.checkNotNullExpressionValue(string, "toString(this, checkRadix(radix))");
        String it = string;
        boolean bl = false;
        return it.length() < 2 ? Intrinsics.stringPlus("0", it) : it;
    }

    @NotNull
    public static final Headers commonHeadersOf(String ... inputNamesAndValues) {
        Intrinsics.checkNotNullParameter(inputNamesAndValues, "inputNamesAndValues");
        if (!(inputNamesAndValues.length % 2 == 0)) {
            boolean bl = false;
            String string = "Expected alternating header names and values";
            throw new IllegalArgumentException(string.toString());
        }
        String[] namesAndValues = Arrays.copyOf(inputNamesAndValues, inputNamesAndValues.length);
        int n = 0;
        int n2 = namesAndValues.length;
        while (n < n2) {
            int i;
            if (!(namesAndValues[i = n++] != null)) {
                boolean $i$a$-require-_HeadersCommonKt$commonHeadersOf$32 = false;
                String $i$a$-require-_HeadersCommonKt$commonHeadersOf$32 = "Headers cannot be null";
                throw new IllegalArgumentException($i$a$-require-_HeadersCommonKt$commonHeadersOf$32.toString());
            }
            namesAndValues[i] = ((Object)StringsKt.trim((CharSequence)inputNamesAndValues[i])).toString();
        }
        n2 = 0;
        n = namesAndValues.length + -1;
        int n3 = ProgressionUtilKt.getProgressionLastElement(0, n, 2);
        if (n2 <= n3) {
            int i;
            do {
                i = n2;
                n2 += 2;
                String name2 = namesAndValues[i];
                String value = namesAndValues[i + 1];
                _HeadersCommonKt.headersCheckName(name2);
                _HeadersCommonKt.headersCheckValue(value, name2);
            } while (i != n3);
        }
        return new Headers(namesAndValues);
    }

    @NotNull
    public static final Headers commonToHeaders(@NotNull Map<String, String> $this$commonToHeaders) {
        Intrinsics.checkNotNullParameter($this$commonToHeaders, "<this>");
        String[] namesAndValues = new String[$this$commonToHeaders.size() * 2];
        int i = 0;
        for (Map.Entry<String, String> entry : $this$commonToHeaders.entrySet()) {
            String k = entry.getKey();
            String v = entry.getValue();
            String name2 = ((Object)StringsKt.trim((CharSequence)k)).toString();
            String value = ((Object)StringsKt.trim((CharSequence)v)).toString();
            _HeadersCommonKt.headersCheckName(name2);
            _HeadersCommonKt.headersCheckValue(value, name2);
            namesAndValues[i] = name2;
            namesAndValues[i + 1] = value;
            i += 2;
        }
        return new Headers(namesAndValues);
    }
}

