/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal.http2.Header;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u00ba\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0004\u001a\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0000\u001a \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010H\u0000\u001a'\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001a\"\u00020\u001b\u00a2\u0006\u0002\u0010\u001c\u001a-\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001f0\u001e\"\u0004\b\u0000\u0010\u001f2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u001f0\u001a\"\u0002H\u001fH\u0007\u00a2\u0006\u0002\u0010!\u001a3\u0010\"\u001a\u0004\u0018\u0001H\u001f\"\u0004\b\u0000\u0010\u001f2\u0006\u0010#\u001a\u00020\u001b2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\u001f0%2\u0006\u0010&\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\u0010'\u001a\u0016\u0010(\u001a\u00020)2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\t\u001a\"\u0010+\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00140-H\u0080\b\u00f8\u0001\u0000\u001a\f\u0010.\u001a\u00020/*\u000200H\u0000\u001a\r\u00101\u001a\u00020\u0014*\u00020\u001bH\u0080\b\u001a\r\u00102\u001a\u00020\u0014*\u00020\u001bH\u0080\b\u001a\u0014\u00103\u001a\u00020\t*\u0002042\u0006\u00105\u001a\u000204H\u0000\u001a\n\u00106\u001a\u00020\u0014*\u000207\u001a\f\u00106\u001a\u00020\u0014*\u000208H\u0000\u001a\u001c\u00109\u001a\u00020\t*\u00020:2\u0006\u0010;\u001a\u00020\r2\u0006\u0010<\u001a\u00020\u0012H\u0000\u001a\f\u0010=\u001a\u00020\u0010*\u00020>H\u0000\u001a\u0014\u0010?\u001a\u00020\t*\u0002082\u0006\u0010@\u001a\u00020AH\u0000\u001a\r\u0010B\u001a\u00020\u0014*\u00020\u001bH\u0080\b\u001a\r\u0010C\u001a\u00020\u0014*\u00020\u001bH\u0080\b\u001a\n\u0010D\u001a\u00020\u000b*\u000208\u001a\u0014\u0010E\u001a\u00020F*\u00020A2\u0006\u0010G\u001a\u00020FH\u0000\u001a\u001c\u0010H\u001a\u00020\t*\u00020:2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010<\u001a\u00020\u0012H\u0000\u001a\u0012\u0010I\u001a\b\u0012\u0004\u0012\u00020J0\u001e*\u00020\u0001H\u0000\u001a\u0012\u0010K\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020J0\u001eH\u0000\u001a\f\u0010L\u001a\u00020\u000b*\u00020\rH\u0000\u001a\f\u0010L\u001a\u00020\u000b*\u00020\u0010H\u0000\u001a\u0016\u0010M\u001a\u00020\u000b*\u0002042\b\b\u0002\u0010N\u001a\u00020\tH\u0000\u001a\u001c\u0010O\u001a\b\u0012\u0004\u0012\u0002H\u001f0\u001e\"\u0004\b\u0000\u0010\u001f*\b\u0012\u0004\u0012\u0002H\u001f0\u001e\u001a0\u0010P\u001a\u000e\u0012\u0004\u0012\u0002HR\u0012\u0004\u0012\u0002HS0Q\"\u0004\b\u0000\u0010R\"\u0004\b\u0001\u0010S*\u000e\u0012\u0004\u0012\u0002HR\u0012\u0004\u0012\u0002HS0QH\u0000\u001a\r\u0010T\u001a\u00020\u0014*\u00020\u001bH\u0080\b\"\u0010\u0010\u0000\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0006\u001a\u00020\u00078\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\b\u001a\u00020\t8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\n\u001a\u00020\u000b8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006U"}, d2={"EMPTY_HEADERS", "Lokhttp3/Headers;", "EMPTY_REQUEST", "Lokhttp3/RequestBody;", "EMPTY_RESPONSE", "Lokhttp3/ResponseBody;", "UTC", "Ljava/util/TimeZone;", "assertionsEnabled", "", "okHttpName", "", "checkDuration", "", "name", "duration", "", "unit", "Ljava/util/concurrent/TimeUnit;", "checkOffsetAndCount", "", "arrayLength", "offset", "count", "format", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "immutableListOf", "", "T", "elements", "([Ljava/lang/Object;)Ljava/util/List;", "readFieldOrNull", "instance", "fieldType", "Ljava/lang/Class;", "fieldName", "(Ljava/lang/Object;Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Object;", "threadFactory", "Ljava/util/concurrent/ThreadFactory;", "daemon", "threadName", "block", "Lkotlin/Function0;", "asFactory", "Lokhttp3/EventListener$Factory;", "Lokhttp3/EventListener;", "assertThreadDoesntHoldLock", "assertThreadHoldsLock", "canReuseConnectionFor", "Lokhttp3/HttpUrl;", "other", "closeQuietly", "Ljava/net/ServerSocket;", "Ljava/net/Socket;", "discard", "Lokio/Source;", "timeout", "timeUnit", "headersContentLength", "Lokhttp3/Response;", "isHealthy", "source", "Lokio/BufferedSource;", "notify", "notifyAll", "peerName", "readBomAsCharset", "Ljava/nio/charset/Charset;", "default", "skipAll", "toHeaderList", "Lokhttp3/internal/http2/Header;", "toHeaders", "toHexString", "toHostHeader", "includeDefaultPort", "toImmutableList", "toImmutableMap", "", "K", "V", "wait", "okhttp"})
public final class _UtilJvmKt {
    @JvmField
    @NotNull
    public static final Headers EMPTY_HEADERS = Headers.Companion.of(new String[0]);
    @JvmField
    @NotNull
    public static final ResponseBody EMPTY_RESPONSE = ResponseBody.Companion.create$default(ResponseBody.Companion, _UtilCommonKt.EMPTY_BYTE_ARRAY, null, 1, null);
    @JvmField
    @NotNull
    public static final RequestBody EMPTY_REQUEST = RequestBody.Companion.create$default(RequestBody.Companion, _UtilCommonKt.EMPTY_BYTE_ARRAY, null, 0, 0, 7, null);
    @JvmField
    @NotNull
    public static final TimeZone UTC;
    @JvmField
    public static final boolean assertionsEnabled;
    @JvmField
    @NotNull
    public static final String okHttpName;

    public static final void checkOffsetAndCount(long arrayLength, long offset, long count) {
        if ((offset | count) < 0L || offset > arrayLength || arrayLength - offset < count) {
            throw new ArrayIndexOutOfBoundsException("length=" + arrayLength + ", offset=" + offset + ", count=" + offset);
        }
    }

    @NotNull
    public static final ThreadFactory threadFactory(@NotNull String name2, boolean daemon) {
        Intrinsics.checkNotNullParameter(name2, "name");
        return arg_0 -> _UtilJvmKt.threadFactory$lambda-1(name2, daemon, arg_0);
    }

    @NotNull
    public static final String toHostHeader(@NotNull HttpUrl $this$toHostHeader, boolean includeDefaultPort) {
        Intrinsics.checkNotNullParameter($this$toHostHeader, "<this>");
        String host = StringsKt.contains$default((CharSequence)$this$toHostHeader.host(), ":", false, 2, null) ? '[' + $this$toHostHeader.host() + ']' : $this$toHostHeader.host();
        return includeDefaultPort || $this$toHostHeader.port() != HttpUrl.Companion.defaultPort($this$toHostHeader.scheme()) ? host + ':' + $this$toHostHeader.port() : host;
    }

    public static /* synthetic */ String toHostHeader$default(HttpUrl httpUrl, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return _UtilJvmKt.toHostHeader(httpUrl, bl);
    }

    @NotNull
    public static final String format(@NotNull String format, Object ... args2) {
        Intrinsics.checkNotNullParameter(format, "format");
        Intrinsics.checkNotNullParameter(args2, "args");
        Locale locale = Locale.US;
        Object[] objectArray = Arrays.copyOf(args2, args2.length);
        String string = String.format(locale, format, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string, "format(locale, format, *args)");
        return string;
    }

    @NotNull
    public static final Charset readBomAsCharset(@NotNull BufferedSource $this$readBomAsCharset, @NotNull Charset charset) throws IOException {
        Charset charset2;
        Intrinsics.checkNotNullParameter($this$readBomAsCharset, "<this>");
        Intrinsics.checkNotNullParameter(charset, "default");
        switch ($this$readBomAsCharset.select(_UtilCommonKt.getUNICODE_BOMS())) {
            case 0: {
                charset2 = Charsets.UTF_8;
                break;
            }
            case 1: {
                charset2 = Charsets.UTF_16BE;
                break;
            }
            case 2: {
                charset2 = Charsets.UTF_16LE;
                break;
            }
            case 3: {
                charset2 = Charsets.INSTANCE.UTF32_BE();
                break;
            }
            case 4: {
                charset2 = Charsets.INSTANCE.UTF32_LE();
                break;
            }
            case -1: {
                charset2 = charset;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return charset2;
    }

    public static final int checkDuration(@NotNull String name2, long duration, @Nullable TimeUnit unit) {
        Intrinsics.checkNotNullParameter(name2, "name");
        if (!(duration >= 0L)) {
            boolean $i$a$-check-_UtilJvmKt$checkDuration$32 = false;
            String $i$a$-check-_UtilJvmKt$checkDuration$32 = Intrinsics.stringPlus(name2, " < 0");
            throw new IllegalStateException($i$a$-check-_UtilJvmKt$checkDuration$32.toString());
        }
        if (!(unit != null)) {
            boolean bl = false;
            String string = "unit == null";
            throw new IllegalStateException(string.toString());
        }
        long millis = unit.toMillis(duration);
        if (!(millis <= Integer.MAX_VALUE)) {
            boolean $i$a$-require-_UtilJvmKt$checkDuration$52 = false;
            String $i$a$-require-_UtilJvmKt$checkDuration$52 = Intrinsics.stringPlus(name2, " too large.");
            throw new IllegalArgumentException($i$a$-require-_UtilJvmKt$checkDuration$52.toString());
        }
        if (!(millis != 0L || duration <= 0L)) {
            boolean bl = false;
            String string = Intrinsics.stringPlus(name2, " too small.");
            throw new IllegalArgumentException(string.toString());
        }
        return (int)millis;
    }

    @NotNull
    public static final Headers toHeaders(@NotNull List<Header> $this$toHeaders) {
        Intrinsics.checkNotNullParameter($this$toHeaders, "<this>");
        Headers.Builder builder = new Headers.Builder();
        for (Header header : $this$toHeaders) {
            ByteString name2 = header.component1();
            ByteString value = header.component2();
            builder.addLenient$okhttp(name2.utf8(), value.utf8());
        }
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Header> toHeaderList(@NotNull Headers $this$toHeaderList) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toHeaderList, "<this>");
        Iterable $this$map$iv = RangesKt.until(0, $this$toHeaderList.size());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Header($this$toHeaderList.name((int)it), $this$toHeaderList.value((int)it)));
        }
        return (List)destination$iv$iv;
    }

    public static final boolean canReuseConnectionFor(@NotNull HttpUrl $this$canReuseConnectionFor, @NotNull HttpUrl other) {
        Intrinsics.checkNotNullParameter($this$canReuseConnectionFor, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        return Intrinsics.areEqual($this$canReuseConnectionFor.host(), other.host()) && $this$canReuseConnectionFor.port() == other.port() && Intrinsics.areEqual($this$canReuseConnectionFor.scheme(), other.scheme());
    }

    @NotNull
    public static final EventListener.Factory asFactory(@NotNull EventListener $this$asFactory) {
        Intrinsics.checkNotNullParameter($this$asFactory, "<this>");
        return arg_0 -> _UtilJvmKt.asFactory$lambda-7($this$asFactory, arg_0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean skipAll(@NotNull Source $this$skipAll, int duration, @NotNull TimeUnit timeUnit) throws IOException {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$skipAll, "<this>");
        Intrinsics.checkNotNullParameter((Object)timeUnit, "timeUnit");
        long nowNs = System.nanoTime();
        long originalDurationNs = $this$skipAll.timeout().hasDeadline() ? $this$skipAll.timeout().deadlineNanoTime() - nowNs : Long.MAX_VALUE;
        long l = timeUnit.toNanos(duration);
        $this$skipAll.timeout().deadlineNanoTime(nowNs + Math.min(originalDurationNs, l));
        try {
            Buffer skipBuffer = new Buffer();
            while ($this$skipAll.read(skipBuffer, 8192L) != -1L) {
                skipBuffer.clear();
            }
            bl = true;
        }
        catch (InterruptedIOException _) {
            bl = false;
        }
        finally {
            if (originalDurationNs == Long.MAX_VALUE) {
                $this$skipAll.timeout().clearDeadline();
            } else {
                $this$skipAll.timeout().deadlineNanoTime(nowNs + originalDurationNs);
            }
        }
        return bl;
    }

    public static final boolean discard(@NotNull Source $this$discard, int timeout2, @NotNull TimeUnit timeUnit) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$discard, "<this>");
        Intrinsics.checkNotNullParameter((Object)timeUnit, "timeUnit");
        try {
            bl = _UtilJvmKt.skipAll($this$discard, timeout2, timeUnit);
        }
        catch (IOException _) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final String peerName(@NotNull Socket $this$peerName) {
        String string;
        Intrinsics.checkNotNullParameter($this$peerName, "<this>");
        SocketAddress address = $this$peerName.getRemoteSocketAddress();
        if (address instanceof InetSocketAddress) {
            String string2 = ((InetSocketAddress)address).getHostName();
            Intrinsics.checkNotNullExpressionValue(string2, "address.hostName");
            string = string2;
        } else {
            string = address.toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isHealthy(@NotNull Socket $this$isHealthy, @NotNull BufferedSource source2) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isHealthy, "<this>");
        Intrinsics.checkNotNullParameter(source2, "source");
        try {
            boolean bl2;
            int readTimeout = $this$isHealthy.getSoTimeout();
            try {
                $this$isHealthy.setSoTimeout(1);
                bl2 = !source2.exhausted();
            }
            finally {
                $this$isHealthy.setSoTimeout(readTimeout);
            }
            bl = bl2;
        }
        catch (SocketTimeoutException _) {
            bl = true;
        }
        catch (IOException _) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void threadName(@NotNull String name2, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$threadName = false;
        Thread currentThread = Thread.currentThread();
        String oldName = currentThread.getName();
        currentThread.setName(name2);
        try {
            block.invoke();
        }
        finally {
            InlineMarker.finallyStart(1);
            currentThread.setName(oldName);
            InlineMarker.finallyEnd(1);
        }
    }

    public static final long headersContentLength(@NotNull Response $this$headersContentLength) {
        long l;
        Intrinsics.checkNotNullParameter($this$headersContentLength, "<this>");
        String string = $this$headersContentLength.headers().get("Content-Length");
        return string == null ? -1L : (l = _UtilCommonKt.toLongOrDefault(string, -1L));
    }

    @NotNull
    public static final <T> List<T> toImmutableList(@NotNull List<? extends T> $this$toImmutableList) {
        Intrinsics.checkNotNullParameter($this$toImmutableList, "<this>");
        List list = Collections.unmodifiableList(CollectionsKt.toMutableList((Collection)$this$toImmutableList));
        Intrinsics.checkNotNullExpressionValue(list, "unmodifiableList(toMutableList())");
        return list;
    }

    @SafeVarargs
    @NotNull
    public static final <T> List<T> immutableListOf(T ... elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        Object[] objectArray = (Object[])elements.clone();
        List<Object> list = Collections.unmodifiableList(CollectionsKt.listOf(Arrays.copyOf(objectArray, objectArray.length)));
        Intrinsics.checkNotNullExpressionValue(list, "unmodifiableList(listOf(*elements.clone()))");
        return list;
    }

    @NotNull
    public static final <K, V> Map<K, V> toImmutableMap(@NotNull Map<K, ? extends V> $this$toImmutableMap) {
        Map map;
        Intrinsics.checkNotNullParameter($this$toImmutableMap, "<this>");
        if ($this$toImmutableMap.isEmpty()) {
            map = MapsKt.emptyMap();
        } else {
            Map map2 = Collections.unmodifiableMap((Map)new LinkedHashMap<K, V>($this$toImmutableMap));
            Intrinsics.checkNotNullExpressionValue(map2, "{\n    Collections.unmodi\u2026(LinkedHashMap(this))\n  }");
            map = map2;
        }
        return map;
    }

    public static final void closeQuietly(@NotNull Socket $this$closeQuietly) {
        Intrinsics.checkNotNullParameter($this$closeQuietly, "<this>");
        try {
            $this$closeQuietly.close();
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (RuntimeException rethrown) {
            if (Intrinsics.areEqual(rethrown.getMessage(), "bio == null")) {
                return;
            }
            throw rethrown;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void closeQuietly(@NotNull ServerSocket $this$closeQuietly) {
        Intrinsics.checkNotNullParameter($this$closeQuietly, "<this>");
        try {
            $this$closeQuietly.close();
        }
        catch (RuntimeException rethrown) {
            throw rethrown;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public static final String toHexString(long $this$toHexString) {
        String string = Long.toHexString($this$toHexString);
        Intrinsics.checkNotNullExpressionValue(string, "toHexString(this)");
        return string;
    }

    @NotNull
    public static final String toHexString(int $this$toHexString) {
        String string = Integer.toHexString($this$toHexString);
        Intrinsics.checkNotNullExpressionValue(string, "toHexString(this)");
        return string;
    }

    public static final void wait(@NotNull Object $this$wait) {
        Intrinsics.checkNotNullParameter($this$wait, "<this>");
        boolean $i$f$wait = false;
        $this$wait.wait();
    }

    public static final void notify(@NotNull Object $this$notify) {
        Intrinsics.checkNotNullParameter($this$notify, "<this>");
        boolean $i$f$notify = false;
        $this$notify.notify();
    }

    public static final void notifyAll(@NotNull Object $this$notifyAll) {
        Intrinsics.checkNotNullParameter($this$notifyAll, "<this>");
        boolean $i$f$notifyAll = false;
        $this$notifyAll.notifyAll();
    }

    @Nullable
    public static final <T> T readFieldOrNull(@NotNull Object instance, @NotNull Class<T> fieldType, @NotNull String fieldName) {
        Object delegate;
        Intrinsics.checkNotNullParameter(instance, "instance");
        Intrinsics.checkNotNullParameter(fieldType, "fieldType");
        Intrinsics.checkNotNullParameter(fieldName, "fieldName");
        AnnotatedElement c = instance.getClass();
        while (!Intrinsics.areEqual(c, Object.class)) {
            AnnotatedElement field2;
            try {
                field2 = c.getDeclaredField(fieldName);
                ((Field)field2).setAccessible(true);
                Object value = ((Field)field2).get(instance);
                return !fieldType.isInstance(value) ? null : (T)fieldType.cast(value);
            }
            catch (NoSuchFieldException field2) {
                field2 = c.getSuperclass();
                Intrinsics.checkNotNullExpressionValue(field2, "c.superclass");
                c = field2;
            }
        }
        if (!Intrinsics.areEqual(fieldName, "delegate") && (delegate = _UtilJvmKt.readFieldOrNull(instance, Object.class, "delegate")) != null) {
            return _UtilJvmKt.readFieldOrNull(delegate, fieldType, fieldName);
        }
        return null;
    }

    public static final void assertThreadHoldsLock(@NotNull Object $this$assertThreadHoldsLock) {
        Intrinsics.checkNotNullParameter($this$assertThreadHoldsLock, "<this>");
        boolean $i$f$assertThreadHoldsLock = false;
        if (assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock));
        }
    }

    public static final void assertThreadDoesntHoldLock(@NotNull Object $this$assertThreadDoesntHoldLock) {
        Intrinsics.checkNotNullParameter($this$assertThreadDoesntHoldLock, "<this>");
        boolean $i$f$assertThreadDoesntHoldLock = false;
        if (assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock));
        }
    }

    private static final Thread threadFactory$lambda-1(String $name, boolean $daemon, Runnable runnable2) {
        Thread thread2;
        Intrinsics.checkNotNullParameter($name, "$name");
        Thread $this$threadFactory_u24lambda_u2d1_u24lambda_u2d0 = thread2 = new Thread(runnable2, $name);
        boolean bl = false;
        $this$threadFactory_u24lambda_u2d1_u24lambda_u2d0.setDaemon($daemon);
        return thread2;
    }

    private static final EventListener asFactory$lambda-7(EventListener $this_asFactory, Call it) {
        Intrinsics.checkNotNullParameter($this_asFactory, "$this_asFactory");
        Intrinsics.checkNotNullParameter(it, "it");
        return $this_asFactory;
    }

    static {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Intrinsics.checkNotNull(timeZone);
        UTC = timeZone;
        assertionsEnabled = OkHttpClient.class.desiredAssertionStatus();
        String string = OkHttpClient.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "OkHttpClient::class.java.name");
        okHttpName = StringsKt.removeSuffix(StringsKt.removePrefix(string, (CharSequence)"okhttp3."), (CharSequence)"Client");
    }
}

