/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RoutePlanner;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lokhttp3/internal/connection/ExchangeFinder;", "", "routePlanner", "Lokhttp3/internal/connection/RoutePlanner;", "(Lokhttp3/internal/connection/RoutePlanner;)V", "find", "Lokhttp3/internal/connection/RealConnection;", "okhttp"})
public final class ExchangeFinder {
    @NotNull
    private final RoutePlanner routePlanner;

    public ExchangeFinder(@NotNull RoutePlanner routePlanner) {
        Intrinsics.checkNotNullParameter(routePlanner, "routePlanner");
        this.routePlanner = routePlanner;
    }

    @NotNull
    public final RealConnection find() {
        IOException firstException = null;
        while (true) {
            if (this.routePlanner.isCanceled()) {
                throw new IOException("Canceled");
            }
            try {
                RoutePlanner.Plan plan = this.routePlanner.plan();
                if (!plan.isConnected()) {
                    plan.connect();
                }
                return plan.handleSuccess();
            }
            catch (IOException e) {
                this.routePlanner.trackFailure(e);
                if (firstException == null) {
                    firstException = e;
                    continue;
                }
                ExceptionsKt.addSuppressed(firstException, e);
                if (this.routePlanner.hasMoreRoutes()) continue;
                throw firstException;
            }
            break;
        }
    }
}

