/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.net.Socket;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Address;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Route;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.connection.RoutePlanner;
import okhttp3.internal.connection.RouteSelector;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.StreamResetException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u000234B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001d\u001a\u00020\u0012H\u0016J\b\u0010\u001e\u001a\u00020\u0012H\u0016J\b\u0010\u001f\u001a\u00020\u0012H\u0016J\b\u0010 \u001a\u00020!H\u0016J\f\u0010\"\u001a\u00060#R\u00020\u0000H\u0002J\n\u0010$\u001a\u0004\u0018\u00010%H\u0002J(\u0010&\u001a\u0004\u0018\u00010%2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(2\u0010\b\u0002\u0010)\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010*H\u0002J\n\u0010+\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lokhttp3/internal/connection/RealRoutePlanner;", "Lokhttp3/internal/connection/RoutePlanner;", "client", "Lokhttp3/OkHttpClient;", "address", "Lokhttp3/Address;", "call", "Lokhttp3/internal/connection/RealCall;", "chain", "Lokhttp3/internal/http/RealInterceptorChain;", "(Lokhttp3/OkHttpClient;Lokhttp3/Address;Lokhttp3/internal/connection/RealCall;Lokhttp3/internal/http/RealInterceptorChain;)V", "getAddress", "()Lokhttp3/Address;", "connectionPool", "Lokhttp3/internal/connection/RealConnectionPool;", "connectionShutdownCount", "", "doExtensiveHealthChecks", "", "eventListener", "Lokhttp3/EventListener;", "nextRouteToTry", "Lokhttp3/Route;", "otherFailureCount", "refusedStreamCount", "routeSelection", "Lokhttp3/internal/connection/RouteSelector$Selection;", "routeSelector", "Lokhttp3/internal/connection/RouteSelector;", "hasFailure", "hasMoreRoutes", "isCanceled", "plan", "Lokhttp3/internal/connection/RoutePlanner$Plan;", "planConnect", "Lokhttp3/internal/connection/RealRoutePlanner$RealConnectPlan;", "planReuseCallConnection", "Lokhttp3/internal/connection/RealRoutePlanner$ReusePlan;", "planReusePooledConnection", "connectionToReplace", "Lokhttp3/internal/connection/RealConnection;", "routes", "", "retryRoute", "sameHostAndPort", "url", "Lokhttp3/HttpUrl;", "trackFailure", "", "e", "Ljava/io/IOException;", "RealConnectPlan", "ReusePlan", "okhttp"})
public final class RealRoutePlanner
implements RoutePlanner {
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final Address address;
    @NotNull
    private final RealCall call;
    @NotNull
    private final RealInterceptorChain chain;
    @NotNull
    private final RealConnectionPool connectionPool;
    @NotNull
    private final EventListener eventListener;
    private final boolean doExtensiveHealthChecks;
    @Nullable
    private RouteSelector.Selection routeSelection;
    @Nullable
    private RouteSelector routeSelector;
    private int refusedStreamCount;
    private int connectionShutdownCount;
    private int otherFailureCount;
    @Nullable
    private Route nextRouteToTry;

    public RealRoutePlanner(@NotNull OkHttpClient client, @NotNull Address address, @NotNull RealCall call, @NotNull RealInterceptorChain chain) {
        Intrinsics.checkNotNullParameter(client, "client");
        Intrinsics.checkNotNullParameter(address, "address");
        Intrinsics.checkNotNullParameter(call, "call");
        Intrinsics.checkNotNullParameter(chain, "chain");
        this.client = client;
        this.address = address;
        this.call = call;
        this.chain = chain;
        this.connectionPool = this.client.connectionPool().getDelegate$okhttp();
        this.eventListener = this.call.getEventListener$okhttp();
        this.doExtensiveHealthChecks = !Intrinsics.areEqual(this.chain.getRequest$okhttp().method(), "GET");
    }

    @Override
    @NotNull
    public Address getAddress() {
        return this.address;
    }

    @Override
    public boolean isCanceled() {
        return this.call.isCanceled();
    }

    @Override
    @NotNull
    public RoutePlanner.Plan plan() throws IOException {
        ReusePlan reuseCallConnection = this.planReuseCallConnection();
        if (reuseCallConnection != null) {
            return reuseCallConnection;
        }
        this.refusedStreamCount = 0;
        this.connectionShutdownCount = 0;
        this.otherFailureCount = 0;
        ReusePlan pooled1 = RealRoutePlanner.planReusePooledConnection$default(this, null, null, 3, null);
        if (pooled1 != null) {
            return pooled1;
        }
        RealConnectPlan connect2 = this.planConnect();
        ReusePlan pooled2 = this.planReusePooledConnection(connect2.getConnection(), connect2.getRoutes());
        if (pooled2 != null) {
            return pooled2;
        }
        return connect2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ReusePlan planReuseCallConnection() {
        Socket socket;
        RealConnection realConnection = this.call.getConnection();
        if (realConnection == null) {
            return null;
        }
        RealConnection candidate = realConnection;
        boolean healthy = candidate.isHealthy(this.doExtensiveHealthChecks);
        synchronized (candidate) {
            Socket socket2;
            boolean bl = false;
            if (!healthy) {
                candidate.setNoNewExchanges(true);
                socket2 = this.call.releaseConnectionNoEvents$okhttp();
            } else {
                socket2 = candidate.getNoNewExchanges() || !this.sameHostAndPort(candidate.route().address().url()) ? this.call.releaseConnectionNoEvents$okhttp() : null;
            }
            socket = socket2;
        }
        Socket toClose = socket;
        if (this.call.getConnection() != null) {
            if (!(toClose == null)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            return new ReusePlan(candidate);
        }
        Socket socket3 = toClose;
        if (socket3 != null) {
            _UtilJvmKt.closeQuietly(socket3);
        }
        this.eventListener.connectionReleased(this.call, candidate);
        return null;
    }

    private final RealConnectPlan planConnect() throws IOException {
        RouteSelector.Selection newRouteSelection;
        Route localNextRouteToTry = this.nextRouteToTry;
        if (localNextRouteToTry != null) {
            this.nextRouteToTry = null;
            return new RealConnectPlan(localNextRouteToTry, null, 2, null);
        }
        RouteSelector.Selection existingRouteSelection = this.routeSelection;
        if (existingRouteSelection != null && existingRouteSelection.hasNext()) {
            return new RealConnectPlan(existingRouteSelection.next(), null, 2, null);
        }
        RouteSelector newRouteSelector = this.routeSelector;
        if (newRouteSelector == null) {
            this.routeSelector = newRouteSelector = new RouteSelector(this.getAddress(), this.call.getClient().getRouteDatabase$okhttp(), this.call, this.client.fastFallback(), this.eventListener);
        }
        if (!newRouteSelector.hasNext()) {
            throw new IOException("exhausted all routes");
        }
        this.routeSelection = newRouteSelection = newRouteSelector.next();
        if (this.call.isCanceled()) {
            throw new IOException("Canceled");
        }
        return new RealConnectPlan(newRouteSelection.next(), newRouteSelection.getRoutes());
    }

    private final ReusePlan planReusePooledConnection(RealConnection connectionToReplace, List<Route> routes) {
        RealConnection realConnection = this.connectionPool.callAcquirePooledConnection(this.doExtensiveHealthChecks, this.getAddress(), this.call, routes, connectionToReplace != null && !connectionToReplace.isNew$okhttp());
        if (realConnection == null) {
            return null;
        }
        RealConnection result = realConnection;
        if (connectionToReplace != null) {
            this.nextRouteToTry = connectionToReplace.route();
            if (!connectionToReplace.isNew$okhttp()) {
                _UtilJvmKt.closeQuietly(connectionToReplace.socket());
            }
        }
        this.eventListener.connectionAcquired(this.call, result);
        return new ReusePlan(result);
    }

    static /* synthetic */ ReusePlan planReusePooledConnection$default(RealRoutePlanner realRoutePlanner, RealConnection realConnection, List list, int n, Object object) {
        if ((n & 1) != 0) {
            realConnection = null;
        }
        if ((n & 2) != 0) {
            list = null;
        }
        return realRoutePlanner.planReusePooledConnection(realConnection, list);
    }

    @Override
    public void trackFailure(@NotNull IOException e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (e instanceof StreamResetException && ((StreamResetException)e).errorCode == ErrorCode.REFUSED_STREAM) {
            int n = this.refusedStreamCount;
            this.refusedStreamCount = n + 1;
        } else if (e instanceof ConnectionShutdownException) {
            int n = this.connectionShutdownCount;
            this.connectionShutdownCount = n + 1;
        } else {
            int n = this.otherFailureCount;
            this.otherFailureCount = n + 1;
        }
    }

    @Override
    public boolean hasFailure() {
        return this.refusedStreamCount > 0 || this.connectionShutdownCount > 0 || this.otherFailureCount > 0;
    }

    @Override
    public boolean hasMoreRoutes() {
        if (this.nextRouteToTry != null) {
            return true;
        }
        Route retryRoute = this.retryRoute();
        if (retryRoute != null) {
            this.nextRouteToTry = retryRoute;
            return true;
        }
        RouteSelector.Selection selection = this.routeSelection;
        if (selection == null ? false : selection.hasNext()) {
            return true;
        }
        RouteSelector routeSelector = this.routeSelector;
        if (routeSelector == null) {
            return true;
        }
        RouteSelector localRouteSelector = routeSelector;
        return localRouteSelector.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Route retryRoute() {
        if (this.refusedStreamCount > 1 || this.connectionShutdownCount > 1 || this.otherFailureCount > 0) {
            return null;
        }
        RealConnection realConnection = this.call.getConnection();
        if (realConnection == null) {
            return null;
        }
        RealConnection connection = realConnection;
        synchronized (connection) {
            block10: {
                block9: {
                    block8: {
                        boolean bl = false;
                        if (connection.getRouteFailureCount$okhttp() == 0) break block8;
                        Route route = null;
                        return route;
                    }
                    if (connection.getNoNewExchanges()) break block9;
                    Route route = null;
                    return route;
                }
                if (_UtilJvmKt.canReuseConnectionFor(connection.route().address().url(), this.getAddress().url())) break block10;
                Route route = null;
                return route;
            }
            Route route = connection.route();
            return route;
        }
    }

    @Override
    public boolean sameHostAndPort(@NotNull HttpUrl url) {
        Intrinsics.checkNotNullParameter(url, "url");
        HttpUrl routeUrl = this.getAddress().url();
        return url.port() == routeUrl.port() && Intrinsics.areEqual(url.host(), routeUrl.host());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\t\u00a8\u0006\u000e"}, d2={"Lokhttp3/internal/connection/RealRoutePlanner$ReusePlan;", "Lokhttp3/internal/connection/RoutePlanner$Plan;", "connection", "Lokhttp3/internal/connection/RealConnection;", "(Lokhttp3/internal/connection/RealConnection;)V", "getConnection", "()Lokhttp3/internal/connection/RealConnection;", "isConnected", "", "()Z", "cancel", "", "connect", "handleSuccess", "okhttp"})
    public static final class ReusePlan
    implements RoutePlanner.Plan {
        @NotNull
        private final RealConnection connection;
        private final boolean isConnected;

        public ReusePlan(@NotNull RealConnection connection) {
            Intrinsics.checkNotNullParameter(connection, "connection");
            this.connection = connection;
            this.isConnected = true;
        }

        @NotNull
        public final RealConnection getConnection() {
            return this.connection;
        }

        @Override
        public boolean isConnected() {
            return this.isConnected;
        }

        @Override
        public void connect() {
            throw new IllegalStateException("already connected".toString());
        }

        @Override
        @NotNull
        public RealConnection handleSuccess() {
            return this.connection;
        }

        @Override
        public void cancel() {
            throw new IllegalStateException("unexpected cancel of reused connection".toString());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0080\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\bH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lokhttp3/internal/connection/RealRoutePlanner$RealConnectPlan;", "Lokhttp3/internal/connection/RoutePlanner$Plan;", "route", "Lokhttp3/Route;", "routes", "", "(Lokhttp3/internal/connection/RealRoutePlanner;Lokhttp3/Route;Ljava/util/List;)V", "connection", "Lokhttp3/internal/connection/RealConnection;", "getConnection", "()Lokhttp3/internal/connection/RealConnection;", "isConnected", "", "()Z", "getRoutes", "()Ljava/util/List;", "cancel", "", "connect", "handleSuccess", "okhttp"})
    public final class RealConnectPlan
    implements RoutePlanner.Plan {
        @Nullable
        private final List<Route> routes;
        @NotNull
        private final RealConnection connection;

        public RealConnectPlan(@Nullable Route route, List<Route> routes) {
            Intrinsics.checkNotNullParameter(RealRoutePlanner.this, "this$0");
            Intrinsics.checkNotNullParameter(route, "route");
            this.routes = routes;
            this.connection = new RealConnection(RealRoutePlanner.this.client.getTaskRunner$okhttp(), RealRoutePlanner.this.connectionPool, route);
        }

        public /* synthetic */ RealConnectPlan(Route route, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                list = null;
            }
            this(route, list);
        }

        @Nullable
        public final List<Route> getRoutes() {
            return this.routes;
        }

        @NotNull
        public final RealConnection getConnection() {
            return this.connection;
        }

        @Override
        public boolean isConnected() {
            return !this.connection.isNew$okhttp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connect() throws IOException {
            ((Collection)RealRoutePlanner.this.call.getConnectionsToCancel$okhttp()).add(this.connection);
            try {
                this.connection.connect(RealRoutePlanner.this.chain.getConnectTimeoutMillis$okhttp(), RealRoutePlanner.this.chain.getReadTimeoutMillis$okhttp(), RealRoutePlanner.this.chain.getWriteTimeoutMillis$okhttp(), RealRoutePlanner.this.client.pingIntervalMillis(), RealRoutePlanner.this.client.retryOnConnectionFailure(), RealRoutePlanner.this.call, RealRoutePlanner.this.eventListener);
            }
            finally {
                ((Collection)RealRoutePlanner.this.call.getConnectionsToCancel$okhttp()).remove(this.connection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public RealConnection handleSuccess() {
            RealRoutePlanner.this.call.getClient().getRouteDatabase$okhttp().connected(this.connection.route());
            ReusePlan pooled3 = RealRoutePlanner.this.planReusePooledConnection(this.connection, this.routes);
            if (pooled3 != null) {
                return pooled3.getConnection();
            }
            RealConnection realConnection = this.connection;
            RealRoutePlanner realRoutePlanner = RealRoutePlanner.this;
            synchronized (realConnection) {
                boolean bl = false;
                realRoutePlanner.connectionPool.put(this.getConnection());
                realRoutePlanner.call.acquireConnectionNoEvents(this.getConnection());
                Unit unit = Unit.INSTANCE;
            }
            RealRoutePlanner.this.eventListener.connectionAcquired(RealRoutePlanner.this.call, this.connection);
            return this.connection;
        }

        @Override
        public void cancel() {
            this.connection.cancel();
        }
    }
}

