/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.internal.http.HttpMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u001a\u0010\u0003\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\t\u001a\u0012\u0010\u0007\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\n\u001a\u00020\b\u001a\u0014\u0010\u000b\u001a\u00020\u0004*\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r\u001a\n\u0010\u000e\u001a\u00020\u0004*\u00020\u0004\u001a\n\u0010\u000f\u001a\u00020\u0004*\u00020\u0004\u001a\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u0001*\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u001a\u0010\u0010\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012*\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u0012\u0010\u0011\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u001c\u0010\u0015\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00012\b\u0010\f\u001a\u0004\u0018\u00010\r\u001a\n\u0010\u0017\u001a\u00020\u0004*\u00020\t\u001a\u0012\u0010\u0018\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u0019\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u001a\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u001b\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001\u00a8\u0006\u001c"}, d2={"canonicalUrl", "", "url", "commonAddHeader", "Lokhttp3/Request$Builder;", "name", "value", "commonCacheControl", "Lokhttp3/CacheControl;", "Lokhttp3/Request;", "cacheControl", "commonDelete", "body", "Lokhttp3/RequestBody;", "commonGet", "commonHead", "commonHeader", "commonHeaders", "", "headers", "Lokhttp3/Headers;", "commonMethod", "method", "commonNewBuilder", "commonPatch", "commonPost", "commonPut", "commonRemoveHeader", "okhttp"})
public final class _RequestCommonKt {
    @Nullable
    public static final String commonHeader(@NotNull Request $this$commonHeader, @NotNull String name) {
        Intrinsics.checkNotNullParameter($this$commonHeader, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        return $this$commonHeader.headers().get(name);
    }

    @NotNull
    public static final List<String> commonHeaders(@NotNull Request $this$commonHeaders, @NotNull String name) {
        Intrinsics.checkNotNullParameter($this$commonHeaders, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        return $this$commonHeaders.headers().values(name);
    }

    @NotNull
    public static final Request.Builder commonNewBuilder(@NotNull Request $this$commonNewBuilder) {
        Intrinsics.checkNotNullParameter($this$commonNewBuilder, "<this>");
        return new Request.Builder($this$commonNewBuilder);
    }

    @NotNull
    public static final CacheControl commonCacheControl(@NotNull Request $this$commonCacheControl) {
        Intrinsics.checkNotNullParameter($this$commonCacheControl, "<this>");
        CacheControl result = $this$commonCacheControl.getLazyCacheControl$okhttp();
        if (result == null) {
            result = CacheControl.Companion.parse($this$commonCacheControl.headers());
            $this$commonCacheControl.setLazyCacheControl$okhttp(result);
        }
        return result;
    }

    @NotNull
    public static final String canonicalUrl(@NotNull String url) {
        String string;
        Intrinsics.checkNotNullParameter(url, "url");
        if (StringsKt.startsWith(url, "ws:", true)) {
            String string2 = url.substring(3);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
            string = Intrinsics.stringPlus("http:", string2);
        } else if (StringsKt.startsWith(url, "wss:", true)) {
            String string3 = url.substring(4);
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).substring(startIndex)");
            string = Intrinsics.stringPlus("https:", string3);
        } else {
            string = url;
        }
        return string;
    }

    @NotNull
    public static final Request.Builder commonHeader(@NotNull Request.Builder $this$commonHeader, @NotNull String name, @NotNull String value) {
        Request.Builder builder;
        Intrinsics.checkNotNullParameter($this$commonHeader, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value, "value");
        Request.Builder $this$commonHeader_u24lambda_u2d0 = builder = $this$commonHeader;
        boolean bl = false;
        $this$commonHeader_u24lambda_u2d0.getHeaders$okhttp().set(name, value);
        return builder;
    }

    @NotNull
    public static final Request.Builder commonAddHeader(@NotNull Request.Builder $this$commonAddHeader, @NotNull String name, @NotNull String value) {
        Request.Builder builder;
        Intrinsics.checkNotNullParameter($this$commonAddHeader, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value, "value");
        Request.Builder $this$commonAddHeader_u24lambda_u2d1 = builder = $this$commonAddHeader;
        boolean bl = false;
        $this$commonAddHeader_u24lambda_u2d1.getHeaders$okhttp().add(name, value);
        return builder;
    }

    @NotNull
    public static final Request.Builder commonRemoveHeader(@NotNull Request.Builder $this$commonRemoveHeader, @NotNull String name) {
        Request.Builder builder;
        Intrinsics.checkNotNullParameter($this$commonRemoveHeader, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        Request.Builder $this$commonRemoveHeader_u24lambda_u2d2 = builder = $this$commonRemoveHeader;
        boolean bl = false;
        $this$commonRemoveHeader_u24lambda_u2d2.getHeaders$okhttp().removeAll(name);
        return builder;
    }

    @NotNull
    public static final Request.Builder commonHeaders(@NotNull Request.Builder $this$commonHeaders, @NotNull Headers headers2) {
        Request.Builder builder;
        Intrinsics.checkNotNullParameter($this$commonHeaders, "<this>");
        Intrinsics.checkNotNullParameter(headers2, "headers");
        Request.Builder $this$commonHeaders_u24lambda_u2d3 = builder = $this$commonHeaders;
        boolean bl = false;
        $this$commonHeaders_u24lambda_u2d3.setHeaders$okhttp(headers2.newBuilder());
        return builder;
    }

    @NotNull
    public static final Request.Builder commonCacheControl(@NotNull Request.Builder $this$commonCacheControl, @NotNull CacheControl cacheControl) {
        Intrinsics.checkNotNullParameter($this$commonCacheControl, "<this>");
        Intrinsics.checkNotNullParameter(cacheControl, "cacheControl");
        String value = cacheControl.toString();
        return ((CharSequence)value).length() == 0 ? $this$commonCacheControl.removeHeader("Cache-Control") : $this$commonCacheControl.header("Cache-Control", value);
    }

    @NotNull
    public static final Request.Builder commonGet(@NotNull Request.Builder $this$commonGet) {
        Intrinsics.checkNotNullParameter($this$commonGet, "<this>");
        return $this$commonGet.method("GET", null);
    }

    @NotNull
    public static final Request.Builder commonHead(@NotNull Request.Builder $this$commonHead) {
        Intrinsics.checkNotNullParameter($this$commonHead, "<this>");
        return $this$commonHead.method("HEAD", null);
    }

    @NotNull
    public static final Request.Builder commonPost(@NotNull Request.Builder $this$commonPost, @NotNull RequestBody body) {
        Intrinsics.checkNotNullParameter($this$commonPost, "<this>");
        Intrinsics.checkNotNullParameter(body, "body");
        return $this$commonPost.method("POST", body);
    }

    @NotNull
    public static final Request.Builder commonDelete(@NotNull Request.Builder $this$commonDelete, @Nullable RequestBody body) {
        Intrinsics.checkNotNullParameter($this$commonDelete, "<this>");
        return $this$commonDelete.method("DELETE", body);
    }

    @NotNull
    public static final Request.Builder commonPut(@NotNull Request.Builder $this$commonPut, @NotNull RequestBody body) {
        Intrinsics.checkNotNullParameter($this$commonPut, "<this>");
        Intrinsics.checkNotNullParameter(body, "body");
        return $this$commonPut.method("PUT", body);
    }

    @NotNull
    public static final Request.Builder commonPatch(@NotNull Request.Builder $this$commonPatch, @NotNull RequestBody body) {
        Intrinsics.checkNotNullParameter($this$commonPatch, "<this>");
        Intrinsics.checkNotNullParameter(body, "body");
        return $this$commonPatch.method("PATCH", body);
    }

    @NotNull
    public static final Request.Builder commonMethod(@NotNull Request.Builder $this$commonMethod, @NotNull String method, @Nullable RequestBody body) {
        Request.Builder builder;
        Intrinsics.checkNotNullParameter($this$commonMethod, "<this>");
        Intrinsics.checkNotNullParameter(method, "method");
        Request.Builder $this$commonMethod_u24lambda_u2d7 = builder = $this$commonMethod;
        boolean bl = false;
        if (!(((CharSequence)method).length() > 0)) {
            boolean $i$a$-require-_RequestCommonKt$commonMethod$1$42 = false;
            String $i$a$-require-_RequestCommonKt$commonMethod$1$42 = "method.isEmpty() == true";
            throw new IllegalArgumentException($i$a$-require-_RequestCommonKt$commonMethod$1$42.toString());
        }
        if (body == null) {
            if (!(!HttpMethod.requiresRequestBody(method))) {
                boolean $i$a$-require-_RequestCommonKt$commonMethod$1$52 = false;
                String $i$a$-require-_RequestCommonKt$commonMethod$1$52 = "method " + method + " must have a request body.";
                throw new IllegalArgumentException($i$a$-require-_RequestCommonKt$commonMethod$1$52.toString());
            }
        } else if (!HttpMethod.permitsRequestBody(method)) {
            boolean bl2 = false;
            String string = "method " + method + " must not have a request body.";
            throw new IllegalArgumentException(string.toString());
        }
        $this$commonMethod_u24lambda_u2d7.setMethod$okhttp(method);
        $this$commonMethod_u24lambda_u2d7.setBody$okhttp(body);
        return builder;
    }
}

