/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0002\u001a\u001a\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0002\u001a\u001a\u0010\u0011\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010\u001a\u0014\u0010\u0014\u001a\u00020\u0012*\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a\u0014\u0010\u0017\u001a\u00020\u0012*\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002\u001a\n\u0010\u0019\u001a\u00020\f*\u00020\u0002\u001a\u0012\u0010\u001a\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c\u001a \u0010\u001d\u001a\u0004\u0018\u00010\u0010*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u001e\u001a\u0004\u0018\u00010\u0010H\u0007\u001a\u001a\u0010\u001d\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010\u001a\u0018\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100 *\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0012\u0010\u001f\u001a\u00020\u0012*\u00020\u00122\u0006\u0010!\u001a\u00020\"\u001a\u0012\u0010#\u001a\u00020\u0012*\u00020\u00122\u0006\u0010$\u001a\u00020\u0010\u001a\u0014\u0010%\u001a\u00020\u0012*\u00020\u00122\b\u0010&\u001a\u0004\u0018\u00010\u0002\u001a\n\u0010'\u001a\u00020\u0012*\u00020\u0002\u001a\u0012\u0010(\u001a\u00020\u0016*\u00020\u00022\u0006\u0010)\u001a\u00020*\u001a\u0014\u0010+\u001a\u00020\u0012*\u00020\u00122\b\u0010,\u001a\u0004\u0018\u00010\u0002\u001a\u0012\u0010-\u001a\u00020\u0012*\u00020\u00122\u0006\u0010.\u001a\u00020/\u001a\u0012\u00100\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0012\u00101\u001a\u00020\u0012*\u00020\u00122\u0006\u00102\u001a\u000203\u001a\n\u00104\u001a\u00020\u0010*\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u00065"}, d2={"commonCacheControl", "Lokhttp3/CacheControl;", "Lokhttp3/Response;", "getCommonCacheControl", "(Lokhttp3/Response;)Lokhttp3/CacheControl;", "commonIsRedirect", "", "getCommonIsRedirect", "(Lokhttp3/Response;)Z", "commonIsSuccessful", "getCommonIsSuccessful", "checkPriorResponse", "", "response", "checkSupportResponse", "name", "", "commonAddHeader", "Lokhttp3/Response$Builder;", "value", "commonBody", "body", "Lokhttp3/ResponseBody;", "commonCacheResponse", "cacheResponse", "commonClose", "commonCode", "code", "", "commonHeader", "defaultValue", "commonHeaders", "", "headers", "Lokhttp3/Headers;", "commonMessage", "message", "commonNetworkResponse", "networkResponse", "commonNewBuilder", "commonPeekBody", "byteCount", "", "commonPriorResponse", "priorResponse", "commonProtocol", "protocol", "Lokhttp3/Protocol;", "commonRemoveHeader", "commonRequest", "request", "Lokhttp3/Request;", "commonToString", "okhttp"})
public final class _ResponseCommonKt {
    public static final boolean getCommonIsSuccessful(@NotNull Response $this$commonIsSuccessful) {
        Intrinsics.checkNotNullParameter($this$commonIsSuccessful, "<this>");
        int n = $this$commonIsSuccessful.code();
        return 200 <= n ? n < 300 : false;
    }

    @NotNull
    public static final List<String> commonHeaders(@NotNull Response $this$commonHeaders, @NotNull String name) {
        Intrinsics.checkNotNullParameter($this$commonHeaders, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        return $this$commonHeaders.headers().values(name);
    }

    @JvmOverloads
    @Nullable
    public static final String commonHeader(@NotNull Response $this$commonHeader, @NotNull String name, @Nullable String defaultValue) {
        Intrinsics.checkNotNullParameter($this$commonHeader, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        String string = $this$commonHeader.headers().get(name);
        if (string == null) {
            string = defaultValue;
        }
        return string;
    }

    @NotNull
    public static final ResponseBody commonPeekBody(@NotNull Response $this$commonPeekBody, long byteCount) throws IOException {
        Intrinsics.checkNotNullParameter($this$commonPeekBody, "<this>");
        ResponseBody responseBody = $this$commonPeekBody.body();
        Intrinsics.checkNotNull(responseBody);
        BufferedSource peeked = responseBody.source().peek();
        Buffer buffer = new Buffer();
        peeked.request(byteCount);
        long l = peeked.getBuffer().size();
        buffer.write(peeked, Math.min(byteCount, l));
        return ResponseBody.Companion.create(buffer, $this$commonPeekBody.body().contentType(), buffer.size());
    }

    @NotNull
    public static final Response.Builder commonNewBuilder(@NotNull Response $this$commonNewBuilder) {
        Intrinsics.checkNotNullParameter($this$commonNewBuilder, "<this>");
        return new Response.Builder($this$commonNewBuilder);
    }

    public static final boolean getCommonIsRedirect(@NotNull Response $this$commonIsRedirect) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$commonIsRedirect, "<this>");
        switch ($this$commonIsRedirect.code()) {
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final CacheControl getCommonCacheControl(@NotNull Response $this$commonCacheControl) {
        Intrinsics.checkNotNullParameter($this$commonCacheControl, "<this>");
        CacheControl result = $this$commonCacheControl.getLazyCacheControl$okhttp();
        if (result == null) {
            result = CacheControl.Companion.parse($this$commonCacheControl.headers());
            $this$commonCacheControl.setLazyCacheControl$okhttp(result);
        }
        return result;
    }

    public static final void commonClose(@NotNull Response $this$commonClose) {
        Intrinsics.checkNotNullParameter($this$commonClose, "<this>");
        ResponseBody responseBody = $this$commonClose.body();
        if (responseBody == null) {
            boolean bl = false;
            String string = "response is not eligible for a body and must not be closed";
            throw new IllegalStateException(string.toString());
        }
        responseBody.close();
    }

    @NotNull
    public static final String commonToString(@NotNull Response $this$commonToString) {
        Intrinsics.checkNotNullParameter($this$commonToString, "<this>");
        return "Response{protocol=" + (Object)((Object)$this$commonToString.protocol()) + ", code=" + $this$commonToString.code() + ", message=" + $this$commonToString.message() + ", url=" + $this$commonToString.request().url() + '}';
    }

    @NotNull
    public static final Response.Builder commonRequest(@NotNull Response.Builder $this$commonRequest, @NotNull Request request) {
        Response.Builder builder;
        Intrinsics.checkNotNullParameter($this$commonRequest, "<this>");
        Intrinsics.checkNotNullParameter(request, "request");
        Response.Builder $this$commonRequest_u24lambda_u2d1 = builder = $this$commonRequest;
        boolean bl = false;
        $this$commonRequest_u24lambda_u2d1.setRequest$okhttp(request);
        return builder;
    }

    @NotNull
    public static final Response.Builder commonProtocol(@NotNull Response.Builder $this$commonProtocol, @NotNull Protocol protocol) {
        Response.Builder builder;
        Intrinsics.checkNotNullParameter($this$commonProtocol, "<this>");
        Intrinsics.checkNotNullParameter((Object)protocol, "protocol");
        Response.Builder $this$commonProtocol_u24lambda_u2d2 = builder = $this$commonProtocol;
        boolean bl = false;
        $this$commonProtocol_u24lambda_u2d2.setProtocol$okhttp(protocol);
        return builder;
    }

    @NotNull
    public static final Response.Builder commonCode(@NotNull Response.Builder $this$commonCode, int code) {
        Response.Builder builder;
        Intrinsics.checkNotNullParameter($this$commonCode, "<this>");
        Response.Builder $this$commonCode_u24lambda_u2d3 = builder = $this$commonCode;
        boolean bl = false;
        $this$commonCode_u24lambda_u2d3.setCode$okhttp(code);
        return builder;
    }

    @NotNull
    public static final Response.Builder commonMessage(@NotNull Response.Builder $this$commonMessage, @NotNull String message) {
        Response.Builder builder;
        Intrinsics.checkNotNullParameter($this$commonMessage, "<this>");
        Intrinsics.checkNotNullParameter(message, "message");
        Response.Builder $this$commonMessage_u24lambda_u2d4 = builder = $this$commonMessage;
        boolean bl = false;
        $this$commonMessage_u24lambda_u2d4.setMessage$okhttp(message);
        return builder;
    }

    @NotNull
    public static final Response.Builder commonHeader(@NotNull Response.Builder $this$commonHeader, @NotNull String name, @NotNull String value) {
        Response.Builder builder;
        Intrinsics.checkNotNullParameter($this$commonHeader, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value, "value");
        Response.Builder $this$commonHeader_u24lambda_u2d5 = builder = $this$commonHeader;
        boolean bl = false;
        $this$commonHeader_u24lambda_u2d5.getHeaders$okhttp().set(name, value);
        return builder;
    }

    @NotNull
    public static final Response.Builder commonAddHeader(@NotNull Response.Builder $this$commonAddHeader, @NotNull String name, @NotNull String value) {
        Response.Builder builder;
        Intrinsics.checkNotNullParameter($this$commonAddHeader, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value, "value");
        Response.Builder $this$commonAddHeader_u24lambda_u2d6 = builder = $this$commonAddHeader;
        boolean bl = false;
        $this$commonAddHeader_u24lambda_u2d6.getHeaders$okhttp().add(name, value);
        return builder;
    }

    @NotNull
    public static final Response.Builder commonRemoveHeader(@NotNull Response.Builder $this$commonRemoveHeader, @NotNull String name) {
        Response.Builder builder;
        Intrinsics.checkNotNullParameter($this$commonRemoveHeader, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        Response.Builder $this$commonRemoveHeader_u24lambda_u2d7 = builder = $this$commonRemoveHeader;
        boolean bl = false;
        $this$commonRemoveHeader_u24lambda_u2d7.getHeaders$okhttp().removeAll(name);
        return builder;
    }

    @NotNull
    public static final Response.Builder commonHeaders(@NotNull Response.Builder $this$commonHeaders, @NotNull Headers headers2) {
        Response.Builder builder;
        Intrinsics.checkNotNullParameter($this$commonHeaders, "<this>");
        Intrinsics.checkNotNullParameter(headers2, "headers");
        Response.Builder $this$commonHeaders_u24lambda_u2d8 = builder = $this$commonHeaders;
        boolean bl = false;
        $this$commonHeaders_u24lambda_u2d8.setHeaders$okhttp(headers2.newBuilder());
        return builder;
    }

    @NotNull
    public static final Response.Builder commonBody(@NotNull Response.Builder $this$commonBody, @Nullable ResponseBody body) {
        Response.Builder builder;
        Intrinsics.checkNotNullParameter($this$commonBody, "<this>");
        Response.Builder $this$commonBody_u24lambda_u2d9 = builder = $this$commonBody;
        boolean bl = false;
        $this$commonBody_u24lambda_u2d9.setBody$okhttp(body);
        return builder;
    }

    @NotNull
    public static final Response.Builder commonNetworkResponse(@NotNull Response.Builder $this$commonNetworkResponse, @Nullable Response networkResponse) {
        Response.Builder builder;
        Intrinsics.checkNotNullParameter($this$commonNetworkResponse, "<this>");
        Response.Builder $this$commonNetworkResponse_u24lambda_u2d10 = builder = $this$commonNetworkResponse;
        boolean bl = false;
        _ResponseCommonKt.checkSupportResponse("networkResponse", networkResponse);
        $this$commonNetworkResponse_u24lambda_u2d10.setNetworkResponse$okhttp(networkResponse);
        return builder;
    }

    @NotNull
    public static final Response.Builder commonCacheResponse(@NotNull Response.Builder $this$commonCacheResponse, @Nullable Response cacheResponse) {
        Response.Builder builder;
        Intrinsics.checkNotNullParameter($this$commonCacheResponse, "<this>");
        Response.Builder $this$commonCacheResponse_u24lambda_u2d11 = builder = $this$commonCacheResponse;
        boolean bl = false;
        _ResponseCommonKt.checkSupportResponse("cacheResponse", cacheResponse);
        $this$commonCacheResponse_u24lambda_u2d11.setCacheResponse$okhttp(cacheResponse);
        return builder;
    }

    private static final void checkSupportResponse(String name, Response response) {
        Response response2 = response;
        if (response2 != null) {
            Response response3;
            Response $this$checkSupportResponse_u24lambda_u2d16 = response3 = response2;
            boolean bl = false;
            if (!($this$checkSupportResponse_u24lambda_u2d16.body() == null)) {
                boolean $i$a$-require-_ResponseCommonKt$checkSupportResponse$1$52 = false;
                String $i$a$-require-_ResponseCommonKt$checkSupportResponse$1$52 = Intrinsics.stringPlus(name, ".body != null");
                throw new IllegalArgumentException($i$a$-require-_ResponseCommonKt$checkSupportResponse$1$52.toString());
            }
            if (!($this$checkSupportResponse_u24lambda_u2d16.networkResponse() == null)) {
                boolean $i$a$-require-_ResponseCommonKt$checkSupportResponse$1$62 = false;
                String $i$a$-require-_ResponseCommonKt$checkSupportResponse$1$62 = Intrinsics.stringPlus(name, ".networkResponse != null");
                throw new IllegalArgumentException($i$a$-require-_ResponseCommonKt$checkSupportResponse$1$62.toString());
            }
            if (!($this$checkSupportResponse_u24lambda_u2d16.cacheResponse() == null)) {
                boolean $i$a$-require-_ResponseCommonKt$checkSupportResponse$1$72 = false;
                String $i$a$-require-_ResponseCommonKt$checkSupportResponse$1$72 = Intrinsics.stringPlus(name, ".cacheResponse != null");
                throw new IllegalArgumentException($i$a$-require-_ResponseCommonKt$checkSupportResponse$1$72.toString());
            }
            if (!($this$checkSupportResponse_u24lambda_u2d16.priorResponse() == null)) {
                boolean bl2 = false;
                String string = Intrinsics.stringPlus(name, ".priorResponse != null");
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    @NotNull
    public static final Response.Builder commonPriorResponse(@NotNull Response.Builder $this$commonPriorResponse, @Nullable Response priorResponse) {
        Response.Builder builder;
        Intrinsics.checkNotNullParameter($this$commonPriorResponse, "<this>");
        Response.Builder $this$commonPriorResponse_u24lambda_u2d17 = builder = $this$commonPriorResponse;
        boolean bl = false;
        _ResponseCommonKt.checkPriorResponse(priorResponse);
        $this$commonPriorResponse_u24lambda_u2d17.setPriorResponse$okhttp(priorResponse);
        return builder;
    }

    private static final void checkPriorResponse(Response response) {
        Response response2 = response;
        if (response2 != null) {
            Response response3;
            Response $this$checkPriorResponse_u24lambda_u2d19 = response3 = response2;
            boolean bl = false;
            if (!($this$checkPriorResponse_u24lambda_u2d19.body() == null)) {
                boolean bl2 = false;
                String string = "priorResponse.body != null";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }
}

