//[mockwebserver3](../../../index.md)/[mockwebserver3](../index.md)/[MockWebServer](index.md)/[takeRequest](take-request.md)

# takeRequest

[jvm]\
fun [takeRequest](take-request.md)(): [RecordedRequest](../-recorded-request/index.md)

Awaits the next HTTP request, removes it, and returns it. Callers should use this to verify the request was sent as intended. This method will block until the request is available, possibly forever.

#### Return

the head of the request queue

[jvm]\
fun [takeRequest](take-request.md)(timeout: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [RecordedRequest](../-recorded-request/index.md)?

Awaits the next HTTP request (waiting up to the specified wait time if necessary), removes it, and returns it. Callers should use this to verify the request was sent as intended within the given time.

#### Return

the head of the request queue

## Parameters

jvm

| | |
|---|---|
| timeout | how long to wait before giving up, in units of [unit](take-request.md) |
| unit | a [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html) determining how to interpret the [timeout](take-request.md) parameter |
