//[okhttp](../../../index.md)/[okhttp3](../index.md)/[Cache](index.md)

# Cache

[jvm]\
class [Cache](index.md)(directory: [Path](https://square.github.io/okio/2.x/okio/okio/-path/index.html), maxSize: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), fileSystem: [FileSystem](https://square.github.io/okio/2.x/okio/okio/-file-system/index.html)) : [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html), [Flushable](https://docs.oracle.com/javase/8/docs/api/java/io/Flushable.html)

Caches HTTP and HTTPS responses to the filesystem so they may be reused, saving time and bandwidth.

##  Cache Optimization

To measure cache effectiveness, this class tracks three statistics:

- 
   [**Request Count:**](request-count.md) the number of HTTP requests issued since this cache was     created.
- 
   [**Network Count:**](network-count.md) the number of those requests that required network use.
- 
   [**Hit Count:**](hit-count.md) the number of those requests whose responses were served by the     cache.

Sometimes a request will result in a conditional cache hit. If the cache contains a stale copy of the response, the client will issue a conditional GET. The server will then send either the updated response if it has changed, or a short 'not modified' response if the client's copy is still valid. Such responses increment both the network count and hit count.

The best way to improve the cache hit rate is by configuring the web server to return cacheable responses. Although this client honors all [HTTP/1.1 (RFC 7234)](http://tools.ietf.org/html/rfc7234) cache headers, it doesn't cache partial responses.

##  Force a Network Response

In some situations, such as after a user clicks a 'refresh' button, it may be necessary to skip the cache, and fetch data directly from the server. To force a full refresh, add the no-cache directive:

Request request = new Request.Builder()\
    .cacheControl(new CacheControl.Builder().noCache().build())\
    .url("http://publicobject.com/helloworld.txt")\
    .build();

If it is only necessary to force a cached response to be validated by the server, use the more efficient max-age=0 directive instead:

Request request = new Request.Builder()\
    .cacheControl(new CacheControl.Builder()\
        .maxAge(0, TimeUnit.SECONDS)\
        .build())\
    .url("http://publicobject.com/helloworld.txt")\
    .build();

##  Force a Cache Response

Sometimes you'll want to show resources if they are available immediately, but not otherwise. This can be used so your application can show *something* while waiting for the latest data to be downloaded. To restrict a request to locally-cached resources, add the only-if-cached directive:

Request request = new Request.Builder()\
    .cacheControl(new CacheControl.Builder()\
        .onlyIfCached()\
        .build())\
    .url("http://publicobject.com/helloworld.txt")\
    .build();\
Response forceCacheResponse = client.newCall(request).execute();\
if (forceCacheResponse.code() != 504) {\
  // The resource was cached! Show it.\
} else {\
  // The resource was not cached.\
}

This technique works even better in situations where a stale response is better than no response. To permit stale cached responses, use the max-stale directive with the maximum staleness in seconds:

Request request = new Request.Builder()\
    .cacheControl(new CacheControl.Builder()\
        .maxStale(365, TimeUnit.DAYS)\
        .build())\
    .url("http://publicobject.com/helloworld.txt")\
    .build();

The [CacheControl](../-cache-control/index.md) class can configure request caching directives and parse response caching directives. It even offers convenient constants [CacheControl.FORCE_NETWORK](../-cache-control/-companion/-f-o-r-c-e_-n-e-t-w-o-r-k.md) and [CacheControl.FORCE_CACHE](../-cache-control/-companion/-f-o-r-c-e_-c-a-c-h-e.md) that address the use cases above.

## Constructors

| | |
|---|---|
| [Cache](-cache.md) | [jvm]<br>fun [Cache](-cache.md)(directory: [File](https://docs.oracle.com/javase/8/docs/api/java/io/File.html), maxSize: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>Create a cache of at most maxSize bytes in directory. |
| [Cache](-cache.md) | [jvm]<br>fun [Cache](-cache.md)(directory: [Path](https://square.github.io/okio/2.x/okio/okio/-path/index.html), maxSize: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), fileSystem: [FileSystem](https://square.github.io/okio/2.x/okio/okio/-file-system/index.html)) |

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [close](close.md) | [jvm]<br>open override fun [close](close.md)() |
| [delete](delete.md) | [jvm]<br>fun [delete](delete.md)()<br>Closes the cache and deletes all of its stored values. This will delete all files in the cache directory including files that weren't created by the cache. |
| [evictAll](evict-all.md) | [jvm]<br>fun [evictAll](evict-all.md)()<br>Deletes all values stored in the cache. In-flight writes to the cache will complete normally, but the corresponding responses will not be stored. |
| [flush](flush.md) | [jvm]<br>open override fun [flush](flush.md)() |
| [hitCount](hit-count.md) | [jvm]<br>@[Synchronized](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-synchronized/index.html)<br>fun [hitCount](hit-count.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [initialize](initialize.md) | [jvm]<br>fun [initialize](initialize.md)()<br>Initialize the cache. This will include reading the journal files from the storage and building up the necessary in-memory cache information. |
| [maxSize](max-size.md) | [jvm]<br>fun [maxSize](max-size.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Max size of the cache (in bytes). |
| [networkCount](network-count.md) | [jvm]<br>@[Synchronized](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-synchronized/index.html)<br>fun [networkCount](network-count.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [requestCount](request-count.md) | [jvm]<br>@[Synchronized](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-synchronized/index.html)<br>fun [requestCount](request-count.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [size](size.md) | [jvm]<br>fun [size](size.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [urls](urls.md) | [jvm]<br>fun [urls](urls.md)(): [MutableIterator](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-iterator/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;<br>Returns an iterator over the URLs in this cache. This iterator doesn't throw ConcurrentModificationException, but if new responses are added while iterating, their URLs will not be returned. If existing responses are evicted during iteration, they will be absent (unless they were already returned). |
| [writeAbortCount](write-abort-count.md) | [jvm]<br>@[Synchronized](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-synchronized/index.html)<br>fun [writeAbortCount](write-abort-count.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [writeSuccessCount](write-success-count.md) | [jvm]<br>@[Synchronized](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-synchronized/index.html)<br>fun [writeSuccessCount](write-success-count.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |

## Properties

| Name | Summary |
|---|---|
| [directory](directory.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "directory")<br>val [directory](directory.md): [File](https://docs.oracle.com/javase/8/docs/api/java/io/File.html) |
| [directoryPath](directory-path.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "directoryPath")<br>val [directoryPath](directory-path.md): [Path](https://square.github.io/okio/2.x/okio/okio/-path/index.html) |
| [isClosed](is-closed.md) | [jvm]<br>val [isClosed](is-closed.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
