//[okhttp](../../../index.md)/[okhttp3](../index.md)/[CookieJar](index.md)

# CookieJar

[jvm]\
interface [CookieJar](index.md)

Provides **policy** and **persistence** for HTTP cookies.

As policy, implementations of this interface are responsible for selecting which cookies to accept and which to reject. A reasonable policy is to reject all cookies, though that may interfere with session-based authentication schemes that require cookies.

As persistence, implementations of this interface must also provide storage of cookies. Simple implementations may store cookies in memory; sophisticated ones may use the file system or database to hold accepted cookies. The [cookie storage model](https://tools.ietf.org/html/rfc6265#section-5.3) specifies policies for updating and expiring cookies.

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [loadForRequest](load-for-request.md) | [jvm]<br>abstract fun [loadForRequest](load-for-request.md)(url: [HttpUrl](../-http-url/index.md)): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Cookie](../-cookie/index.md)&gt;<br>Load cookies from the jar for an HTTP request to [url](load-for-request.md). This method returns a possibly empty list of cookies for the network request. |
| [saveFromResponse](save-from-response.md) | [jvm]<br>abstract fun [saveFromResponse](save-from-response.md)(url: [HttpUrl](../-http-url/index.md), cookies: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Cookie](../-cookie/index.md)&gt;)<br>Saves [cookies](save-from-response.md) from an HTTP response to this store according to this jar's policy. |
