//[okhttp](../../../../index.md)/[okhttp3](../../index.md)/[Cookie](../index.md)/[Builder](index.md)

# Builder

[jvm]\
class [Builder](index.md)

Builds a cookie. The [name](name.md), [value](value.md), and [domain](domain.md) values must all be set before calling [build](build.md).

## Constructors

| | |
|---|---|
| [Builder](-builder.md) | [jvm]<br>fun [Builder](-builder.md)() |

## Functions

| Name | Summary |
|---|---|
| [build](build.md) | [jvm]<br>fun [build](build.md)(): [Cookie](../index.md) |
| [domain](domain.md) | [jvm]<br>fun [domain](domain.md)(domain: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Cookie.Builder](index.md)<br>Set the domain pattern for this cookie. The cookie will match [domain](domain.md) and all of its subdomains. |
| [expiresAt](expires-at.md) | [jvm]<br>fun [expiresAt](expires-at.md)(expiresAt: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Cookie.Builder](index.md) |
| [hostOnlyDomain](host-only-domain.md) | [jvm]<br>fun [hostOnlyDomain](host-only-domain.md)(domain: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Cookie.Builder](index.md)<br>Set the host-only domain for this cookie. The cookie will match [domain](host-only-domain.md) but none of its subdomains. |
| [httpOnly](http-only.md) | [jvm]<br>fun [httpOnly](http-only.md)(): [Cookie.Builder](index.md) |
| [name](name.md) | [jvm]<br>fun [name](name.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Cookie.Builder](index.md) |
| [path](path.md) | [jvm]<br>fun [path](path.md)(path: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Cookie.Builder](index.md) |
| [secure](secure.md) | [jvm]<br>fun [secure](secure.md)(): [Cookie.Builder](index.md) |
| [value](value.md) | [jvm]<br>fun [value](value.md)(value: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Cookie.Builder](index.md) |
