//[okhttp](../../../index.md)/[okhttp3](../index.md)/[EventListener](index.md)/[canceled](canceled.md)

# canceled

[jvm]\
open fun [canceled](canceled.md)(call: [Call](../-call/index.md))

Invoked when a call is canceled.

Like all methods in this interface, this is invoked on the thread that triggered the event. But while other events occur sequentially; cancels may occur concurrently with other events. For example, thread A may be executing [responseBodyStart](response-body-start.md) while thread B executes [canceled](canceled.md). Implementations must support such concurrent calls.

Note that cancellation is best-effort and that a call may proceed normally after it has been canceled. For example, happy-path events like [requestHeadersStart](request-headers-start.md) and [requestHeadersEnd](request-headers-end.md) may occur after a call is canceled. Typically cancellation takes effect when an expensive I/O operation is required.

This is invoked at most once, even if [Call.cancel](../-call/cancel.md) is invoked multiple times. It may be invoked at any point in a call's life, including before [callStart](call-start.md) and after [callEnd](call-end.md).
