//[okhttp](../../../index.md)/[okhttp3](../index.md)/[EventListener](index.md)/[proxySelectEnd](proxy-select-end.md)

# proxySelectEnd

[jvm]\
open fun [proxySelectEnd](proxy-select-end.md)(call: [Call](../-call/index.md), url: [HttpUrl](../-http-url/index.md), proxies: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;@[JvmSuppressWildcards](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-suppress-wildcards/index.html)[Proxy](https://docs.oracle.com/javase/8/docs/api/java/net/Proxy.html)&gt;)

Invoked after proxy selection.

Note that the list of proxies is never null, but it may be a list containing only [Proxy.NO_PROXY](https://docs.oracle.com/javase/8/docs/api/java/net/Proxy.html#NO_PROXY--). This comes up in several situations:

- 
   If neither a proxy nor proxy selector is configured.
- 
   If the proxy is configured explicitly as [Proxy.NO_PROXY](https://docs.oracle.com/javase/8/docs/api/java/net/Proxy.html#NO_PROXY--).
- 
   If the proxy selector returns only [Proxy.NO_PROXY](https://docs.oracle.com/javase/8/docs/api/java/net/Proxy.html#NO_PROXY--).
- 
   If the proxy selector returns an empty list or null.

Otherwise it lists the proxies in the order they will be attempted.

## Parameters

jvm

| | |
|---|---|
| url | a URL with only the scheme, hostname, and port specified. |
