//[okhttp](../../../../index.md)/[okhttp3](../../index.md)/[Headers](../index.md)/[Builder](index.md)

# Builder

[common]\
expect class [Builder](index.md)

[jvm, nonJvm]\
actual class [Builder](index.md)

## Functions

| Name | Summary |
|---|---|
| [add](add.md) | [jvm]<br>fun [add](add.md)(line: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Headers.Builder](index.md)<br>Add an header line containing a field name, a literal colon, and a value.<br>[jvm]<br>@IgnoreJRERequirement<br>fun [add](add.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: [Instant](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html)): [Headers.Builder](index.md)<br>Add a header with the specified name and formatted instant. Does validation of header names and value.<br>[jvm]<br>fun [add](add.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: [Date](https://docs.oracle.com/javase/8/docs/api/java/util/Date.html)): [Headers.Builder](index.md)<br>Add a header with the specified name and formatted date. Does validation of header names and value.<br>[common]<br>expect fun [add](add.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Headers.Builder](index.md)<br>Add a header with the specified name and value. Does validation of header names and values.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual fun [add](add.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Headers.Builder](index.md) |
| [addAll](add-all.md) | [common]<br>expect fun [addAll](add-all.md)(headers: [Headers](../index.md)): [Headers.Builder](index.md)<br>Adds all headers from an existing collection.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual fun [addAll](add-all.md)(headers: [Headers](../index.md)): [Headers.Builder](index.md) |
| [addUnsafeNonAscii](add-unsafe-non-ascii.md) | [jvm]<br>fun [addUnsafeNonAscii](add-unsafe-non-ascii.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Headers.Builder](index.md)<br>Add a header with the specified name and value. Does validation of header names, allowing non-ASCII values. |
| [build](build.md) | [common, jvm, nonJvm]<br>[common]<br>expect fun [build](build.md)(): [Headers](../index.md)<br>[jvm, nonJvm]<br>actual fun [build](build.md)(): [Headers](../index.md) |
| [get](get.md) | [common, jvm, nonJvm]<br>[common]<br>expect operator fun [get](get.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?<br>[jvm, nonJvm]<br>actual operator fun [get](get.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?<br>Equivalent to build().get(name), but potentially faster. |
| [removeAll](remove-all.md) | [common, jvm, nonJvm]<br>[common]<br>expect fun [removeAll](remove-all.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Headers.Builder](index.md)<br>[jvm, nonJvm]<br>actual fun [removeAll](remove-all.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Headers.Builder](index.md) |
| [set](set.md) | [jvm]<br>@IgnoreJRERequirement<br>operator fun [set](set.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: [Instant](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html)): [Headers.Builder](index.md)<br>Set a field with the specified instant. If the field is not found, it is added. If the field is found, the existing values are replaced.<br>[jvm]<br>operator fun [set](set.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: [Date](https://docs.oracle.com/javase/8/docs/api/java/util/Date.html)): [Headers.Builder](index.md)<br>Set a field with the specified date. If the field is not found, it is added. If the field is found, the existing values are replaced.<br>[common, jvm, nonJvm]<br>[common]<br>expect operator fun [set](set.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Headers.Builder](index.md)<br>[jvm, nonJvm]<br>actual operator fun [set](set.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Headers.Builder](index.md)<br>Set a field with the specified value. If the field is not found, it is added. If the field is found, the existing values are replaced. |
