//[okhttp](../../../index.md)/[okhttp3](../index.md)/[HttpUrl](index.md)/[queryParameterValue](query-parameter-value.md)

# queryParameterValue

[jvm]\
fun [queryParameterValue](query-parameter-value.md)(index: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?

Returns the value of the query parameter at index. For example this returns "apple" for queryParameterName(0) on http://host/?a=apple&amp;b=banana. This throws if index is not less than the [query size](query-size.md).

| URL | queryParameterValue(0) | queryParameterValue(1) |
|---|---|---|
| http://host/ | exception | exception |
| http://host/? | null | exception |
| http://host/?a=apple&amp;k=key+lime | "apple" | "key lime" |
| http://host/?a=apple&amp;a=apricot | "apple" | "apricot" |
| http://host/?a=apple&amp;b | "apple" | null |
