//[okhttp](../../../../index.md)/[okhttp3](../../index.md)/[OkHttpClient](../index.md)/[Builder](index.md)/[callTimeout](call-timeout.md)

# callTimeout

[jvm]\
fun [callTimeout](call-timeout.md)(timeout: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [OkHttpClient.Builder](index.md)

@IgnoreJRERequirement

fun [callTimeout](call-timeout.md)(duration: [Duration](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)): [OkHttpClient.Builder](index.md)

Sets the default timeout for complete calls. A value of 0 means no timeout, otherwise values must be between 1 and [Integer.MAX_VALUE](https://docs.oracle.com/javase/8/docs/api/java/lang/Integer.html#MAX_VALUE--) when converted to milliseconds.

The call timeout spans the entire call: resolving DNS, connecting, writing the request body, server processing, and reading the response body. If the call requires redirects or retries all must complete within one timeout period.

The default value is 0 which imposes no timeout.
