//[okhttp](../../../../index.md)/[okhttp3](../../index.md)/[Protocol](../index.md)/[HTTP_2](index.md)

# HTTP_2

[common]\
[HTTP_2](index.md)("h2")

The IETF's binary-framed protocol that includes header compression, multiplexing multiple requests on the same socket, and server-push. HTTP/1.1 semantics are layered on HTTP/2.

HTTP/2 requires deployments of HTTP/2 that use TLS 1.2 support CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, present in Java 8+ and Android 5+. Servers that enforce this may send an exception message including the string INADEQUATE_SECURITY.

## Functions

| Name | Summary |
|---|---|
| [toString](../to-string.md) | [common]<br>open override fun [toString](../to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns the string used to identify this protocol for ALPN, like "http/1.1", "spdy/3.1" or "h2". |

## Properties

| Name | Summary |
|---|---|
| [name](../../-tls-version/-s-s-l_3_0/index.md#-372974862%2FProperties%2F180464967) | [common]<br>val [name](../../-tls-version/-s-s-l_3_0/index.md#-372974862%2FProperties%2F180464967): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [ordinal](../../-tls-version/-s-s-l_3_0/index.md#-739389684%2FProperties%2F180464967) | [common]<br>val [ordinal](../../-tls-version/-s-s-l_3_0/index.md#-739389684%2FProperties%2F180464967): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
