//[okhttp](../../../index.md)/[okhttp3](../index.md)/[Response](index.md)

# Response

[common]\
expect class [Response](index.md) : [Closeable](https://square.github.io/okio/2.x/okio/okio/-closeable/index.html)

An HTTP response. Instances of this class are not immutable: the response body is a one-shot value that may be consumed only once and then closed. All other properties are immutable.

This class implements [Closeable](https://square.github.io/okio/2.x/okio/okio/-closeable/index.html). Closing it simply closes its response body. See [ResponseBody](../-response-body/index.md) for an explanation and examples.

[jvm]\
actual class [Response](index.md) : [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html)

[nonJvm]\
actual class [Response](index.md)

An HTTP response. Instances of this class are not immutable: the response body is a one-shot value that may be consumed only once and then closed. All other properties are immutable.

This class implements Closeable. Closing it simply closes its response body. See [ResponseBody](../-response-body/index.md) for an explanation and examples.

## Types

| Name | Summary |
|---|---|
| [Builder](-builder/index.md) | [common, jvm, nonJvm]<br>[common]<br>expect open class [Builder](-builder/index.md)<br>[jvm, nonJvm]<br>actual open class [Builder](-builder/index.md) |

## Functions

| Name | Summary |
|---|---|
| [challenges](challenges.md) | [jvm]<br>fun [challenges](challenges.md)(): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Challenge](../-challenge/index.md)&gt;<br>Returns the RFC 7235 authorization challenges appropriate for this response's code. If the response code is 401 unauthorized, this returns the "WWW-Authenticate" challenges. If the response code is 407 proxy unauthorized, this returns the "Proxy-Authenticate" challenges. Otherwise this returns an empty list of challenges. |
| [close](close.md) | [common, nonJvm]<br>[common]<br>expect open override fun [close](close.md)()<br>[nonJvm]<br>actual open fun [close](close.md)()<br>Closes the response body. Equivalent to body().close().<br>[jvm]<br>actual open override fun [close](close.md)() |
| [header](header.md) | [common, jvm, nonJvm]<br>[common]<br>expect fun [header](header.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), defaultValue: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?<br>[jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)<br>actual fun [header](header.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), defaultValue: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?<br>[nonJvm]<br>actual fun [header](header.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), defaultValue: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [headers](headers.md) | [common, jvm, nonJvm]<br>[common]<br>expect fun [headers](headers.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;<br>[jvm, nonJvm]<br>actual fun [headers](headers.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt; |
| [newBuilder](new-builder.md) | [common, jvm, nonJvm]<br>[common]<br>expect fun [newBuilder](new-builder.md)(): [Response.Builder](-builder/index.md)<br>[jvm, nonJvm]<br>actual fun [newBuilder](new-builder.md)(): [Response.Builder](-builder/index.md) |
| [peekBody](peek-body.md) | [common, nonJvm]<br>[common]<br>expect fun [peekBody](peek-body.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [ResponseBody](../-response-body/index.md)<br>[nonJvm]<br>actual fun [peekBody](peek-body.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [ResponseBody](../-response-body/index.md)<br>Peeks up to [byteCount](peek-body.md) bytes from the response body and returns them as a new response body. If fewer than [byteCount](peek-body.md) bytes are in the response body, the full response body is returned. If more than [byteCount](peek-body.md) bytes are in the response body, the returned value will be truncated to [byteCount](peek-body.md) bytes.<br>[jvm]<br>actual fun [peekBody](peek-body.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [ResponseBody](../-response-body/index.md) |
| [toString](to-string.md) | [common, jvm, nonJvm]<br>[common]<br>expect open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[jvm, nonJvm]<br>actual open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [trailers](trailers.md) | [jvm]<br>fun [trailers](trailers.md)(): [Headers](../-headers/index.md)<br>Returns the trailers after the HTTP response, which may be empty. It is an error to call this before the entire HTTP response body has been consumed. |

## Properties

| Name | Summary |
|---|---|
| [body](body.md) | [common]<br>expect val [body](body.md): [ResponseBody](../-response-body/index.md)?<br>Returns a non-null value if this response was passed to [Callback.onResponse](../-callback/on-response.md) or returned from Call.execute. Response bodies must be [closed](../-response-body/index.md) and may be consumed only once.<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "body")<br>actual val [body](body.md): [ResponseBody](../-response-body/index.md)?<br>[nonJvm]<br>actual val [body](body.md): [ResponseBody](../-response-body/index.md)?<br>Returns a non-null value if this response was passed to Callback.onResponse or returned from Call.execute. Response bodies must be [closed](../-response-body/index.md) and may be consumed only once. |
| [cacheControl](cache-control.md) | [common]<br>expect val [cacheControl](cache-control.md): [CacheControl](../-cache-control/index.md)<br>Returns the cache control directives for this response. This is never null, even if this response contains no Cache-Control header.<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "cacheControl")<br>actual val [cacheControl](cache-control.md): [CacheControl](../-cache-control/index.md)<br>[nonJvm]<br>actual val [cacheControl](cache-control.md): [CacheControl](../-cache-control/index.md)<br>Returns the cache control directives for this response. This is never null, even if this response contains no Cache-Control header. |
| [cacheResponse](cache-response.md) | [common]<br>expect val [cacheResponse](cache-response.md): [Response](index.md)?<br>Returns the raw response received from the cache. Will be null if this response didn't use the cache. For conditional get requests the cache response and network response may both be non-null. The body of the returned response should not be read.<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "cacheResponse")<br>actual val [cacheResponse](cache-response.md): [Response](index.md)?<br>[nonJvm]<br>actual val [cacheResponse](cache-response.md): [Response](index.md)?<br>Returns the raw response received from the cache. Will be null if this response didn't use the cache. For conditional get requests the cache response and network response may both be non-null. The body of the returned response should not be read. |
| [code](code.md) | [common]<br>expect val [code](code.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Returns the HTTP status code.<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "code")<br>actual val [code](code.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[nonJvm]<br>actual val [code](code.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Returns the HTTP status code. |
| [handshake](handshake.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "handshake")<br>val [handshake](handshake.md): [Handshake](../-handshake/index.md)?<br>Returns the TLS handshake of the connection that carried this response, or null if the response was received without TLS. |
| [headers](headers.md) | [common]<br>expect val [headers](headers.md): [Headers](../-headers/index.md)<br>Returns the HTTP headers.<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "headers")<br>actual val [headers](headers.md): [Headers](../-headers/index.md)<br>Returns the HTTP headers.<br>[nonJvm]<br>actual val [headers](headers.md): [Headers](../-headers/index.md)<br>Returns the HTTP headers. |
| [isRedirect](is-redirect.md) | [common]<br>expect val [isRedirect](is-redirect.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if this response redirects to another resource.<br>[jvm, nonJvm]<br>actual val [isRedirect](is-redirect.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if this response redirects to another resource. |
| [isSuccessful](is-successful.md) | [common]<br>expect val [isSuccessful](is-successful.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if the code is in [200..300), which means the request was successfully received, understood, and accepted.<br>[jvm]<br>actual val [isSuccessful](is-successful.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[nonJvm]<br>actual val [isSuccessful](is-successful.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if the code is in [200..300), which means the request was successfully received, understood, and accepted. |
| [message](message.md) | [common]<br>expect val [message](message.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns the HTTP status message.<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "message")<br>actual val [message](message.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[nonJvm]<br>actual val [message](message.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns the HTTP status message. |
| [networkResponse](network-response.md) | [common]<br>expect val [networkResponse](network-response.md): [Response](index.md)?<br>Returns the raw response received from the network. Will be null if this response didn't use the network, such as when the response is fully cached. The body of the returned response should not be read.<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "networkResponse")<br>actual val [networkResponse](network-response.md): [Response](index.md)?<br>[nonJvm]<br>actual val [networkResponse](network-response.md): [Response](index.md)?<br>Returns the raw response received from the network. Will be null if this response didn't use the network, such as when the response is fully cached. The body of the returned response should not be read. |
| [priorResponse](prior-response.md) | [common]<br>expect val [priorResponse](prior-response.md): [Response](index.md)?<br>Returns the response for the HTTP redirect or authorization challenge that triggered this response, or null if this response wasn't triggered by an automatic retry. The body of the returned response should not be read because it has already been consumed by the redirecting client.<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "priorResponse")<br>actual val [priorResponse](prior-response.md): [Response](index.md)?<br>[nonJvm]<br>actual val [priorResponse](prior-response.md): [Response](index.md)?<br>Returns the response for the HTTP redirect or authorization challenge that triggered this response, or null if this response wasn't triggered by an automatic retry. The body of the returned response should not be read because it has already been consumed by the redirecting client. |
| [protocol](protocol.md) | [common]<br>expect val [protocol](protocol.md): [Protocol](../-protocol/index.md)<br>Returns the HTTP protocol, such as [Protocol.HTTP_1_1](../-protocol/-h-t-t-p_1_1/index.md) or [Protocol.HTTP_1_0](../-protocol/-h-t-t-p_1_0/index.md).<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "protocol")<br>actual val [protocol](protocol.md): Protocol<br>[nonJvm]<br>actual val [protocol](protocol.md): Protocol<br>Returns the HTTP protocol, such as Protocol.HTTP_1_1 or Protocol.HTTP_1_0. |
| [receivedResponseAtMillis](received-response-at-millis.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "receivedResponseAtMillis")<br>val [receivedResponseAtMillis](received-response-at-millis.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns a [timestamp](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#currentTimeMillis--) taken immediately after OkHttp received this response's headers from the network. If this response is being served from the cache then this is the timestamp of the original response. |
| [request](request.md) | [common]<br>expect val [request](request.md): [Request](../-request/index.md)<br>The request that initiated this HTTP response. This is not necessarily the same request issued by the application:<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "request")<br>actual val [request](request.md): [Request](../-request/index.md)<br>[nonJvm]<br>actual val [request](request.md): [Request](../-request/index.md)<br>The request that initiated this HTTP response. This is not necessarily the same request issued by the application: |
| [sentRequestAtMillis](sent-request-at-millis.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "sentRequestAtMillis")<br>val [sentRequestAtMillis](sent-request-at-millis.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns a [timestamp](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#currentTimeMillis--) taken immediately before OkHttp transmitted the initiating request over the network. If this response is being served from the cache then this is the timestamp of the original request. |

## Extensions

| Name | Summary |
|---|---|
| [hasVaryAll](../-cache/-companion/has-vary-all.md) | [jvm]<br>fun [Response](index.md).[hasVaryAll](../-cache/-companion/has-vary-all.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if a Vary header contains an asterisk. Such responses cannot be cached. |
| [varyHeaders](../-cache/-companion/vary-headers.md) | [jvm]<br>fun [Response](index.md).[varyHeaders](../-cache/-companion/vary-headers.md)(): [Headers](../-headers/index.md)<br>Returns the subset of the headers in this's request that impact the content of this's body. |
