/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.mordant.input.InputEvent;
import com.github.ajalt.mordant.input.MouseTracking;
import com.github.ajalt.mordant.rendering.AnsiLevel;
import com.github.ajalt.mordant.rendering.Size;
import com.github.ajalt.mordant.terminal.PrintRequest;
import com.github.ajalt.mordant.terminal.TerminalInfo;
import com.github.ajalt.mordant.terminal.TerminalInterface;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.TimeMark;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007BO\b\u0016\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0006\u0010\u0012J\u0006\u0010%\u001a\u00020&J\u0006\u0010\u001f\u001a\u00020\u0015J\u0006\u0010#\u001a\u00020\u0015J\u0006\u0010$\u001a\u00020\u0015J\u0010\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020)H\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010\u00152\u0006\u0010+\u001a\u00020\u000eH\u0016J\b\u0010,\u001a\u00020\u0005H\u0016J5\u0010\u0002\u001a\u00020\u00032\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010-J\u001a\u0010.\u001a\u0004\u0018\u00010\u001b2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016J\u0019\u00103\u001a\u000605j\u0002`42\u0006\u00101\u001a\u000202H\u0016\u00a2\u0006\u0002\u00106R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0017\"\u0004\b\u001d\u0010\u0019R\u000e\u0010\u001e\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00060!j\u0002` X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\"R\u0014\u0010#\u001a\u00060!j\u0002` X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\"R\u0014\u0010$\u001a\u00060!j\u0002` X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\"\u00a8\u00067"}, d2={"Lcom/github/ajalt/mordant/terminal/TerminalRecorder;", "Lcom/github/ajalt/mordant/terminal/TerminalInterface;", "info", "Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "size", "Lcom/github/ajalt/mordant/rendering/Size;", "<init>", "(Lcom/github/ajalt/mordant/terminal/TerminalInfo;Lcom/github/ajalt/mordant/rendering/Size;)V", "ansiLevel", "Lcom/github/ajalt/mordant/rendering/AnsiLevel;", "width", "", "height", "hyperlinks", "", "outputInteractive", "inputInteractive", "supportsAnsiCursor", "(Lcom/github/ajalt/mordant/rendering/AnsiLevel;IIZZZZ)V", "inputLines", "", "", "getInputLines", "()Ljava/util/List;", "setInputLines", "(Ljava/util/List;)V", "inputEvents", "Lcom/github/ajalt/mordant/input/InputEvent;", "getInputEvents", "setInputEvents", "rawModeActive", "stdout", "Lkotlin/text/StringBuilder;", "Ljava/lang/StringBuilder;", "Ljava/lang/StringBuilder;", "stderr", "output", "clearOutput", "", "completePrintRequest", "request", "Lcom/github/ajalt/mordant/terminal/PrintRequest;", "readLineOrNull", "hideInput", "getTerminalSize", "(Lcom/github/ajalt/mordant/rendering/AnsiLevel;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "readInputEvent", "timeout", "Lkotlin/time/TimeMark;", "mouseTracking", "Lcom/github/ajalt/mordant/input/MouseTracking;", "enterRawMode", "Lkotlin/AutoCloseable;", "Ljava/lang/AutoCloseable;", "(Lcom/github/ajalt/mordant/input/MouseTracking;)Ljava/lang/AutoCloseable;", "mordant"})
public final class TerminalRecorder
implements TerminalInterface {
    @NotNull
    private final TerminalInfo info;
    @NotNull
    private final Size size;
    @NotNull
    private List<String> inputLines;
    @NotNull
    private List<InputEvent> inputEvents;
    private boolean rawModeActive;
    @NotNull
    private final StringBuilder stdout;
    @NotNull
    private final StringBuilder stderr;
    @NotNull
    private final StringBuilder output;

    private TerminalRecorder(TerminalInfo info, Size size) {
        this.info = info;
        this.size = size;
        this.inputLines = new ArrayList();
        this.inputEvents = new ArrayList();
        this.stdout = new StringBuilder();
        this.stderr = new StringBuilder();
        this.output = new StringBuilder();
    }

    public TerminalRecorder(@NotNull AnsiLevel ansiLevel, int width, int height, boolean hyperlinks, boolean outputInteractive, boolean inputInteractive, boolean supportsAnsiCursor) {
        Intrinsics.checkNotNullParameter((Object)ansiLevel, "ansiLevel");
        this(new TerminalInfo(ansiLevel, hyperlinks, outputInteractive, inputInteractive, supportsAnsiCursor), new Size(width, height));
    }

    public /* synthetic */ TerminalRecorder(AnsiLevel ansiLevel, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            ansiLevel = AnsiLevel.TRUECOLOR;
        }
        if ((n3 & 2) != 0) {
            n = 79;
        }
        if ((n3 & 4) != 0) {
            n2 = 24;
        }
        if ((n3 & 8) != 0) {
            boolean bl5 = bl = ansiLevel != AnsiLevel.NONE;
        }
        if ((n3 & 0x10) != 0) {
            boolean bl6 = bl2 = ansiLevel != AnsiLevel.NONE;
        }
        if ((n3 & 0x20) != 0) {
            boolean bl7 = bl3 = ansiLevel != AnsiLevel.NONE;
        }
        if ((n3 & 0x40) != 0) {
            bl4 = false;
        }
        this(ansiLevel, n, n2, bl, bl2, bl3, bl4);
    }

    @NotNull
    public final List<String> getInputLines() {
        return this.inputLines;
    }

    public final void setInputLines(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.inputLines = list;
    }

    @NotNull
    public final List<InputEvent> getInputEvents() {
        return this.inputEvents;
    }

    public final void setInputEvents(@NotNull List<InputEvent> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.inputEvents = list;
    }

    public final void clearOutput() {
        StringsKt.clear(this.stdout);
        StringsKt.clear(this.stderr);
        StringsKt.clear(this.output);
    }

    @NotNull
    public final String stdout() {
        String string = this.stdout.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final String stderr() {
        String string = this.stderr.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final String output() {
        String string = this.output.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @Override
    public void completePrintRequest(@NotNull PrintRequest request) {
        Intrinsics.checkNotNullParameter(request, "request");
        StringBuilder sb = request.getStderr() ? this.stderr : this.stdout;
        sb.append(request.getText());
        this.output.append(request.getText());
        if (request.getTrailingLinebreak()) {
            sb.append("\n");
            this.output.append("\n");
        }
    }

    @Override
    @Nullable
    public String readLineOrNull(boolean hideInput) {
        return CollectionsKt.removeFirstOrNull(this.inputLines);
    }

    @Override
    @NotNull
    public Size getTerminalSize() {
        return this.size;
    }

    @Override
    @NotNull
    public TerminalInfo info(@Nullable AnsiLevel ansiLevel, @Nullable Boolean hyperlinks, @Nullable Boolean outputInteractive, @Nullable Boolean inputInteractive) {
        AnsiLevel ansiLevel2 = ansiLevel;
        if (ansiLevel2 == null) {
            ansiLevel2 = this.info.getAnsiLevel();
        }
        Boolean bl = hyperlinks;
        Boolean bl2 = outputInteractive;
        Boolean bl3 = inputInteractive;
        return new TerminalInfo(ansiLevel2, bl != null ? bl.booleanValue() : this.info.getAnsiHyperLinks(), bl2 != null ? bl2.booleanValue() : this.info.getOutputInteractive(), bl3 != null ? bl3.booleanValue() : this.info.getInputInteractive(), this.info.getSupportsAnsiCursor());
    }

    @Override
    @Nullable
    public InputEvent readInputEvent(@NotNull TimeMark timeout2, @NotNull MouseTracking mouseTracking) {
        Intrinsics.checkNotNullParameter(timeout2, "timeout");
        Intrinsics.checkNotNullParameter((Object)mouseTracking, "mouseTracking");
        return CollectionsKt.removeFirstOrNull(this.inputEvents);
    }

    @Override
    @NotNull
    public AutoCloseable enterRawMode(@NotNull MouseTracking mouseTracking) {
        Intrinsics.checkNotNullParameter((Object)mouseTracking, "mouseTracking");
        if (!this.info.getInputInteractive()) {
            throw new RuntimeException("Cannot enter raw mode on a non-interactive terminal");
        }
        this.rawModeActive = true;
        return new AutoCloseable(this){
            final /* synthetic */ TerminalRecorder this$0;
            {
                this.this$0 = terminalRecorder;
            }

            public final void close() {
                boolean bl = false;
                TerminalRecorder.access$setRawModeActive$p(this.this$0, false);
            }
        };
    }

    @Override
    public boolean shouldAutoUpdateSize() {
        return TerminalInterface.DefaultImpls.shouldAutoUpdateSize(this);
    }

    public static final /* synthetic */ void access$setRawModeActive$p(TerminalRecorder $this, boolean bl) {
        $this.rawModeActive = bl;
    }
}

