/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.curl;

import com.github.ajalt.clikt.core.CliktCommand;
import com.github.ajalt.clikt.core.Context;
import com.github.ajalt.clikt.parameters.arguments.ArgumentKt;
import com.github.ajalt.clikt.parameters.options.FlagOptionKt;
import com.github.ajalt.clikt.parameters.options.OptionWithValuesKt;
import com.github.ajalt.clikt.parameters.types.IntKt;
import java.io.Closeable;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.curl.Main;
import okhttp3.curl.internal._MainCommonKt;
import okhttp3.curl.logging.LoggingUtil;
import okhttp3.internal.platform.Platform;
import okhttp3.logging.HttpLoggingInterceptor;
import okhttp3.logging.LoggingEventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 K2\u00020\u0001:\u0001KB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010E\u001a\u00020FH\u0016J\u0006\u0010G\u001a\u00020HJ\u0006\u0010I\u001a\u00020@J\u0006\u0010J\u001a\u00020FR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\f\u001a\u0004\u0018\u00010\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0011\u001a\u0004\u0018\u00010\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0012\u0010\u000eR#\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0010\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0019\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0010\u001a\u0004\b\u001a\u0010\u000eR\u001b\u0010\u001c\u001a\u00020\u001d8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0010\u001a\u0004\b\u001e\u0010\u001fR\u001b\u0010!\u001a\u00020\u001d8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u0010\u001a\u0004\b\"\u0010\u001fR\u001b\u0010$\u001a\u00020\u001d8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u0010\u001a\u0004\b%\u0010\u001fR\u001b\u0010'\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u0010\u001a\u0004\b(\u0010\u0007R\u001b\u0010*\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\u0010\u001a\u0004\b+\u0010\u0007R\u001b\u0010-\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010\u0010\u001a\u0004\b.\u0010\u0007R\u001b\u00100\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010\u0010\u001a\u0004\b1\u0010\u0007R\u001d\u00103\u001a\u0004\u0018\u00010\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u0010\u0010\u001a\u0004\b4\u0010\u000eR\u001b\u00106\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b8\u0010\u0010\u001a\u0004\b7\u0010\u0007R\u001b\u00109\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u0010\u0010\u001a\u0004\b:\u0010\u0007R\u001d\u0010<\u001a\u0004\u0018\u00010\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b>\u0010\u0010\u001a\u0004\b=\u0010\u000eR\u001c\u0010?\u001a\u0004\u0018\u00010@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010D\u00a8\u0006L"}, d2={"Lokhttp3/curl/Main;", "Lcom/github/ajalt/clikt/core/CliktCommand;", "<init>", "()V", "printHelpOnEmptyArgs", "", "getPrintHelpOnEmptyArgs", "()Z", "help", "", "context", "Lcom/github/ajalt/clikt/core/Context;", "method", "getMethod", "()Ljava/lang/String;", "method$delegate", "Lkotlin/properties/ReadOnlyProperty;", "data", "getData", "data$delegate", "headers", "", "getHeaders", "()Ljava/util/List;", "headers$delegate", "userAgent", "getUserAgent", "userAgent$delegate", "connectTimeout", "", "getConnectTimeout", "()I", "connectTimeout$delegate", "readTimeout", "getReadTimeout", "readTimeout$delegate", "callTimeout", "getCallTimeout", "callTimeout$delegate", "followRedirects", "getFollowRedirects", "followRedirects$delegate", "allowInsecure", "getAllowInsecure", "allowInsecure$delegate", "showHeaders", "getShowHeaders", "showHeaders$delegate", "showHttp2Frames", "getShowHttp2Frames", "showHttp2Frames$delegate", "referer", "getReferer", "referer$delegate", "verbose", "getVerbose", "verbose$delegate", "sslDebug", "getSslDebug", "sslDebug$delegate", "url", "getUrl", "url$delegate", "client", "Lokhttp3/Call$Factory;", "getClient", "()Lokhttp3/Call$Factory;", "setClient", "(Lokhttp3/Call$Factory;)V", "run", "", "createRequest", "Lokhttp3/Request;", "createClient", "close", "Companion", "okcurl"})
public final class Main
extends CliktCommand {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    private final boolean printHelpOnEmptyArgs;
    @NotNull
    private final ReadOnlyProperty method$delegate;
    @NotNull
    private final ReadOnlyProperty data$delegate;
    @NotNull
    private final ReadOnlyProperty headers$delegate;
    @NotNull
    private final ReadOnlyProperty userAgent$delegate;
    @NotNull
    private final ReadOnlyProperty connectTimeout$delegate;
    @NotNull
    private final ReadOnlyProperty readTimeout$delegate;
    @NotNull
    private final ReadOnlyProperty callTimeout$delegate;
    @NotNull
    private final ReadOnlyProperty followRedirects$delegate;
    @NotNull
    private final ReadOnlyProperty allowInsecure$delegate;
    @NotNull
    private final ReadOnlyProperty showHeaders$delegate;
    @NotNull
    private final ReadOnlyProperty showHttp2Frames$delegate;
    @NotNull
    private final ReadOnlyProperty referer$delegate;
    @NotNull
    private final ReadOnlyProperty verbose$delegate;
    @NotNull
    private final ReadOnlyProperty sslDebug$delegate;
    @NotNull
    private final ReadOnlyProperty url$delegate;
    @Nullable
    private Call.Factory client;
    @NotNull
    public static final String NAME = "okcurl";
    public static final int DEFAULT_TIMEOUT = -1;

    public Main() {
        super(NAME);
        this.printHelpOnEmptyArgs = true;
        String[] stringArray = new String[]{"-X", "--request"};
        this.method$delegate = OptionWithValuesKt.help(OptionWithValuesKt.option$default(this, stringArray, null, null, false, null, null, null, null, false, 510, null), "Specify request command to use").provideDelegate(this, (KProperty<?>)$$delegatedProperties[0]);
        stringArray = new String[]{"-d", "--data"};
        this.data$delegate = OptionWithValuesKt.help(OptionWithValuesKt.option$default(this, stringArray, null, null, false, null, null, null, null, false, 510, null), "HTTP POST data").provideDelegate(this, (KProperty<?>)$$delegatedProperties[1]);
        stringArray = new String[]{"-H", "--header"};
        this.headers$delegate = OptionWithValuesKt.multiple$default(OptionWithValuesKt.help(OptionWithValuesKt.option$default(this, stringArray, null, null, false, null, null, null, null, false, 510, null), "Custom header to pass to server"), null, false, 3, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[2]);
        stringArray = new String[]{"-A", "--user-agent"};
        this.userAgent$delegate = OptionWithValuesKt.default$default(OptionWithValuesKt.help(OptionWithValuesKt.option$default(this, stringArray, null, null, false, null, null, null, null, false, 510, null), "User-Agent to send to server"), "okcurl/" + Main.Companion.versionString(), null, 2, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[3]);
        stringArray = new String[]{"--connect-timeout"};
        this.connectTimeout$delegate = OptionWithValuesKt.default$default(IntKt.int$default(OptionWithValuesKt.help(OptionWithValuesKt.option$default(this, stringArray, null, null, false, null, null, null, null, false, 510, null), "Maximum time allowed for connection (seconds)"), false, 1, null), -1, null, 2, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[4]);
        stringArray = new String[]{"--read-timeout"};
        this.readTimeout$delegate = OptionWithValuesKt.default$default(IntKt.int$default(OptionWithValuesKt.help(OptionWithValuesKt.option$default(this, stringArray, null, null, false, null, null, null, null, false, 510, null), "Maximum time allowed for reading data (seconds)"), false, 1, null), -1, null, 2, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[5]);
        stringArray = new String[]{"--call-timeout"};
        this.callTimeout$delegate = OptionWithValuesKt.default$default(IntKt.int$default(OptionWithValuesKt.help(OptionWithValuesKt.option$default(this, stringArray, null, null, false, null, null, null, null, false, 510, null), "Maximum time allowed for the entire call (seconds)"), false, 1, null), -1, null, 2, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[6]);
        stringArray = new String[]{"-L", "--location"};
        this.followRedirects$delegate = FlagOptionKt.flag$default(OptionWithValuesKt.help(OptionWithValuesKt.option$default(this, stringArray, null, null, false, null, null, null, null, false, 510, null), "Follow redirects"), new String[0], false, null, 6, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[7]);
        stringArray = new String[]{"-k", "--insecure"};
        this.allowInsecure$delegate = FlagOptionKt.flag$default(OptionWithValuesKt.help(OptionWithValuesKt.option$default(this, stringArray, null, null, false, null, null, null, null, false, 510, null), "Allow connections to SSL sites without certs"), new String[0], false, null, 6, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[8]);
        stringArray = new String[]{"-i", "--include"};
        this.showHeaders$delegate = FlagOptionKt.flag$default(OptionWithValuesKt.help(OptionWithValuesKt.option$default(this, stringArray, null, null, false, null, null, null, null, false, 510, null), "Include protocol headers in the output"), new String[0], false, null, 6, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[9]);
        stringArray = new String[]{"--frames"};
        this.showHttp2Frames$delegate = FlagOptionKt.flag$default(OptionWithValuesKt.help(OptionWithValuesKt.option$default(this, stringArray, null, null, false, null, null, null, null, false, 510, null), "Log HTTP/2 frames to STDERR"), new String[0], false, null, 6, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[10]);
        stringArray = new String[]{"-e", "--referer"};
        this.referer$delegate = OptionWithValuesKt.help(OptionWithValuesKt.option$default(this, stringArray, null, null, false, null, null, null, null, false, 510, null), "Referer URL").provideDelegate(this, (KProperty<?>)$$delegatedProperties[11]);
        stringArray = new String[]{"-v", "--verbose"};
        this.verbose$delegate = FlagOptionKt.flag$default(OptionWithValuesKt.help(OptionWithValuesKt.option$default(this, stringArray, null, null, false, null, null, null, null, false, 510, null), "Makes okcurl verbose during the operation"), new String[0], false, null, 6, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[12]);
        stringArray = new String[]{"--sslDebug"};
        this.sslDebug$delegate = FlagOptionKt.flag$default(OptionWithValuesKt.help(OptionWithValuesKt.option$default(this, stringArray, null, null, false, null, null, null, null, false, 510, null), "Output SSL Debug"), new String[0], false, null, 6, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[13]);
        this.url$delegate = (ReadOnlyProperty)ArgumentKt.help(ArgumentKt.argument$default(this, "url", null, null, null, 14, null), "Remote resource URL").provideDelegate(this, $$delegatedProperties[14]);
    }

    @Override
    public boolean getPrintHelpOnEmptyArgs() {
        return this.printHelpOnEmptyArgs;
    }

    @Override
    @NotNull
    public String help(@NotNull Context context) {
        Intrinsics.checkNotNullParameter(context, "context");
        return "A curl for the next-generation web.";
    }

    @Nullable
    public final String getMethod() {
        return (String)this.method$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Nullable
    public final String getData() {
        return (String)this.data$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @Nullable
    public final List<String> getHeaders() {
        return (List)this.headers$delegate.getValue(this, $$delegatedProperties[2]);
    }

    @NotNull
    public final String getUserAgent() {
        return (String)this.userAgent$delegate.getValue(this, $$delegatedProperties[3]);
    }

    public final int getConnectTimeout() {
        return ((Number)this.connectTimeout$delegate.getValue(this, $$delegatedProperties[4])).intValue();
    }

    public final int getReadTimeout() {
        return ((Number)this.readTimeout$delegate.getValue(this, $$delegatedProperties[5])).intValue();
    }

    public final int getCallTimeout() {
        return ((Number)this.callTimeout$delegate.getValue(this, $$delegatedProperties[6])).intValue();
    }

    public final boolean getFollowRedirects() {
        return (Boolean)this.followRedirects$delegate.getValue(this, $$delegatedProperties[7]);
    }

    public final boolean getAllowInsecure() {
        return (Boolean)this.allowInsecure$delegate.getValue(this, $$delegatedProperties[8]);
    }

    public final boolean getShowHeaders() {
        return (Boolean)this.showHeaders$delegate.getValue(this, $$delegatedProperties[9]);
    }

    public final boolean getShowHttp2Frames() {
        return (Boolean)this.showHttp2Frames$delegate.getValue(this, $$delegatedProperties[10]);
    }

    @Nullable
    public final String getReferer() {
        return (String)this.referer$delegate.getValue(this, $$delegatedProperties[11]);
    }

    public final boolean getVerbose() {
        return (Boolean)this.verbose$delegate.getValue(this, $$delegatedProperties[12]);
    }

    public final boolean getSslDebug() {
        return (Boolean)this.sslDebug$delegate.getValue(this, $$delegatedProperties[13]);
    }

    @Nullable
    public final String getUrl() {
        return (String)this.url$delegate.getValue(this, $$delegatedProperties[14]);
    }

    @Nullable
    public final Call.Factory getClient() {
        return this.client;
    }

    public final void setClient(@Nullable Call.Factory factory) {
        this.client = factory;
    }

    @Override
    public void run() {
        LoggingUtil.Companion.configureLogging(this.getVerbose(), this.getShowHttp2Frames(), this.getSslDebug());
        _MainCommonKt.commonRun(this);
    }

    @NotNull
    public final Request createRequest() {
        return _MainCommonKt.commonCreateRequest(this);
    }

    @NotNull
    public final Call.Factory createClient() {
        OkHttpClient.Builder builder2 = new OkHttpClient.Builder();
        builder2.followSslRedirects(this.getFollowRedirects());
        if (this.getConnectTimeout() != -1) {
            builder2.connectTimeout(this.getConnectTimeout(), TimeUnit.SECONDS);
        }
        if (this.getReadTimeout() != -1) {
            builder2.readTimeout(this.getReadTimeout(), TimeUnit.SECONDS);
        }
        if (this.getCallTimeout() != -1) {
            builder2.callTimeout(this.getCallTimeout(), TimeUnit.SECONDS);
        }
        if (this.getAllowInsecure()) {
            X509TrustManager trustManager = Main.Companion.createInsecureTrustManager();
            SSLSocketFactory sslSocketFactory = Main.Companion.createInsecureSslSocketFactory(trustManager);
            builder2.sslSocketFactory(sslSocketFactory, trustManager);
            builder2.hostnameVerifier(Main.Companion.createInsecureHostnameVerifier());
        }
        if (this.getVerbose()) {
            HttpLoggingInterceptor.Logger logger2 = createClient.logger.1.INSTANCE;
            builder2.eventListenerFactory(new LoggingEventListener.Factory(logger2));
        }
        return builder2.build();
    }

    public final void close() {
        Call.Factory factory = this.client;
        Intrinsics.checkNotNull(factory, "null cannot be cast to non-null type okhttp3.OkHttpClient");
        OkHttpClient okHttpClient = (OkHttpClient)factory;
        okHttpClient.connectionPool().evictAll();
        okHttpClient.dispatcher().executorService().shutdownNow();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Main.class, "method", "getMethod()Ljava/lang/String;", 0)), Reflection.property1(new PropertyReference1Impl(Main.class, "data", "getData()Ljava/lang/String;", 0)), Reflection.property1(new PropertyReference1Impl(Main.class, "headers", "getHeaders()Ljava/util/List;", 0)), Reflection.property1(new PropertyReference1Impl(Main.class, "userAgent", "getUserAgent()Ljava/lang/String;", 0)), Reflection.property1(new PropertyReference1Impl(Main.class, "connectTimeout", "getConnectTimeout()I", 0)), Reflection.property1(new PropertyReference1Impl(Main.class, "readTimeout", "getReadTimeout()I", 0)), Reflection.property1(new PropertyReference1Impl(Main.class, "callTimeout", "getCallTimeout()I", 0)), Reflection.property1(new PropertyReference1Impl(Main.class, "followRedirects", "getFollowRedirects()Z", 0)), Reflection.property1(new PropertyReference1Impl(Main.class, "allowInsecure", "getAllowInsecure()Z", 0)), Reflection.property1(new PropertyReference1Impl(Main.class, "showHeaders", "getShowHeaders()Z", 0)), Reflection.property1(new PropertyReference1Impl(Main.class, "showHttp2Frames", "getShowHttp2Frames()Z", 0)), Reflection.property1(new PropertyReference1Impl(Main.class, "referer", "getReferer()Ljava/lang/String;", 0)), Reflection.property1(new PropertyReference1Impl(Main.class, "verbose", "getVerbose()Z", 0)), Reflection.property1(new PropertyReference1Impl(Main.class, "sslDebug", "getSslDebug()Z", 0)), Reflection.property1(new PropertyReference1Impl(Main.class, "url", "getUrl()Ljava/lang/String;", 0))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lokhttp3/curl/Main$Companion;", "", "<init>", "()V", "NAME", "", "DEFAULT_TIMEOUT", "", "versionString", "createInsecureTrustManager", "Ljavax/net/ssl/X509TrustManager;", "createInsecureSslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "trustManager", "Ljavax/net/ssl/TrustManager;", "createInsecureHostnameVerifier", "Ljavax/net/ssl/HostnameVerifier;", "okcurl"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String versionString() {
            Properties prop = new Properties();
            InputStream inputStream2 = Main.class.getResourceAsStream("/okcurl-version.properties");
            if (inputStream2 != null) {
                Closeable closeable = inputStream2;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    prop.load(it);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
            return prop.getProperty("version", "dev");
        }

        private final X509TrustManager createInsecureTrustManager() {
            return new X509TrustManager(){

                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                    Intrinsics.checkNotNullParameter(chain, "chain");
                    Intrinsics.checkNotNullParameter(authType, "authType");
                }

                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                    Intrinsics.checkNotNullParameter(chain, "chain");
                    Intrinsics.checkNotNullParameter(authType, "authType");
                }

                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
        }

        private final SSLSocketFactory createInsecureSslSocketFactory(TrustManager trustManager) {
            SSLContext sSLContext;
            SSLContext $this$createInsecureSslSocketFactory_u24lambda_u241 = sSLContext = Platform.Companion.get().newSSLContext();
            boolean bl = false;
            TrustManager[] trustManagerArray = new TrustManager[]{trustManager};
            $this$createInsecureSslSocketFactory_u24lambda_u241.init(null, trustManagerArray, null);
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            Intrinsics.checkNotNullExpressionValue(sSLSocketFactory, "getSocketFactory(...)");
            return sSLSocketFactory;
        }

        private final HostnameVerifier createInsecureHostnameVerifier() {
            return Companion::createInsecureHostnameVerifier$lambda$2;
        }

        private static final boolean createInsecureHostnameVerifier$lambda$2(String string, SSLSession sSLSession) {
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

