/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.sse;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Options;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0002\u0011\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lokhttp3/internal/sse/ServerSentEventReader;", "", "source", "Lokio/BufferedSource;", "callback", "Lokhttp3/internal/sse/ServerSentEventReader$Callback;", "(Lokio/BufferedSource;Lokhttp3/internal/sse/ServerSentEventReader$Callback;)V", "lastId", "", "completeEvent", "", "id", "type", "data", "Lokio/Buffer;", "processNextEvent", "", "Callback", "Companion", "okhttp-sse"})
public final class ServerSentEventReader {
    private String lastId;
    private final BufferedSource source;
    private final Callback callback;
    @NotNull
    private static final Options options;
    private static final ByteString CRLF;
    public static final Companion Companion;

    public final boolean processNextEvent() throws IOException {
        block9: {
            String id = this.lastId;
            String type = null;
            Buffer data = new Buffer();
            while (true) {
                boolean bl;
                CharSequence charSequence;
                String it;
                boolean bl2;
                boolean bl3;
                int n;
                int n2;
                if (0 <= (n2 = (n = this.source.select(options))) && 2 >= n2) {
                    this.completeEvent(id, type, data);
                    return true;
                }
                n2 = n;
                if (3 <= n2 && 4 >= n2) {
                    ServerSentEventReader.Companion.readData(this.source, data);
                    continue;
                }
                n2 = n;
                if (5 <= n2 && 7 >= n2) {
                    data.writeByte(10);
                    continue;
                }
                n2 = n;
                if (8 <= n2 && 9 >= n2) {
                    String string = this.source.readUtf8LineStrict();
                    bl3 = false;
                    bl2 = false;
                    it = string;
                    boolean bl4 = false;
                    charSequence = it;
                    bl = false;
                    id = charSequence.length() > 0 ? string : null;
                    continue;
                }
                n2 = n;
                if (10 <= n2 && 12 >= n2) {
                    id = null;
                    continue;
                }
                n2 = n;
                if (13 <= n2 && 14 >= n2) {
                    String string = this.source.readUtf8LineStrict();
                    bl3 = false;
                    bl2 = false;
                    it = string;
                    boolean bl5 = false;
                    charSequence = it;
                    bl = false;
                    type = charSequence.length() > 0 ? string : null;
                    continue;
                }
                n2 = n;
                if (15 <= n2 && 17 >= n2) {
                    type = null;
                    continue;
                }
                n2 = n;
                if (18 <= n2 && 19 >= n2) {
                    long retryMs = ServerSentEventReader.Companion.readRetryMs(this.source);
                    if (retryMs == -1L) continue;
                    this.callback.onRetryChange(retryMs);
                    continue;
                }
                if (n != -1) break block9;
                long lineEnd = this.source.indexOfElement(CRLF);
                if (lineEnd == -1L) break;
                this.source.skip(lineEnd);
                this.source.select(options);
            }
            return false;
        }
        throw (Throwable)((Object)new AssertionError());
    }

    private final void completeEvent(String id, String type, Buffer data) throws IOException {
        if (data.size() != 0L) {
            this.lastId = id;
            data.skip(1L);
            this.callback.onEvent(id, type, data.readUtf8());
        }
    }

    public ServerSentEventReader(@NotNull BufferedSource source, @NotNull Callback callback) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        this.source = source;
        this.callback = callback;
    }

    static {
        Companion = new Companion(null);
        options = Options.Companion.of(new ByteString[]{ByteString.Companion.encodeUtf8("\r\n"), ByteString.Companion.encodeUtf8("\r"), ByteString.Companion.encodeUtf8("\n"), ByteString.Companion.encodeUtf8("data: "), ByteString.Companion.encodeUtf8("data:"), ByteString.Companion.encodeUtf8("data\r\n"), ByteString.Companion.encodeUtf8("data\r"), ByteString.Companion.encodeUtf8("data\n"), ByteString.Companion.encodeUtf8("id: "), ByteString.Companion.encodeUtf8("id:"), ByteString.Companion.encodeUtf8("id\r\n"), ByteString.Companion.encodeUtf8("id\r"), ByteString.Companion.encodeUtf8("id\n"), ByteString.Companion.encodeUtf8("event: "), ByteString.Companion.encodeUtf8("event:"), ByteString.Companion.encodeUtf8("event\r\n"), ByteString.Companion.encodeUtf8("event\r"), ByteString.Companion.encodeUtf8("event\n"), ByteString.Companion.encodeUtf8("retry: "), ByteString.Companion.encodeUtf8("retry:")});
        CRLF = ByteString.Companion.encodeUtf8("\r\n");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\bf\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u0005H&J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH&\u00a8\u0006\u000b"}, d2={"Lokhttp3/internal/sse/ServerSentEventReader$Callback;", "", "onEvent", "", "id", "", "type", "data", "onRetryChange", "timeMs", "", "okhttp-sse"})
    public static interface Callback {
        public void onEvent(@Nullable String var1, @Nullable String var2, @NotNull String var3);

        public void onRetryChange(long var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lokhttp3/internal/sse/ServerSentEventReader$Companion;", "", "()V", "CRLF", "Lokio/ByteString;", "options", "Lokio/Options;", "getOptions", "()Lokio/Options;", "readData", "", "Lokio/BufferedSource;", "data", "Lokio/Buffer;", "readRetryMs", "", "okhttp-sse"})
    public static final class Companion {
        @NotNull
        public final Options getOptions() {
            return options;
        }

        private final void readData(@NotNull BufferedSource $this$readData, Buffer data) throws IOException {
            data.writeByte(10);
            $this$readData.readFully(data, $this$readData.indexOfElement(CRLF));
            $this$readData.select(this.getOptions());
        }

        private final long readRetryMs(@NotNull BufferedSource $this$readRetryMs) throws IOException {
            String retryString = $this$readRetryMs.readUtf8LineStrict();
            return Util.toLongOrDefault((String)retryString, (long)-1L);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

