/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.slack;

import java.io.Closeable;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.LinkedHashMap;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import okhttp3.slack.OAuthSession;
import okhttp3.slack.SlackApi;
import okio.ByteString;

public final class OAuthSessionFactory
extends Dispatcher
implements Closeable {
    private final SecureRandom secureRandom = new SecureRandom();
    private final SlackApi slackApi;
    private MockWebServer mockWebServer;
    private Map<ByteString, Listener> listeners = new LinkedHashMap<ByteString, Listener>();

    public OAuthSessionFactory(SlackApi slackApi) {
        this.slackApi = slackApi;
    }

    public void start() throws Exception {
        if (this.mockWebServer != null) {
            throw new IllegalStateException();
        }
        this.mockWebServer = new MockWebServer();
        this.mockWebServer.setDispatcher((Dispatcher)this);
        this.mockWebServer.start(this.slackApi.port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpUrl newAuthorizeUrl(String scopes, String team, Listener listener) {
        if (this.mockWebServer == null) {
            throw new IllegalStateException();
        }
        ByteString state = this.randomToken();
        OAuthSessionFactory oAuthSessionFactory = this;
        synchronized (oAuthSessionFactory) {
            this.listeners.put(state, listener);
        }
        return this.slackApi.authorizeUrl(scopes, this.redirectUrl(), state, team);
    }

    private ByteString randomToken() {
        byte[] bytes = new byte[16];
        this.secureRandom.nextBytes(bytes);
        return ByteString.of((byte[])bytes);
    }

    private HttpUrl redirectUrl() {
        return this.mockWebServer.url("/oauth/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MockResponse dispatch(RecordedRequest request) {
        Listener listener;
        HttpUrl requestUrl = this.mockWebServer.url(request.getPath());
        String code = requestUrl.queryParameter("code");
        String stateString = requestUrl.queryParameter("state");
        ByteString state = stateString != null ? ByteString.decodeBase64((String)stateString) : null;
        OAuthSessionFactory oAuthSessionFactory = this;
        synchronized (oAuthSessionFactory) {
            listener = this.listeners.get(state);
        }
        if (code == null || listener == null) {
            return new MockResponse().setResponseCode(404).setBody("unexpected request");
        }
        try {
            OAuthSession session = this.slackApi.exchangeCode(code, this.redirectUrl());
            listener.sessionGranted(session);
        }
        catch (IOException e) {
            return new MockResponse().setResponseCode(400).setBody("code exchange failed: " + e.getMessage());
        }
        oAuthSessionFactory = this;
        synchronized (oAuthSessionFactory) {
            this.listeners.remove(state);
        }
        return new MockResponse().setResponseCode(302).addHeader("Location", (Object)"https://twitter.com/CuteEmergency/status/789457462864863232");
    }

    @Override
    public void close() {
        if (this.mockWebServer == null) {
            throw new IllegalStateException();
        }
        try {
            this.mockWebServer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static interface Listener {
        public void sessionGranted(OAuthSession var1);
    }
}

