/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.slack;

import java.io.Closeable;
import java.io.IOException;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.slack.RtmStartResponse;
import okhttp3.slack.SlackApi;

public final class RtmSession
extends WebSocketListener
implements Closeable {
    private final SlackApi slackApi;
    private WebSocket webSocket;

    public RtmSession(SlackApi slackApi) {
        this.slackApi = slackApi;
    }

    public void open(String accessToken) throws IOException {
        if (this.webSocket != null) {
            throw new IllegalStateException();
        }
        RtmStartResponse rtmStartResponse = this.slackApi.rtmStart(accessToken);
        this.webSocket = this.slackApi.rtm(rtmStartResponse.url, this);
    }

    public synchronized void onOpen(WebSocket webSocket, Response response) {
        System.out.println("onOpen: " + response);
    }

    public void onMessage(WebSocket webSocket, String text) {
        System.out.println("onMessage: " + text);
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        webSocket.close(1000, null);
        System.out.println("onClose (" + code + "): " + reason);
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        System.out.println("onFailure " + response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        WebSocket webSocket;
        if (this.webSocket == null) {
            return;
        }
        RtmSession rtmSession = this;
        synchronized (rtmSession) {
            webSocket = this.webSocket;
        }
        if (webSocket != null) {
            webSocket.close(1000, "bye");
        }
    }
}

