/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.slack;

import com.squareup.moshi.FromJson;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.ToJson;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.slack.OAuthSession;
import okhttp3.slack.RtmStartResponse;
import okio.ByteString;

public final class SlackApi {
    private final HttpUrl baseUrl = HttpUrl.get((String)"https://slack.com/api/");
    private final OkHttpClient httpClient = new OkHttpClient.Builder().build();
    private final Moshi moshi = new Moshi.Builder().add((Object)new SlackJsonAdapters()).build();
    public final String clientId;
    public final String clientSecret;
    public final int port;

    public SlackApi(String clientId, String clientSecret, int port) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.port = port;
    }

    public HttpUrl authorizeUrl(String scopes, HttpUrl redirectUrl, ByteString state, String team) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder("/oauth/authorize").addQueryParameter("client_id", this.clientId).addQueryParameter("scope", scopes).addQueryParameter("redirect_uri", redirectUrl.toString()).addQueryParameter("state", state.base64());
        if (team != null) {
            builder.addQueryParameter("team", team);
        }
        return builder.build();
    }

    public OAuthSession exchangeCode(String code, HttpUrl redirectUrl) throws IOException {
        HttpUrl url = this.baseUrl.newBuilder("oauth.access").addQueryParameter("client_id", this.clientId).addQueryParameter("client_secret", this.clientSecret).addQueryParameter("code", code).addQueryParameter("redirect_uri", redirectUrl.toString()).build();
        Request request = new Request.Builder().url(url).build();
        Call call = this.httpClient.newCall(request);
        try (Response response = call.execute();){
            JsonAdapter jsonAdapter = this.moshi.adapter(OAuthSession.class);
            OAuthSession oAuthSession = (OAuthSession)jsonAdapter.fromJson(response.body().source());
            return oAuthSession;
        }
    }

    public RtmStartResponse rtmStart(String accessToken) throws IOException {
        HttpUrl url = this.baseUrl.newBuilder("rtm.start").addQueryParameter("token", accessToken).build();
        Request request = new Request.Builder().url(url).build();
        Call call = this.httpClient.newCall(request);
        try (Response response = call.execute();){
            JsonAdapter jsonAdapter = this.moshi.adapter(RtmStartResponse.class);
            RtmStartResponse rtmStartResponse = (RtmStartResponse)jsonAdapter.fromJson(response.body().source());
            return rtmStartResponse;
        }
    }

    public WebSocket rtm(HttpUrl url, WebSocketListener listener) {
        return this.httpClient.newWebSocket(new Request.Builder().url(url).build(), listener);
    }

    static final class SlackJsonAdapters {
        SlackJsonAdapters() {
        }

        @ToJson
        String urlToJson(HttpUrl httpUrl) {
            return httpUrl.toString();
        }

        @FromJson
        HttpUrl urlFromJson(String urlString) {
            if (urlString.startsWith("wss:")) {
                urlString = "https:" + urlString.substring(4);
            }
            if (urlString.startsWith("ws:")) {
                urlString = "http:" + urlString.substring(3);
            }
            return HttpUrl.get((String)urlString);
        }
    }
}

